import dbus
import pygtk
pygtk.require('2.0')
import gtk
import gobject

import sugar.env
from sugar.presence import Service

from WordProcessorActivity import WordProcessorActivity

class WordProcessorShell(dbus.service.Object):
	def __init__(self, bus_name, object_path = '/com/redhat/Sugar/WordProcessor'):
		dbus.service.Object.__init__(self, bus_name, object_path)
		
		#geckoembed.set_profile_path(sugar.env.get_user_dir())
		self.__documents = []

	def start(self):
		gtk.main()

	#@dbus.service.method('com.redhat.Sugar.BrowserShell')
	#def get_links(self):
	#	links = []
	#	for browser in self.__browsers:
	#		embed = browser.get_embed()
	#		link = {}
	#		link['title'] = embed.get_title()
	#		link['address'] = embed.get_address()
	#		links.append(link)
	#	return links

	def _start_wordprocessor_cb(self, wordprocessor, service):
		wordprocessor.connect_to_shell(service)

	@dbus.service.method('com.redhat.Sugar.WordProcessorShell')
	def open_new_document(self, serialized_service=None):
		service = None
		if serialized_service is not None:
			service = Service.deserialize(serialized_service)
		wordprocessor = WordProcessorActivity()
		self.__documents.append(wordprocessor)
		gobject.idle_add(self._start_wordprocessor_cb, wordprocessor, service)

	#@dbus.service.method('com.redhat.Sugar.BrowserShell')
	#def open_browser_from_service_foobar(self, uri, serialized_service):
	#	service = Service.deserialize(serialized_service)
	#	browser = BrowserActivity(uri)
	#	self.__browsers.append(browser)
	#	gobject.idle_add(self._start_browser_cb, browser, service)
