import logging
import xml.sax.saxutils

import pygtk
pygtk.require('2.0')
import gtk

from sugar.activity.Activity import Activity
from sugar.presence.PresenceService import PresenceService
from sugar.p2p.model.LocalModel import LocalModel
from sugar.p2p.model.RemoteModel import RemoteModel

_WORDPROCESSOR_ACTIVITY_TYPE = "_web_olpc._udp"
_SERVICE_URI_TAG = "URI"
_SERVICE_TITLE_TAG = "Title"

class WordProcessorActivity(Activity):
	SOLO = 1
	FOLLOWING = 2
	LEADING = 3

	def __init__(self, uri = None, mode = SOLO):
		Activity.__init__(self, _WORDPROCESSOR_ACTIVITY_TYPE)
		self.uri = uri
		self._mode = mode
		
		self._share_service = None
		self._model_service = None
		self._notif_service = None
		self._model = None
	
	def get_default_type(self):
		return _WORDPROCESSOR_ACTIVITY_TYPE
	
	def _update_shared_location(self):
		address = self.embed.get_address()
		self._model.set_value('address', address)
		title = self.embed.get_title()
		self._model.set_value('title', title)

	def on_connected_to_shell(self):
		self.set_ellipsize_tab(True)
		self.set_can_close(True)
		self.set_tab_text("AbiWord")
		self.set_tab_icon(name="web-browser")
		self.set_show_tab_icon(True)

		vbox = gtk.VBox()

		plug = self.gtk_plug()		
		plug.add(vbox);
		plug.show()
		vbox.show()

		socket = gtk.Socket()
		socket.show()
		vbox.add(socket)
		socket.add_id(50331699)

		logging.debug('Start presence service')
		self._pservice = PresenceService.get_instance()
		self._pservice.start()
		
		logging.debug('Track wordprocessor activities')
		self._pservice.connect('service-appeared', self._service_appeared_cb)
		self._pservice.track_service_type(_WORDPROCESSOR_ACTIVITY_TYPE)
		self._pservice.track_service_type(LocalModel.SERVICE_TYPE)

		# Join the shared activity if we were started from one
		if self._initial_service:
			logging.debug("WordProcessorActivity joining shared activity %s" % self._initial_service.get_activity_id())
			self._pservice.join_shared_activity(self._initial_service)
	
	def publish(self):
		escaped_title = xml.sax.saxutils.escape(self.embed.get_title())
		escaped_url = xml.sax.saxutils.escape(self.embed.get_address())

		# Publish ourselves on the network
		properties = {_SERVICE_URI_TAG: escaped_url, _SERVICE_TITLE_TAG: escaped_title}
		self._share_service = self._pservice.share_activity(self,
				stype=_WORDPROCESSOR_ACTIVITY_TYPE, properties=properties)
		
		self.set_mode(WordProcessorActivity.LEADING)

	def __title_cb(self, embed):
		self.set_tab_text("abiword")
