import unittest
import operation
from xml.dom import minidom
from xml.dom.minidom import Document

class InclusionTestCase(unittest.TestCase):
	def setUp(self):
		pass
		
	def tearDown(self):
		pass

	#if P(O_a) < P(O_b) O_a' := O_a
	def testInclusionInsertInsertBefore(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 0)
		insert_b = operation.Insert(0, {0: 0}, "b", 10)
		result = insert_a.inclusionTransformation(insert_b)
		assert result[0].getPosition() == 0
	#else O_a' := [S(O_a), P(O_a)+L(O_b)]
	def testInclusionInsertInsertAfter(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 10)
		insert_b = operation.Insert(0, {0: 0}, "b", 0)
		result = insert_a.inclusionTransformation(insert_b)
		assert result[0].getPosition() == 11
	#if P(O_a) <= O_a' := O_a
	def testInclusionInsertDeleteBefore(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 0)
		delete_b = operation.Delete(0, {0: 0}, 3, 10)
		result = insert_a.inclusionTransformation(delete_b)
		assert result[0].getPosition() == 0
	#else if P(O_a) > (P(O_a)+L(O_b)) O_a' := [S(O_a), P(O_a)-L(O_b)]
	def testInclusionInsertDeleteAfter(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 10)
		delete_b = operation.Delete(0, {0: 0}, 3, 0)
		result = insert_a.inclusionTransformation(delete_b)
		assert result[0].getPosition() == 7
	#else O_a' := [S(O_a), P(O_b)]
	def testInclusionInsertDeleteInside(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 5)
		delete_b = operation.Delete(0, {0: 0}, 3, 4)
		result = insert_a.inclusionTransformation(delete_b)
		assert result[0].getPosition() == 4
	
	#if P(O_b) >= (P(O_a) + L(O_a)) O_a' := O_a
	def testInclusionDeleteInsertBefore(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 1)
		insert_b = operation.Insert(0, {0: 0}, "b", 4)
		result = delete_a.inclusionTransformation(insert_b)
		assert result[0].getLength() == 2
		assert result[0].getPosition() == 1
	#if P(O_a) >= P(O_b) O_a' := [L(O_a),P(O_a)+L(O_b)]
	def testInclusionDeleteInsertAfter(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 10)
		insert_b = operation.Insert(0, {0: 0}, "b", 4)
		result = delete_a.inclusionTransformation(insert_b)
		assert result[0].getLength() == 2
		assert result[0].getPosition() == (10+1)
	#else
	def testInclusionDeleteInsertInside(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 5)
		insert_b = operation.Insert(0, {0: 0}, "b", 6)
		result = delete_a.inclusionTransformation(insert_b)
		assert result[0].getLength() == (6-5)
		assert result[0].getPosition() == 5
		assert result[1].getLength() == (2-(6-5))
		assert result[1].getPosition() == (6+1)
	
	#if P(O_b) >= (P(O_a)+L(O_a)) O_a' := O_a
	def testInclusionDeleteDeleteBefore(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 1)
		delete_b = operation.Delete(0, {0: 0}, 3, 5)
		result = delete_a.inclusionTransformation(delete_b)
		assert result[0].getLength() == 2
		assert result[0].getPosition() == 1
	#else if P(O_a) >= (P(O_b)+L(O_b)) O_a' := [L(O_a),P(O_a)-L(O_b)]
	def testInclusionDeleteDeleteAfter(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 5)
		delete_b = operation.Delete(0, {0: 0}, 3, 1)
		result = delete_a.inclusionTransformation(delete_b)
		assert result[0].getLength() == 2
		assert result[0].getPosition() == 5-3
	#else
	#if P(O_b) <= P(O_a) and (P(O_a)+L(O_a)) <= (P(O_b)+L(O_b)) O_a' := [0, P(O_a)]
	def testInclusionDeleteDeleteContained(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 2)
		delete_b = operation.Delete(0, {0: 0}, 3, 1)
		result = delete_a.inclusionTransformation(delete_b)
		assert result[0].getLength() == 0
		assert result[0].getPosition() == 2
	#if P(O_b) <= P(O_a) and (P(O_a)+L(O_a)) > (P(O_b)+L(O_b)) O_a' := [P(O_a)+L(O_a)-(P(O_b)+L(O_b)), P(O_b)]
	def testInclusionDeleteDeleteToRight(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 3)
		delete_b = operation.Delete(0, {0: 0}, 3, 1)
		result = delete_a.inclusionTransformation(delete_b)
		assert result[0].getLength() == (3+2-(1+3))
		assert result[0].getPosition() == 1
	#if P(O_b) > P(O_a) and (P(O_a)+L(O_a)) >= (P(O_b)+L(O_b)) O_a' := [P(O_b)-P(O_a), P(O_a)]
	def testInclusionDeleteDeleteToLeft(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 2)
		delete_b = operation.Delete(0, {0: 0}, 3, 3)
		result = delete_a.inclusionTransformation(delete_b)
		assert result[0].getLength() == (3-2)
		assert result[0].getPosition() == 2
	#else O_a' := [P(O_b)-P(O_a), P(O_a)]
	def testInclusionDeleteDeleteOverlap(self):
		delete_a = operation.Delete(0, {0: 0}, 5, 3)
		delete_b = operation.Delete(0, {0: 0}, 3, 3)
		result = delete_a.inclusionTransformation(delete_b)
		assert result[0].getLength() == (5-3)
		assert result[0].getPosition() == 3

class ExclusionTestCase(unittest.TestCase):
	def setUp(self):
		pass
	def tearDown(self):
		pass
	
	#if P(O_a) <= P(O_b) O_a' := O_a
	def testExclusionInsertInsertBefore(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 0)
		insert_b = operation.Insert(0, {0: 0}, "b", 10)
		result = insert_a.exclusionTransformation(insert_b)
		assert result[0].getPosition() == 0
		assert result[0].getString() == insert_a.getString() 
	#else P(O_a) >= (P(O_b) + L(O_b)) O_a' := [S(O_a), P(O_a)-L(O_b)]
	def testExclusionInsertInsertAfter(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 10)
		insert_b = operation.Insert(0, {0: 0}, "b", 0)
		result = insert_a.exclusionTransformation(insert_b)
		assert result[0].getPosition() == (10-1)
		assert result[0].getString() == insert_a.getString() 
	#else
	def testExclusionInsertInsertInside(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 1)
		insert_b = operation.Insert(0, {0: 0}, "ab", 0)
		result = insert_a.exclusionTransformation(insert_b)
		assert result[0].getPosition() == (1-0)
		assert result[0].getString() == insert_a.getString() 
	
	#if P(O_a) <= P(O_b) O_a' := O_a
	def testExclusionInsertDeleteBefore(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 0)
		delete_b = operation.Delete(0, {0: 0}, 3, 10)
		result = insert_a.exclusionTransformation(delete_b)
		assert result[0].getPosition() == 0
	#else
	def testExclusionInsertDeleteAfter(self):
		insert_a = operation.Insert(0, {0: 0}, "a", 10)
		delete_b = operation.Delete(0, {0: 0}, 3, 0)
		result = insert_a.exclusionTransformation(delete_b)
		assert result[0].getPosition() == (10+3)
	
	#if P(O_b) >= (P(O_a) + L(O_a)) O_a' := O_a
	def testExclusionDeleteInsertBefore(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 1)
		insert_b = operation.Insert(0, {0: 0}, "b", 4)
		result = delete_a.exclusionTransformation(insert_b)
		assert result[0].getPosition() == 1
		assert result[0].getLength() == delete_a.getLength()
	#if P(O_a) >= (P(O_b)+L(O_b)) O_a' := [L(O_a), P(O_a)-L(O_b)]
	def testExclusionDeleteInsertAfter(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 10)
		insert_b = operation.Insert(0, {0: 0}, "b", 4)
		result = delete_a.exclusionTransformation(insert_b)
		assert result[0].getPosition() == (10-1)
		assert result[0].getLength() == delete_a.getLength()
	#else
	#if P(O_b) <= P(O_a) and (P(O_a) + L(O_a)) <= (P(O_b)+L(O_b))
	def testExclusionDeleteInsertInside(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 6)
		insert_b = operation.Insert(0, {0: 0}, "abcde", 5)
		result = delete_a.exclusionTransformation(insert_b)
		assert result[0].getPosition() == (6-5)
		assert result[0].getLength() == delete_a.getLength()
	#if P(O_b) <= P(O_a) and (P(O_a) + L(O_a)) > (P(O_b)+L(O_b))
	def testExclusionDeleteInsertInsideAndPast(self):
		delete_a = operation.Delete(0, {0: 0}, 7, 6)
		insert_b = operation.Insert(0, {0: 0}, "abcde", 5)
		result = delete_a.exclusionTransformation(insert_b)
		assert result[0].getPosition() == (6-5)
		assert result[0].getLength() == (5+5-6)
	#if P(O_a) < P(O_b) and (P(O_b) + L(O_b)) <= (P(O_a)+L(O_a))
	def testExclusionDeleteInsertEnclose(self):
		delete_a = operation.Delete(0, {0: 0}, 7, 4)
		insert_b = operation.Insert(0, {0: 0}, "abcde", 5)
		result = delete_a.exclusionTransformation(insert_b)
		assert result[0].getPosition() == 0
		assert result[0].getLength() == 5
		assert result[1].getPosition() == 4
		assert result[1].getLength() == (7-5)
	#else
	def testExclusionDeleteInsertOverlapLeft(self):
		delete_a = operation.Delete(0, {0: 0}, 3, 4)
		insert_b = operation.Insert(0, {0: 0}, "abcde", 5)
		result = delete_a.exclusionTransformation(insert_b)
		assert result[0].getPosition() == 0
		assert result[0].getLength() == (4+3-5)
		assert result[1].getPosition() == 4
		assert result[1].getLength() == (5-4)
	
	#if Check_LI(O_a, O_b)
	def testExclusionDeleteDeleteCheckLI(self):
		pass
	#else if P(O_b) >= (P(O_a)+L(O_a)) O_a' := O_a
	def testExclusionDeleteDeleteAfter(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 1)
		delete_b = operation.Delete(0, {0: 0}, 3, 5)
		result = delete_a.exclusionTransformation(delete_b)
		assert result[0].getPosition() == 1
		assert result[0].getLength() == 2
	#else if P(O_b) <= P(O_a) O_a' := [L(O_a), P(O_a)+L(O_b)]
	def testExclusionDeleteDeleteBefore(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 3)
		delete_b = operation.Delete(0, {0: 0}, 3, 1)
		result = delete_a.exclusionTransformation(delete_b)
		assert result[0].getPosition() == (3+3)
		assert result[0].getLength() == 2
	#else
	def testExclusionDeleteDeleteInside(self):
		delete_a = operation.Delete(0, {0: 0}, 2, 2)
		delete_b = operation.Delete(0, {0: 0}, 3, 3)
		result = delete_a.exclusionTransformation(delete_b)
		assert result[0].getPosition() == 2
		assert result[0].getLength() == (3-2)
		assert result[1].getPosition() == (3+3)
		assert result[1].getLength() == (2-(3-2))

class CausalityTestCase(unittest.TestCase):
	def setUp(self):
		pass
	def tearDown(self):
		pass
	def testCausalityFail(self):
		delete_a = operation.Delete(0, {0: 2}, 2, 2)
		assert delete_a.isStable({0:0}) == False
	def testCausalitySuccess(self):
		delete_a = operation.Delete(0, {0: 2}, 2, 2)
		assert delete_a.isStable({0:1}) == True

if __name__ == "__main__":
	unittest.main()

