import unittest
import operation
import control
from xml.dom import minidom
from xml.dom.minidom import Document


class GOTTestCase(unittest.TestCase):
	def setUp(self):
		pass
		
	def tearDown(self):
		pass

	def testInsert(self):
		buffer = ['A','B','C','D','E','F','G','H','','','','','','']
		historyBuffer = control.HistoryBuffer(buffer)
		operation1 = operation.Insert(0,{0:1,1:0,2:0},"CD",1)
		historyBuffer.newOperation(operation1)
		assert buffer == ['A', 'C', 'D', 'B', 'C', 'D', 'E', 'F', 'G', 'H', '', '', '', '', '', '']
	def testDelete(self):
		buffer = ['A','B','C','D','E','F','G','H','','','','','','']
		historyBuffer = control.HistoryBuffer(buffer)
		operation1 = operation.Delete(0,{0:1,1:0,2:0},2,1)
		historyBuffer.newOperation(operation1)
		assert buffer == ['A', 'D', 'E', 'F', 'G', 'H', '', '', '', '', '', '']
	def testIntegratedExample1(self):
		buffer = ['A','B','C','D','E','F','G','H','','','','','','']
		historyBuffer = control.HistoryBuffer(buffer)
		operation1 = operation.Delete(0,{0:1,1:0,2:0},3,2)
		historyBuffer.newOperation(operation1)
		print buffer
		operation2 = operation.Insert(1,{0:0,1:1,2:0},"abcd",4)
		historyBuffer.newOperation(operation2)
		print buffer
		operation4 = operation.Delete(2,{0:0,1:1,2:1},2,6)
		historyBuffer.newOperation(operation4)
		print buffer
		operation3 = operation.Delete(1,{0:1,1:2,2:0},4,5)
		historyBuffer.newOperation(operation3)
		print buffer
		assert buffer == ['A', 'B', 'a', 'b', '', '', '', '', '', '']
	def testIntegratedExample2(self):
		buffer = ['A','B','C','D','E','F','G','H','','','','','','']
		historyBuffer = control.HistoryBuffer(buffer)
		operation2 = operation.Insert(1,{0:0,1:1,2:0},"abcd",4)
		historyBuffer.newOperation(operation2)
		print buffer
		operation1 = operation.Delete(0,{0:1,1:0,2:0},3,2)
		historyBuffer.newOperation(operation1)
		print buffer
		operation3 = operation.Delete(1,{0:1,1:2,2:0},4,5)
		historyBuffer.newOperation(operation3)
		print buffer
		operation4 = operation.Delete(2,{0:0,1:1,2:1},2,6)
		historyBuffer.newOperation(operation4)
		print buffer
		assert buffer == ['A', 'B', 'a', 'b', '', '', '', '', '', '']
	def testIntegratedExample3(self):
		buffer = ['A','B','C','D','E','F','G','H','','','','','','']
		historyBuffer = control.HistoryBuffer(buffer)
		operation2 = operation.Insert(1,{0:0,1:1,2:0},"abcd",4)
		historyBuffer.newOperation(operation2)
		print buffer
		operation4 = operation.Delete(2,{0:0,1:1,2:1},2,6)
		historyBuffer.newOperation(operation4)
		print buffer
		operation1 = operation.Delete(0,{0:1,1:0,2:0},3,2)
		historyBuffer.newOperation(operation1)
		print buffer
		operation3 = operation.Delete(1,{0:1,1:2,2:0},4,5)
		historyBuffer.newOperation(operation3)
		print buffer
		assert buffer == ['A', 'B', 'a', 'b', '', '', '', '']
	def testStability(self):
		buffer = ['A','B','C','D','E','F','G','H','','','','','','']
		historyBuffer = control.HistoryBuffer(buffer)
		operation1 = operation.Insert(1,{0:1,1:2,2:0},"CD",1)
		historyBuffer.newOperation(operation1)
		operation2 = operation.Insert(0,{0:1,1:0,2:0},"12",1)
		historyBuffer.newOperation(operation2)
		operation3 = operation.Delete(1,{0:0,1:1,2:0},2,2)
		historyBuffer.newOperation(operation3)
		assert buffer == ['A', 'C', 'D', '1', '2', 'B', 'E', 'F', 'G', 'H', '', '', '', '', '', '']

if __name__ == "__main__":
	unittest.main()

