import operation as operations
import copy
from xml.dom import minidom

def reverseCopy(list):
	tempList = copy.copy(list)
	tempList.reverse()
	return tempList

class ReceivedBuffer(list):
	def stablize(self, historyBuffer, current):
		unstableQueue = True
		while unstableQueue:
			unstableQueue = False
			for operation in self:
				if operation.isStable(current):
					historyBuffer.apply(operation)
					self.remove(operation)
					unstableQueue = True

class HistoryBuffer(list):
	def __init__(self, buffer):
		self.receivedBuffer = ReceivedBuffer()
		self.current = {0: 0, 1: 0, 2: 0}
		self.buffer = buffer
	
	def newOperation(self,operation):
		self.receivedBuffer.append(operation)
		self.receivedBuffer.stablize(self, self.current)
	
	def apply(self,operation):
		undoneOperations = operations.OperationList()
		
		#Undo preceding Operations
		self.reverse()
		for appliedOperation in self:
			if (appliedOperation.compare(operation) != 1):
				undoneOperations.append(appliedOperation)
				appliedOperation.unapply(self.buffer)
				print self.buffer
				self.remove(appliedOperation)
		self.reverse()
		undoneOperations.reverse()
		
		#Transform operation and apply
		print self
		print "OPERATION:"+str(operation)
		newOperation = self.gotAlgorithm(operation)
		print "NEWOPERATION:"+str(newOperation)
		for subOperation in newOperation:
			subOperation.apply(self.buffer)
			self.append(subOperation)
		print self
		# What should the state vectors on the operations be?
		self.current[operation.getSite()] += 1
		
		#Redo preceding operations
		if len(undoneOperations) != 0:
			undoneOperationsPrimeList = undoneOperations.copy()
			undoneOperationsPrime = operations.OperationList()
			
			undoneOperationsPrimeList[0] = operations.OperationList([undoneOperations[0]]).listInclusionTransformation(newOperation)
			for subOperation in undoneOperationsPrimeList[0]:
				undoneOperationsPrime.append(subOperation)
			
			for i in range(1, len(undoneOperations)):
				tempOperation = operations.OperationList([undoneOperationsPrimeList[i]]).listExclusionTransformation(reverseCopy(undoneOperations[:i]))
				undoneOperationsPrimeList[i] = tempOperation.listInclusionTransformation(newOperation+undoneOperationsPrime[:i])
				for subOperation in undoneOperationsPrimeList[i]:
					undoneOperationsPrime.append(subOperation)
			del undoneOperations
			for primeOperation in undoneOperationsPrimeList:
				for subOperation in primeOperation:
					subOperation.apply(self.buffer)
					self.append(subOperation)
	
	def gotAlgorithm(self, operation):
		firstIndepOperation = None
		causalPreOperations = []
		k = 0

		#Part 1 - Find independent operation
		for appliedOperation in self:
			if (operation.isIndependentOf(appliedOperation)):
				firstIndepOperation = appliedOperation
				k = self.index(appliedOperation)
				break
		if (firstIndepOperation == None):
			return operations.OperationList([operation])
		
		#Part 2 - Causally preceding items before causally independent items
		for i,appliedOperation in enumerate(self[k+1:]):
			if (appliedOperation.precedes(operation)):
				causalPreOperations.append((i,appliedOperation))
		
		if (len(causalPreOperations) == 0):
			return operations.OperationList([operation]).listInclusionTransformation(self[k:])
		
		#Part 3
		else:
			reverseOfAppliedOperations = self[k:]
			reverseOfAppliedOperations.reverse()
			causalPreOperationsPrime = operations.OperationList() 	#This only has
							#operations in it not tuples
			
			for i,element in causalPreOperations:
				causalPreOperationsPrime.append(copy.copy(element))
			
			causalPreOperationsPrime[0] = operations.OperationList([causalPreOperationsPrime[0]]).listExclusionTransformation(reverseOfAppliedOperations[-(causalPreOperations[0][0]-k-1):])
			
			for i in range(1,len(causalPreOperations)):
				
				tempOperation = operations.OperationList(causalPreOperationsPrime[i]).listExclusionTransformation(reverseOfAppliedOperations[-(causalPreOperationsPrime[i][0]-k-1):])
				causalPreOperationsPrime[i] = listInclusionTransformation(tempOperation, causalPreOperations[0:i-1])
			
			
			#Break Apart the inner list of causalPreOperations
			final = operations.OperationList()
			for operationList in causalPreOperationsPrime:
				for element in operationList:
					final.append(element)
			del causalPreOperationsPrime
			
			final.reverse()
			print operation
			operationPrime = operations.OperationList([operation]).listExclusionTransformation(final)
			return operationPrime.listInclusionTransformation(self[k:])
