# Copyright (C) 2004 Matthew Colyer
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# This file contains the GUI and associated functions for collaborate.
#
# This file contains all the routines concerning transformation of commands
#

################################################
# Inclusion functions
################################################
def list_inclusion_transformation(list_of_operations_a, list_of_operations_b):
	return map(inclusion_transformation, list_of_operations_a, list_of_operations_b)

#General inclusion transformation
def inclusion_transformation(operation_a, operation_b):
	o_a_type = operation_a.tagName
	o_b_type = operation_b.tagName
	
	if check_relative_address(operation_a):
		if check_base_operation(operation_a, operation_b):
			executable_operations = convert_to_absolute_address(operation_a, operation_b)
		else:
			executable_operations = [operation_a]
	elif (o_a_type == "insert" and o_b_type == "insert"):
		executable_operations = it_ii(operation_a, operation_b)
	elif (o_a_type == "insert" and o_b_type == "delete"):
		executable_operations = it_id(operation_a, operation_b)
	elif (o_a_type == "delete" and o_b_type == "insert"):
		executable_operations = it_di(operation_a, operation_b)
	elif (o_a_type == "delete" and o_b_type == "delete"):
		executable_operations = it_dd(operation_a, operation_b)
	
	return executable_operations

#Inclusion of insert against insert
def it_ii(operation_a, operation_b):
	o_a_pos = int(operation_a.getAttribute("position"))
	o_b_pos = int(operation_b.getAttribute("position"))
	o_b_len = len(operation_b.getAttribute("string"))
	result = operation_a.cloneNode(False)
	
	#If it is to the left of the second operation, do nothing
	if (o_a_pos < o_b_pos):
		pass
	#If it is to the right or starts at the same place as the second
	#operation, shift it the proper amount
	else:
		result.setAttribute("position", str(o_a_pos+o_b_len))
	
	return [result]

#Inclusion of insert against delete
def it_id(operation_a, operation_b):
	o_a_pos = int(operation_a.getAttribute("position"))
	o_b_pos = int(operation_b.getAttribute("position"))
	o_b_len = int(operation_b.getAttribute("length"))
	result = operation_a.cloneNode(False)
	
	#If it is to the left or starts at the same place as the delete
	#operation, do nothing
	if (o_a_pos <= o_b_pos):
		pass
	#If it is to the right of the delete operation, shift it by the proper amount
	elif (o_a_pos > o_b_pos+o_b_len):
		result.setAttribute("position", str(o_a_pos-o_b_len))
	#If it is within the middle of the delete operation, shift it to the beginning
	#of the delete operation, this is arbitrary.
	else:
		save_lost_information(result, operation_b)
		result.setAttribute("position", str(o_b_pos))
	
	return [result]

#Inclusion of delete against insert
def it_di(operation_a, operation_b):
	o_a_pos = int(operation_a.getAttribute("position"))
	o_b_pos = int(operation_b.getAttribute("position"))
	o_a_len = int(operation_a.getAttribute("length"))
	o_b_len = len(operation_b.getAttribute("string"))
	result = operation_a.cloneNode(False)
	
	#If it is before or the starts at the same place as the insert
	#operation, do nothing
	if (o_b_pos >= (o_a_pos + o_a_len)):
		pass
	#If it is after or at the same position as the insert operation, shift
	#it by the proper amount. Arbitrarily puts the delete after the
	#insert.
	elif (o_a_pos >= o_b_pos):
		result.setAttribute("position", str(o_a_pos+o_b_len))
	#Otherwise the delete contains the insert and two delete commands are required
	else:
		result.setAttribute("length", str(o_b_pos-o_a_pos))
		result_2 = operation_a.cloneNode(False)
		result_2.setAttribute("length", str(o_a_len-(o_b_pos-o_a_pos)))
		result_2.setAttribute("position",  str(o_b_pos+o_b_len))
		
		return [result, result_2]
	
	return [result]

#Inclusion of delete against delete
def it_dd(operation_a, operation_b):
	o_a_pos = int(operation_a.getAttribute("position"))
	o_b_pos = int(operation_b.getAttribute("position"))
	o_a_len = int(operation_a.getAttribute("length"))
	o_b_len = int(operation_b.getAttribute("length"))
	result = operation_a.cloneNode(False)
	
	#If it is to the left of the delete, do nothing
	if (o_b_pos >= (o_a_pos + o_a_len)):
		pass
	#If it is to the right of the delete, shift it by the proper amount
	elif (o_a_pos >= (o_b_pos + o_b_len)):
		result.setAttribute("position", str(o_a_pos-o_b_len))
	#If the first delete contains any portion of the second delete
	else:
		#The first delete is contained completely within the second
		if (o_b_pos <= o_a_pos and ((o_a_pos + o_a_len) <= (o_b_pos + o_b_len))):
			result.setAttribute("length", "0")
		
		#If it overlaps to the right of the second delete
		elif (o_b_pos <= o_a_pos and ((o_a_pos + o_a_len) > (o_b_pos + o_b_len))):
			result.setAttribute("length", str(o_a_pos+o_a_len-(o_b_pos+o_b_len)))
			
		#If it overlaps to the left of the second delete
		elif (o_b_pos > o_a_pos and ((o_b_pos + o_b_len) >= (o_a_pos + o_a_len))):
			result.setAttribute("length", str(o_b_pos-o_a_pos))
		#If both start at same position and op_a is longer than op_b
		#resize it.
		else:
			result.setAttribute("length", str(o_a_len-o_b_len))
		
		save_lost_information(operation_a, operation_b)
	
	return [result]

################################################
# Exclusion functions
################################################
def list_exclusion_transformation(list_of_operations_a, list_of_operations_b):
	return map(exclusion_transformation, list_of_operations_a, list_of_operations_b)

#General exclusion transformation
def exclusion_transformation(operation_a, operation_b):	
	o_a_type = operation_a.tagName
	o_b_type = operation_b.tagName
	
	if check_relative_address(operation_a):
		executable_operations = [operation_a]
	elif (o_a_type == "insert" and o_b_type == "insert"):
		executable_operations = et_ii(operation_a, operation_b)
	elif (o_a_type == "insert" and o_b_type == "delete"):
		executable_operations = et_id(operation_a, operation_b)
	elif (o_a_type == "delete" and o_b_type == "insert"):
		executable_operations = et_di(operation_a, operation_b)
	elif (o_a_type == "delete" and o_b_type == "delete"):
		executable_operations = et_dd(operation_a, operation_b)
	
	return executable_operations
	
#Exclusion of insert against insert
def et_ii(operation_a, operation_b):
	o_a_pos = int(operation_a.getAttribute("position"))
	o_b_pos = int(operation_b.getAttribute("position"))
	o_b_len = len(operation_b.getAttribute("string"))
	
	#If the string to transform is to the left of the one against
	if (o_a_pos <= o_b_pos):
		pass
	#If the string is to the right of the it is against
	elif (o_a_pos >= (o_b_pos + o_b_len)):
		operation_a.setAttribute("position", str(o_a_pos - o_b_len))
	#Otherwise it is in the middle
	else :
		operation_a.setAttribute("position", str(o_a_pos - o_b_pos))
		save_relative_address(operation_a, operation_b)
	
	return [operation_a]
		
#Exclusion of insert against delete
def et_id(operation_a, operation_b):
	o_a_pos = int(operation_a.getAttribute("position"))
	o_b_pos = int(operation_b.getAttribute("position"))
	o_b_len = int(operation_b.getAttribute("length"))
	
	if check_lost_information(operation_a, operation_b):
		recover_lost_information(operation_a, operation_b)
	
	#If the operation is to the left
	elif (o_a_pos <= o_b_pos):
		pass
	#Otherwise put it past the delete command
	else:
		operation_a.setAttribute("position", str(o_a_pos + o_b_len))
	
	return [operation_a]
	
#Exclusion of delete against insert
def et_di(operation_a, operation_b):
	o_a_pos = int(operation_a.getAttribute("position"))
	o_b_pos = int(operation_b.getAttribute("position"))
	o_a_len = int(operation_a.getAttribute("length"))
	o_b_len = len(operation_b.getAttribute("string"))
	
	if ((o_a_pos + o_a_len) <= o_b_pos):
		pass
	elif (o_a_pos >= (o_b_pos+o_b_len)):
		operation_a.setAttribute("position", str(o_a_pos - o_b_len))
	else:
		#Delete contained within the insert
		if (o_b_pos <= o_a_pos and  (o_a_pos + o_a_len) <= (o_b_pos + o_b_len)):
			operation_a.setAttribute("position", str(o_a_pos - o_b_pos))
		#Delete starts inside the insert and goes past the end of the insert
		elif (o_b_pos <= o_a_pos and (o_a_pos + o_a_len) > (o_b_pos + o_b_len)):
			operation_a.setAttribute("length", str(o_b_pos+o_b_len-o_a_pos))
			operation_a.setAttribute("position", str(o_a_pos-o_b_pos))
			operation_c = operation_a.cloneNode(False)
			operation_c.setAttribute("length", str((o_a_pos+o_a_len)-(o_b_pos+o_b_len)))
			operation_c.setAttribute("position",  str(o_b_pos))
			
			save_relative_address(operation_a, operation_b)
			return [operation_a, operation_c]
		#Delete encloses the entire insert
		elif (o_a_pos < o_b_pos and (o_b_pos + o_b_len) <= (o_a_pos+o_a_len)): 
			operation_a.setAttribute("length", str(o_b_len))
			operation_a.setAttribute("position", str(0))
			operation_c = operation_a.cloneNode(False)
			operation_c.setAttribute("length", str(o_a_len-o_b_len))
			operation_c.setAttribute("position",  str(o_a_pos))
			
			save_relative_address(operation_a, operation_b)
			return [operation_a, operation_c]			
		#Delete starts before the insert and ends inside it
		else:
			operation_a.setAttribute("length", str(o_a_pos+o_a_len-o_b_pos))
			operation_a.setAttribute("position", str(0))
			operation_c = operation_a.cloneNode(False)
			operation_c.setAttribute("length", str(o_b_pos-o_a_pos))
			operation_c.setAttribute("position",  str(o_a_pos))
			
			save_relative_address(operation_a, operation_b)
			return [operation_a, operation_c]			
		
		save_relative_address(operation_a, operation_b)
	return [operation_a]
		
#Exclusion of delete against delete
def et_dd(operation_a, operation_b):
	o_a_pos = int(operation_a.getAttribute("position"))
	o_b_pos = int(operation_b.getAttribute("position"))
	o_a_len = int(operation_a.getAttribute("length"))
	o_b_len = int(operation_b.getAttribute("length"))
	
	if (check_lost_information(operation_a, operation_b)):
		recover_lost_information(operation_a, operation_b)
	elif (o_b_pos >= (o_a_pos + o_a_len)):
		pass
	elif (o_a_pos >= o_b_pos):
		operation_a.setAttribute("position", str(o_a_pos + o_b_len))
	else:
		operation_a.setAttribute("length", str(o_b_pos-o_a_pos))
		operation_c = operation_a.cloneNode(False)
		operation_c.setAttribute("length", str(o_a_len-(o_b_pos-o_a_pos)))
		operation_c.setAttribute("position",  str(o_b_pos+o_b_len))
		
		return [operation_a, operation_c]
	return [operation_a]

################################################
# Utility functions
################################################
def check_relative_address(operation):
	if (operation.getAttribute("relative") == "True"):
		return True
	else:
		return False

def save_relative_address(operation_a, operation_b):
	operation_a.setAttribute("relative", "True")
	#FIXME
	#operation_a.setAttribute("relative_id", last_relative_id)
	#operation_b.setAttribute("relative_id", last_relative_id)
	#last_relative_id += 1
	
def check_base_operation(operation_a, operation_b):
	if (operation_a.getAttribute("relative_id") == operation_b.getAttribute("relative_id")):
		return True
	else:
		return False

def convert_to_absolute_addressing(operation_a, operation_b):
	o_a_pos = int(operation_a.getAttribute("position"))
	o_b_pos = int(operation_b.getAttribute("position"))
	
	operation_a.setAttribute("position", str(o_a_pos+o_b_pos))
	
	operation_a.removeAttribute("relative_id")
	operation_b.removeAttribute("relative_id")
	
	return [operation_a]
	
def check_lost_information(operation_a, operation_b):
	#FIXME
	return False

def save_lost_information(operation_a, operation_b):
	o_b_site = operation_b.getAttribute("site")
	o_b_id = operation_b.getAttribute("id")
	
	if (operation_a.tagName == "insert"):
		if (operation_a.getAttribute("position-bkup") != ""):
			position_backup = eval(operation_a.getAttribute("position-bkup"))
		else:
			position_backup = {}
		
		position_backup[o_b_site+"-"+o_b_id] = operation_a.getAttribute("position")
		operation_a.setAttribute("position-bkup", str(position_backup))
	if (operation_a.tagName == "delete"):
		if (operation_a.getAttribute("length-bkup") != ""):
			length_backup = eval(operation_a.getAttribute("length-bkup"))
		else:
			length_backup = {}
		
		length_backup[o_b_site+"-"+o_b_id] = operation_a.getAttribute("length")
		operation_a.setAttribute("length-bkup", str(length_backup))
		
def restore_information(operation_a, operation_b):
	o_b_site = operation_b.getAttribute("site")
	o_b_id = operation_b.getAttribute("id")
	
	operation_a.setAttribute("position", operation_a.getAttribute("position-bkup"))
	operation_a.removeAttribute("position-bkup")
	
	if (operation_a.tagName == "delete"):
		operation_a.setAttribute("length", operation_a.getAttribute("length-bkup"))
		operation_a.removeAttribute("length-bkup")
