/* AbiSuite
 * Copyright (C) 2004 Rmi Payette
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#include "enchant-provider.h"
#include <Cocoa/Cocoa.h>

ENCHANT_PLUGIN_DECLARE("appleSpell")



class AppleSpellChecker
{
public:
    AppleSpellChecker();
    ~AppleSpellChecker();

    char** suggestWord (const char* const word, size_t len, size_t *nsug);
    bool requestDictionary (const char * szLang, NSString **lang);
    bool checkWord (const char *word, size_t len, NSString *lang);

    NSSpellChecker          *m_checker; 

private:
    int                             m_tag;
    NSAutoreleasePool    *pool;
};

struct dicodata
{
AppleSpellChecker    *thechecker;
NSString                    *thelang;
};