/* AbiSuite
 * Copyright (C) 2004 Rmi Payette
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


#include <Cocoa/Cocoa.h>
#include "appleSpell_checker.h"
#include "glib.h"

AppleSpellChecker::AppleSpellChecker()
{
    NSLog(@"AppleSpellChecker::AppleSpellChecker");
                    m_checker=[NSSpellChecker sharedSpellChecker];
                    m_tag=[NSSpellChecker uniqueSpellDocumentTag];
                    m_lang=NULL;
    NSLog(@"%p %d %@ exist ? %d",m_checker, m_tag,[[NSSpellChecker sharedSpellChecker]language], [NSSpellChecker sharedSpellCheckerExists]);
    
}

AppleSpellChecker::~AppleSpellChecker()
{
    NSLog(@"AppleSpellChecker::~AppleSpellChecker");
                    [m_checker closeSpellDocumentWithTag: m_tag];
                    if (m_lang) [m_lang release];
}


bool AppleSpellChecker::checkWord (const char *word, size_t len)
{
NSString              *str;
NSRange             result;

    NSLog(@"AppleSpellChecker::checkWord");
if ( !m_lang ) return false;

str = [[NSString alloc] initWithBytes: word lenght: len encoding:NSUTF8StringEncoding];
//NSLog(@"AppleSpellChecker check : %@ in %@ (%d)",str,m_lang,this->m_tag);
                    
result=[m_checker checkSpellingOfString:str startingAt:0 language:m_lang wrap:NO inSpellDocumentWithTag:m_tag wordCount:nil];
[str release];
if ( result.length )
    return true;
return false;
}

char** AppleSpellChecker::suggestWord (const char* const word, size_t len, size_t *nsug)
{
char                    **sug;
NSString              *str;
NSArray               *result;
unsigned int  i;

    NSLog(@"AppleSpellChecker::suggestWord");
str = [[NSString alloc] initWithBytes: word lenght: len encoding:NSUTF8StringEncoding];
result = [m_checker guessesForWord: str];
[str release];

*nsug=[result count];
if ( *nsug == 0 ) return 0;

sug = g_new0 (char *, *nsug + 1);
for ( i = 0; i < *nsug; i++) {
    str=[result objectAtIndex:i];
    sug[i]=g_strdup([str UTF8String]);
}
//NSLog(@"AppleSpellChecker::_suggest %d suggestions",pvSugg->getItemCount());
return sug;
}


bool AppleSpellChecker::requestDictionary (const char * szLang)
{
if ( m_lang ) [m_lang release];
                    
/* Only the 2 char language code can be fed to set language : fr is ok, not fr-CA */
m_lang=[[NSString alloc] initWithCString:szLang length:2];
NSLog(@"AppleSpellChecker::requestDictionary %@, %p",m_lang, m_checker);
if (![m_checker setLanguage:(NSString *)m_lang])
    {
    [m_lang release];
    m_lang=NULL;
    return false;
    }

NSLog(@"AppleSpellChecker:language : %@",[m_checker language]);
return (true);
}






/*
 * Enchant
 */

static char **
appleSpell_dict_suggest (EnchantDict * me, const char *const word,
		     size_t len, size_t * out_n_suggs)
{
	AppleSpellChecker * checker;
	
    NSLog(@"appleSpell_dict_suggest");
	checker = (AppleSpellChecker *) me->user_data;
	return checker->suggestWord (word, len, out_n_suggs);
}

static int
appleSpell_dict_check (EnchantDict * me, const char *const word, size_t len)
{
	AppleSpellChecker * checker;
	
    NSLog(@"appleSpell_dict_check");
	checker = (AppleSpellChecker *) me->user_data;
	
	if (checker->checkWord(word, len))
		return 0;
	
	return 1;
}

static void
appleSpell_dict_free_suggestions (EnchantDict * me, char **str_list)
{
    NSLog(@"appleSpell_dict_free_suggestions");
	g_strfreev (str_list);
}

static EnchantDict *
appleSpell_provider_request_dict(EnchantProvider * me, const char *const tag)
{
	EnchantDict *dict;
	AppleSpellChecker * checker;
	
    NSLog(@"appleSpell_provider_request_dict");
	checker = new AppleSpellChecker();
	
	if (!checker)
		return NULL;
	
	if (!checker->requestDictionary(tag)) {
		delete checker;
		return NULL;
	}
	
	dict = g_new0(EnchantDict, 1);
	dict->user_data = (void *) checker;
	dict->check = appleSpell_dict_check;
	dict->suggest = appleSpell_dict_suggest;
	dict->free_suggestions = appleSpell_dict_free_suggestions;
	// don't implement personal, session
	
	return dict;
}

static void
appleSpell_provider_dispose_dict (EnchantProvider * me, EnchantDict * dict)
{
	AppleSpellChecker *checker;
    NSLog(@"appleSpell_provider_dispose_dict");
	
	checker = (AppleSpellChecker *) dict->user_data;
	delete checker;
	
	g_free (dict);
}

static int
appleSpell_provider_dictionary_exists (struct str_enchant_provider * me,
				    const char *const tag)
{
NSString    *lang;
int         result=0;
    NSLog(@"appleSpell_provider_dictionary_exists");
/* Only the 2 char language code can be fed to set language : fr is ok, not fr-CA */
lang=[[NSString alloc] initWithCString:tag length:2];
if ([[NSSpellChecker sharedSpellChecker] setLanguage:lang])
    {
    result=1;
    }
[lang release];
    //NSLog(@"AppleSpellChecker:language : %@",[m_checker language]);

return (result);
}

static void
appleSpell_provider_dispose (EnchantProvider * me)
{
    NSLog(@"appleSpell_provider_dispose");
	g_free (me);
}

static char *
appleSpell_provider_identify (EnchantProvider * me)
{
    NSLog(@"appleSpell_provider_identify");
	return "AppleSpell";
}

static char *
appleSpell_provider_describe (EnchantProvider * me)
{
    NSLog(@"appleSpell_provider_describe");
	return "AppleSpell Provider";
}







extern "C" {

ENCHANT_MODULE_EXPORT (EnchantProvider *) 
init_enchant_provider (void)
{
	EnchantProvider *provider;
    NSLog(@"init_enchant_provider");
	
	provider = g_new0 (EnchantProvider, 1);
	provider->dispose = appleSpell_provider_dispose;
	provider->request_dict = appleSpell_provider_request_dict;
	provider->dispose_dict = appleSpell_provider_dispose_dict;
	provider->dictionary_exists = appleSpell_provider_dictionary_exists;
	provider->identify = appleSpell_provider_identify;
	provider->describe = appleSpell_provider_describe;
	
	return provider;
}

}
