/* GypsyPlugin
 * Copyright (C) 2002 Mauro Colorio
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#include "xap_Module.h"
#include "xap_App.h"
#include "xap_Frame.h"
#include "fv_View.h"
#include "ap_Menu_Id.h"
#include "ev_Menu_Actions.h"
#include "ev_Menu.h"
#include "ev_Menu_Layouts.h"
#include "ev_Menu_Labels.h"
#include "ev_EditMethod.h"
#include "xap_Menu_Layouts.h"
#include "ut_string_class.h"

#include "xap_Dialog_Id.h"
#include "xap_DialogFactory.h"
#include "xap_Dlg_Language.h"
#include <Python22/Python.h>

// Gypsy plugin runs python embedded in abiword

static const char * MODULE_NAME="gypsy";
static const char * FUNCTION_NAME="GetRows";

//
// insertText, Puts string on a view
bool insertText(FV_View * pView, char * text)
{
	if(pView != NULL)
	{
//		UT_String * pText = (UT_String *) pToks->getNthItem(1);
		UT_UCSChar * pUCSText = (UT_UCSChar *) UT_calloc(strlen(text)+1,sizeof(UT_UCSChar));
		UT_UCS4_strcpy_char((UT_UCS4Char *) pUCSText, text);
		static_cast<FV_View *>(pView)->cmdCharInsert(pUCSText,strlen(text));
		FREEP(pUCSText);
		return true;
	}
	return false;
}


// 
// Python_checkmodule
// -------------------
//   Checks and loads the given module
//   
 
bool Python_checkmodule(XAP_Frame * pFrame, char * modulename)
{
	
	FV_View * pView =
	static_cast <FV_View *>(pFrame->getCurrentView());
	
	
    PyObject *pName, *pModule, *pDict, *pFunc, *pItemk, *pFunctionResult;
    char functionname[256];
    
    sprintf(functionname,FUNCTION_NAME);
    
    pName = PyString_FromString(modulename);
    /* Error checking of pName left out */

    pModule = PyImport_Import(pName);
    
    if (pModule != NULL) {
        pDict = PyModule_GetDict(pModule);
        /* pDict is a borrowed reference */

        pFunc = PyDict_GetItemString(pDict, functionname);
        /* pFun: Borrowed reference */

        if (pFunc && PyCallable_Check(pFunc)) {
            pFunctionResult = PyObject_CallObject(pFunc,NULL);
            if (pFunctionResult != NULL) {
            	PyObject *item;
            	
            	int n =  PyList_Size(pFunctionResult);            	
            	int i = 0;
            	            	         	
            	while ( i < n){
            		
            		item = PyList_GetItem(pFunctionResult,i);
            		i++;
            		
					PyObject *key, *value;
					int pos = 0;

					while (PyDict_Next(item, &pos, &key, &value)){
						insertText(pView,PyString_AsString(PyDict_GetItem(item,key))); 
					}
				}
				
                Py_DECREF(pFunctionResult);
            }
            else {
               
                pFrame->showMessageBox("Failed function call", XAP_Dialog_MessageBox::b_O,XAP_Dialog_MessageBox::a_OK);
                return 1;
            }
           
            // pDict and pFunc are borrowed and must not be Py_DECREF-ed 
        }
        else {
           pFrame->showMessageBox("can't find function", XAP_Dialog_MessageBox::b_O,XAP_Dialog_MessageBox::a_OK);
        }
        Py_DECREF(pModule);
    }
    else {
        pFrame->showMessageBox("can't load module", XAP_Dialog_MessageBox::b_O,XAP_Dialog_MessageBox::a_OK);
        return false;
    }	
    return true;
	
}



// 
// Python_invoke
// -------------------
//   This is the function that we actually call to invoke the 
//   embedded python 
 
bool Python_invoke(AV_View * v, EV_EditMethodCallData * d)
{
	// Get the current view that the user is in.
	XAP_Frame * pFrame = XAP_App::getApp()->getLastFocussedFrame();
	FV_View * pView =
	static_cast <FV_View *>(pFrame->getCurrentView());
	
	PyObject *pObject;
	
	Py_Initialize();

	if (!Python_checkmodule(pFrame, (char *)MODULE_NAME))
		return false;

  	Py_Finalize();
			
	return true;
}

static const char * Python_MenuLabel = "Python Mail merge";
static const char * Python_MenuTooltip = "Runs python mailmerge";

static void
Python_RemoveFromMenus ()
{
  // First we need to get a pointer to the application itself.
  XAP_App *pApp = XAP_App::getApp();

  // remove the edit method
  EV_EditMethodContainer* pEMC = pApp->getEditMethodContainer() ;
  EV_EditMethod * pEM = ev_EditMethod_lookup ( "Python_invoke" ) ;
  pEMC->removeEditMethod ( pEM ) ;
  DELETEP( pEM ) ;

  // now remove crap from the menus
  int frameCount = pApp->getFrameCount();
  XAP_Menu_Factory * pFact = pApp->getMenuFactory();

  pFact->removeMenuItem("Main",NULL,Python_MenuLabel);
  pFact->removeMenuItem("contextText",NULL,Python_MenuLabel);
  for(int i = 0;i < frameCount;++i)
    {
      // Get the current frame that we're iterating through.
      XAP_Frame* pFrame = pApp->getFrame(i);
      pFrame->rebuildMenus();
    }
}

static void Python_addToMenus()
{
	// First we need to get a pointer to the application itself.
	XAP_App * pApp = XAP_App::getApp();

	// Create an EditMethod that will link our method's name with
	// it's callback function.  This is used to link the name to 
	// the callback.
	EV_EditMethod * myEditMethod = new EV_EditMethod(
							"Python_invoke",	// name of callback function
							Python_invoke,		// callback function itself.
							0,							// no additional data required.
							""	// description -- allegedly never used for anything
	);

	// Now we need to get the EditMethod container for the application.
	// This holds a series of Edit Methods and links names to callbacks.
	EV_EditMethodContainer * pEMC = pApp->getEditMethodContainer();

	// We have to add our EditMethod to the application's EditMethodList
	// so that the application will know what callback to call when a call
	// to "AiksaurusABI_invoke" is received.
	pEMC->addEditMethod(myEditMethod);


	// Now we need to grab an ActionSet.  This is going to be used later
	// on in our for loop.  Take a look near the bottom.
	EV_Menu_ActionSet * pActionSet = pApp->getMenuActionSet();


	// We need to go through and add the menu element to each "frame" 
	// of the application.  We can iterate through the frames by doing
	// XAP_App::getFrameCount() to tell us how many frames there are,
	// then calling XAP_App::getFrame(i) to get the i-th frame.

	int frameCount = pApp->getFrameCount();
	XAP_Menu_Factory * pFact = pApp->getMenuFactory();

	// 
	// Put it in the context menu.
	// 
	XAP_Menu_Id newID = pFact->addNewMenuAfter("contextText", NULL, "Bullets and &Numbering", EV_MLF_Normal);
	pFact->addNewLabel(NULL, newID, Python_MenuLabel, Python_MenuTooltip);

	// 
	// Also put it under word Wount in the main menu,
	// 
	pFact->addNewMenuAfter("Main", NULL, "&Word Count", EV_MLF_Normal, newID);

	// Create the Action that will be called.
	EV_Menu_Action * myAction = new EV_Menu_Action(
			newID,						// id that the layout said we could use
			0,							// no, we don't have a sub menu.
			1,							// yes, we raise a  dialog.
			0,							// no, we don't have a checkbox.
			"Python_invoke",	// name of callback function to call.
			NULL,						// don't know/care what this is for
			NULL						// don't know/care what this is for
	);

	// Now what we need to do is add this particular action to the ActionSet
	// of the application.  This forms the link between our new ID that we 
	// got for this particular frame with the EditMethod that knows how to 
	// call our callback function.

	pActionSet->addAction(myAction);

	for (int i = 0; i < frameCount; ++i)
   	{
		// Get the current frame that we're iterating through.
		XAP_Frame * pFrame = pApp->getFrame(i);
		pFrame->rebuildMenus();
	}
}

// -----------------------------------------------------------------------
// 
// Abiword Plugin Interface 
// 
// -----------------------------------------------------------------------

ABI_FAR_CALL int abi_plugin_register(XAP_ModuleInfo * mi)
{
	mi->name = "Python plugin";
	mi->desc = "Python plugin";
	mi->version = ABI_VERSION_STRING;
	mi->author = "Mauro Colorio";
	mi->usage = "No Usage";

	// Add the Python to AbiWord's menus.
	Python_addToMenus();

	return 1;
}

ABI_FAR_CALL int abi_plugin_unregister(XAP_ModuleInfo * mi)
{
	mi->name = 0;
	mi->desc = 0;
	mi->version = 0;
	mi->author = 0;
	mi->usage = 0;

	Python_RemoveFromMenus ();

	return 1;
}


ABI_FAR_CALL int abi_plugin_supports_version(UT_uint32 major, UT_uint32 minor,
			UT_uint32 release)
{
	return 1;
}
