/*
 * This module defines commands intended for use by scripts.
 * These methods are often similar to existing EditMethods,
 * but they generally bypass GUI interaction.
 */

#ifndef AP_SCRIPTMETHODS_H
#define AP_SCRIPTMETHODS_H

#include "ut_types.h"
class AD_Document;
class XAP_Frame;
class PD_Document;
class PD_DocumentRange;
class FL_DocLayout;
class fl_SectionLayout;
class fl_BlockLayout;

/* Shut down AbiWord immediately, without saving any files. */
void scriptQuit();
/* Return the number of open documents. */
int scriptDocCount();
/* Return the frame containing the nth document. */
XAP_Frame * scriptGetDocFrame(int n);
/* Return the document of the given frame. Either of the out parameters may
   be NULL. The ref counts are not incremented by this function. */
void scriptGetDoc(XAP_Frame * pFrame, 
				  PD_Document ** ppDoc, FL_DocLayout ** ppDocLayout);

// Return the number of sections in a document.
int scriptDocSectionCount(FL_DocLayout * pDocLayout);

// Return a ptr to the given section, 0-based.
//
// TODO: bounds check
fl_SectionLayout * scriptDocSection(FL_DocLayout * pDocLayout, int n);

// Return the number of blocks in a section.
int scriptBlockCount(fl_SectionLayout * pSection);

// Return the nth section, 0-based.
//
// TODO: bounds check
fl_BlockLayout * scriptBlock(fl_SectionLayout * pSection, int n);

// Return the number of text characters in a block.
int scriptBlockLength(fl_BlockLayout * pBlock);

// Return a newly malloc'd buffer containing the unformatted text
// of the given range.
//
// TODO: what about out-of-bounds?
UT_UCSChar * scriptGetRangeText(fl_BlockLayout * pBlock, int offset, int len);

// Replace the given range in the text with new text.
void scriptReplaceRangeText(fl_BlockLayout * pBlock, int offset, int len,
							UT_UCSChar * text);

#endif /* AP_SCRIPTMETHODS_H */
