#include "ap_ScriptMethods.h"

#include "ut_debugmsg.h"
#include "ut_growbuf.h"
#include "ut_set.h"
#include "ut_string.h"

#include "xad_Document.h"
#include "xap_App.h"
#include "xap_Frame.h"

#include "fl_BlockLayout.h"
#include "fl_DocLayout.h"
#include "fl_SectionLayout.h"
#include "fv_View.h"

#include "pp_AttrProp.h"

// TODO: This does not work. Make it work.
void scriptQuit()
{
    XAP_App * pApp = XAP_App::getApp();

    // TODO: Check this: the loop may do -1 also.
    UT_uint32 ndx = pApp->getFrameCount() - 1;
    for (; ndx >= 0; --ndx) {
	XAP_Frame * pFrame = pApp->getFrame(ndx);
	pApp->forgetFrame(pFrame);
	pFrame->close();
	delete pFrame;
    }

    pApp->closeModelessDlgs();
    pApp->reallyExit();
}

/*
 * I don't believe this is available explicitly. Therefore we build
 * up the set of documents by iterating over the frames.
 */
int scriptDocCount()
{
    UT_Set utsDocs;
    XAP_App * pApp = XAP_App::getApp();
    UT_uint32 i, n = pApp->getFrameCount();
    for (i = 0; i < n; ++i) {
	utsDocs.insert(pApp->getFrame(i)->getCurrentDoc());
    }
    return utsDocs.size();
}

XAP_Frame * scriptGetDocFrame(int n)
{
    UT_Set utsDocs;
    XAP_App * pApp = XAP_App::getApp();
    UT_uint32 i, nFrames = pApp->getFrameCount();
    for (i = 0; i < nFrames; ++i) {
		XAP_Frame * pFrame = pApp->getFrame(i);
        AD_Document * pDoc = pFrame->getCurrentDoc();
		if (utsDocs.insert(pDoc)) {
			if (n-- == 0) return pFrame;
		}
    }
    UT_ASSERT(UT_SHOULD_NOT_HAPPEN);
    return 0;
}

// TODO: get rid of downcasts
void scriptGetDoc(XAP_Frame * pFrame, 
				  PD_Document ** ppDoc, FL_DocLayout ** ppDocLayout)
{
	if (ppDoc != NULL) {
		*ppDoc = (PD_Document *) pFrame->getCurrentDoc();
	}
	if (ppDocLayout != NULL) {
		*ppDocLayout = ((FV_View *) pFrame->getCurrentView())->getLayout();
	}
}

int scriptDocSectionCount(FL_DocLayout * pDocLayout)
{
	fl_SectionLayout * p;
	int n;
	for (p = pDocLayout->getFirstSection(), n = 0; p; p = p->getNext(), ++n);
	return n;
}

fl_SectionLayout * scriptDocSection(FL_DocLayout * pDocLayout, int n)
{
	fl_SectionLayout * p;
	int i;
	for (p = pDocLayout->getFirstSection(), i = 0; 
		 p && i < n; 
		 p = p->getNext(), ++i);
	return p;
}

int scriptBlockCount(fl_SectionLayout * pSection)
{
	fl_BlockLayout * p;
	int n;
	for (p = pSection->getFirstBlock(), n = 0; p; p = p->getNext(), ++n);
	return n;
}

fl_BlockLayout * scriptBlock(fl_SectionLayout * pSection, int n)
{
	fl_BlockLayout * p;
	int i;
	for (p = pSection->getFirstBlock(), i = 0; 
		 p && i < n; 
		 p = p->getNext(), ++i);
	return p;
}

int scriptBlockLength(fl_BlockLayout * pBlock)
{
	UT_GrowBuf pgb;
	pBlock->getBlockBuf(&pgb);
	return pgb.getLength();
}

UT_UCSChar * scriptGetRangeText(fl_BlockLayout * pBlock, int offset, int len)
{
	const UT_UCSChar * ucsPtr;
	UT_UCSChar * ucsAns;
	unsigned int nBlockLen;
	pBlock->getSpanPtr(offset, &ucsPtr, &nBlockLen);
	ucsAns = (UT_UCSChar *) malloc((len+1) * sizeof(UT_UCSChar));
	UT_UCS_strncpy(ucsAns, ucsPtr, len);
	ucsAns[len] = 0;
	return ucsAns;
	
#if 0
	// This is code to get text across block boundaries. I don't
    // think it's quite right.
	UT_UCSChar ucsParaSep [] = { '\n', '\n' };
	fl_BlockLayout * pBlock = pDocLayout->findBlockAtPosition(pRange->m_pos1);
	UT_GrowBuf pgbAns, pgbCurr;
	UT_uint32 nBytesNeeded = pRange->m_pos2 - pRange->m_pos1;
	UT_DEBUGMSG(("[SGRT] nBytesNeeded = %d\n", nBytesNeeded));
	UT_uint32 nOffset = pRange->m_pos1 - pBlock->getPosition(true);
	UT_DEBUGMSG(("[SGRT] nOffset = %d, block pos = %d\n", 
				 nOffset, pBlock->getPosition(true)));
	while (1) {
		pBlock->getBlockBuf(&pgbCurr);
		UT_uint32 nAvail = pgbCurr.getLength() - nOffset;
		UT_uint32 nCopy = nAvail > nBytesNeeded ? nBytesNeeded : nAvail;
		pgbAns.append(pgbCurr.getPointer(nOffset), nCopy);
		nBytesNeeded -= nCopy;
		nOffset = 0;
		if (nBytesNeeded == 0) break;
		pgbAns.append(ucsParaSep, sizeof(ucsParaSep) / sizeof(ucsParaSep[0]));
	}

	UT_UCSChar * ucsAns;
	UT_UCS_cloneString(&ucsAns, pgbAns.getPointer(0));
	return ucsAns;
#endif
}

void scriptReplaceRangeText(fl_BlockLayout * pBlock, int offset, int len,
							UT_UCSChar * text)
{
	PD_Document * pDoc = pBlock->getDocLayout()->getDocument();
	PT_DocPosition start = pBlock->getPosition() + offset;
	PT_DocPosition end = start + len;
	PP_AttrProp props;
	pDoc->notifyPieceTableChangeStart();
	pDoc->deleteSpan(start, end, &props);
	if (text && text[0]) {
		pDoc->insertSpan(start, text, UT_UCS_strlen(text), &props);
	}
	pDoc->notifyPieceTableChangeEnd();
}

