; This is a file for creating an installer for Abiword using NSIS 
; by Alan Horkan <horkana@tcd.ie>

; Do a Cyclic Redundancy Check to make sure the installer 
; was not corrupted by the download.  
CRCCheck on

; The name of the installer
Name "Abiword"
Icon "setup.ico"
OutFile "setup_abiword.exe"

; License Information
LicenseText "This program is Licensed under the GNU General Public License (GPL)."
LicenseData "copying.txt"

; The default installation directory
InstallDir $PROGRAMFILES\AbiSuite
; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM SOFTWARE\Abisuite\Abiword "Install_Dir"

; The text to prompt the user to enter a directory
ComponentText "This will install Abiword on your computer. Select which optional components you want installed."
; The text to prompt the user to enter a directory
DirText "Choose a directory to install in to:"

; The stuff that must be installed
; binary, license, and American dictionary
Section "Abiword.exe (required)"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  ; Put file there
  File ".\Abiword\bin\Abiword.exe"
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The above lines need to be changed, 
;; to allow add files to be added to the installer 
;; recursively instead of having to specify each path absolutely
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  SetOutPath $INSTDIR
;  ; Put files and directories there
;  ; the script will be run from a directory below pingus
;  File /r "Abiword\*.*"
;;  This needs to be refined.  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\Abisuite\Abiword "Install_Dir" "$INSTDIR"
  ; Write the uninstall keys for Windows
  ; N.B. This needs to include a version number or unique identifier.  
  ; More than one version of Abiword but only one Control Panel.  
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Abiword" "DisplayName" "Abiword (remove only)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Abiword" "UninstallString" '"$INSTDIR\uninstall.exe"'
SectionEnd

; OPTIONAL Start Menu Shortcut
EnabledBitmap bitmap1.bmp
DisabledBitmap bitmap2.bmp
Section "Start Menu Shortcuts"
  CreateDirectory "$SMPROGRAMS\Abiword"
  CreateShortCut "$SMPROGRAMS\Abiword\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Abiword\Abiword.lnk" "$INSTDIR\Abiword\bin\Abiword.exe" "" "$INSTDIR\Abiword\bin\Abiword.exe" 0
SectionEnd

; OPTIONAL Desktop Shortcut 
Section "Desktop Shortcut"
  CreateShortCut "$DESKTOP\Abiword.lnk" "$INSTDIR\Abiword\bin\Abiword.exe" "" "$INSTDIR\Abiword\bin\Abiword.exe" 0
SectionEnd

; MORE OPTIONS
; language packs, clipart, help docs, templates etc.   

; uninstall stuff
UninstallText "This will uninstall Abiword. Hit next to continue."
UninstallExeName "uninstall.exe"

; special uninstall section.
Section "Uninstall"
  ; remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Abiword"
  DeleteRegKey HKLM SOFTWARE\Abisuite\Abiword
  ; remove files
  Delete $INSTDIR\
  ; MUST REMOVE UNINSTALLER, too
  Delete $INSTDIR\uninstall.exe
  ; remove start menu shortcuts.
  Delete "$SMPROGRAMS\Abiword\*.*"
  ; remove desktop shortcut.
  Delete "$DESKTOP\Abiword.lnk"
  ; remove directories used.
  RMDir "$SMPROGRAMS\Abiword"
  RMDir "$INSTDIR"
SectionEnd

; eof
