#include <string.h>
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "../../af/xap/xp/xap_App.h"
#include "../../af/xap/xp/xap_Frame.h"
#include "../../text/fmt/xp/fv_View.h"
#include "../../af/util/xp/ut_string.h"

MODULE = abi		PACKAGE = abi::FV_View

bool
scrollLineDown(pView)
	FV_View *pView
	CODE:
		/* It would be better to export the generic interface to perl as well
		   so that you can write:
		   $view->cmdScroll('linedown');
		*/
		pView->cmdScroll(AV_SCROLLCMD_LINEDOWN);
		RETVAL = true;
	OUTPUT:
		RETVAL

bool
setCharFormat (pView, property, ...)
	FV_View *pView
	char * property
	CODE:
	{
		const XML_Char ** properties = (const XML_Char**)malloc(sizeof(XML_Char*)*(items));
		int i;
		for (i=0; i <= items; ++i)
			properties[i] = SvPV(ST(i+1), PL_na);
		properties[i] = NULL;
		pView->setCharFormat(properties);
		free(properties);
		RETVAL = 1;
	}
	OUTPUT:
	RETVAL

bool
cmdSaveAs(pView, filename, left, cpy)
	FV_View *pView
	char * filename
	int	left
	bool	cpy
	CODE:
		pView->cmdSaveAs(filename, left, cpy);
		RETVAL = true;
	OUTPUT:
		RETVAL

bool
insertData(pView, pszText)
	FV_View *pView
	const char *pszText
	CODE:
		UT_UCSChar *text = NULL;
		UT_UCS_cloneString_char(&text, pszText);
		pView->cmdCharInsert(text, strlen(pszText));
		free(text);
		RETVAL = true;
	OUTPUT:
		RETVAL

MODULE = abi		PACKAGE = abi::XAP_Frame

XAP_Frame *
openFile(pszFilename)
	const char *pszFilename
	CODE:
		XAP_App* app = XAP_App::getApp();
		RETVAL = app->newFrame();
		RETVAL->loadDocument(pszFilename, 0, true);
	OUTPUT:
		RETVAL

FV_View *
getCurrentView(pFrame)
	XAP_Frame *pFrame
	CODE:
		RETVAL = (FV_View *) pFrame->getCurrentView();
	OUTPUT:
		RETVAL


