/*
 * Code copyright Dom Lachowicz <cinamod@hotmail.com> 2001
 * Copyrighted under the GNU GPL version 2.0
 * http://www.fsf.org/
 */

#include "ut_types.h"
#include "ut_vector.h"
#include "ut_hash.h"

// forward declaration
class SpellManager;

class ISpellChecker
{
  friend class SpellManager;
  
 public:
  
  typedef enum _ISpellCheckResult {
    LOOKUP_SUCCEEDED = 0, // looking up the word succeeded
    LOOKUP_FAILED = 1,    // could not find the word
    LOOKUP_ERROR = 2      // internal error
  } ISpellCheckResult;

  virtual ISpellCheckResult checkWord (const UT_UCSChar * word) = 0;
  virtual UT_Vector * suggestWord (const UT_UCSChar * word) = 0;

  virtual bool requestDictionary (const char * szLang) = 0;

 protected:
    ISpellChecker ();
    virtual ~ISpellChecker ();
};

class SpellManager
{
 public:
  static SpellManager * instance (void);

  virtual ~SpellManager ();

  virtual ISpellChecker * requestDictionary (const char * szLang);

// either we're managing a pspell-based backend or an ispell-based one
#ifdef HAVE_PSPELL
  typedef PSpellChecker SpellCheckerClass;
#else
  typedef ISpellChecker SpellCheckerClass;
#endif

 protected:
  SpellManager ();

 private:
  UT_HashTable m_map;
};
