/*
 * Code copyright Dom Lachowicz <cinamod@hotmail.com> 2001
 * Copyrighted under the GNU GPL version 2.0
 * http://www.fsf.org/
 */

#include "spell.h"

/*!
 * Abstract constructor
 */
/* protected */ ISpellChecker::ISpellChecker ()
{
  // not used, abstract base class
}

/*!
 * Abstract destructor
 */
/* protected */ ISpellChecker::~ISpellChecker ()
{
  // not used, abstract base class
}

/***********************************************************************/
/***********************************************************************/

// Singleton implementation
static SpellManager * s_instance = 0;

// some arbitrary number for how many language buckets to have by default
#define NBUCKETS 5

/*!
 * Protected constructor
 *
 * This (Singleton) class is responsible for creating, handing out, 
 * and destroying instances of the ISpellChecker class
 */
/* protected */ SpellManager::SpellManager ()
  : m_map (NBUCKETS)
{
}

/*!
 * Destructor
 */
SpellManager::~SpellManager ()
{
  UT_HASH_PURGEDATA (SpellCheckerClass, m_map);
}

/*!
 * If an instance already exists it will be returned for you.
 * If not, one is created and returned for you
 * \return A valid instance of the SpellManager class
 */
/* static */ SpellManager *
SpellManager::instance (void)
{
  if (!s_instance)
    {
      s_instance = new SpellManager ();
    }
  return s_instance;
}

/*!
 * Request an instance of a dictionary capable of checking the language
 * Represented by szLang
 *
 * \param szLang - For Ispell, the path to the hash file we want to use
 *                 For Pspell, the language tag ("en_US") we want to use
 * \return A valid ISpellChecker for 'szLang' on success, or 0 on failure
 */
ISpellChecker *
SpellManager::requestDictionary (const char * szLang)
{  
  SpellCheckerClass * checker = 0;

  checker = new SpellCheckerClass ();

  if (checker.requestDictionary (szLang))
    {      
      m_map.addEntry (lang, 0, checker);
      return checker;
    }
  else
    {
      delete checker;
      return 0;
    }
}
