/*
 * Really dumb, incomplete, and simple test program to
 * see if my glib dumbing down worked
 * 
 * Dom Lachowicz (dominicl@seas.upenn.edu)
 */

#include <stdio.h>
#include <string.h>
#include "glib.h"

static void
rif1 (void)
{
  g_return_if_fail (NULL);
}

static void *
rif2 (void)
{
  g_return_val_if_fail (NULL, NULL);
}

static void
rif3 (void)
{
  g_assert (NULL);
}

static void
rif4 (void)
{
  g_assert_not_reached ();
}

static void
warning_tests (void)
{
  rif1();
  printf ("should be null\n");
  printf (rif2() == NULL? "NULL\n" : "Not Null\n");
  rif3();
  rif4();
}

static void
msg_tests(void)
{
  printf (g_strdup ("Hello world\n"));
  printf (g_strndup ("Hello world\n", 5));
  g_print ("Hello world\n");
  g_print ("Hello %s\n", "world!");
  g_printerr ("Hello world!\n");
}

static void
mem_tests (void)
{
  char *str = g_new (char, 25);
  int i;

  strcpy (str, "Hello world");
  printf ("strlen: %d\n", strlen (str));
  g_free (str);

  str = g_new0 (char, 25);
  printf ("The following should be all zero\n");
  for (i = 0; i < 25; i++) {
    if (str[i] == 0)
      printf ("0");
    else
      printf ("not zero");
  }

  g_free (str);
}

static void
print_list_item (char *str, gpointer ignore)
{
  printf ("%s", str);
}

static void
list_tests (void)
{
  GList *l1 = NULL;
  int i;

  for (i = 0; i < 10; i++) {
    l1 = g_list_append (l1, g_strdup_printf ("%d", i));
  }

  printf ("\nShould be 0123456789\n");
  g_list_foreach (l1, (GFunc)print_list_item, NULL);
  printf ("\n");

  l1 = g_list_reverse (l1);

  printf ("Should be 9876543210\n");
  g_list_foreach (l1, (GFunc)print_list_item, NULL);
  printf ("\n");
  
  printf ("Should be lol 987654321\n");
  l1 = g_list_prepend (l1, "lol ");
  g_list_foreach (l1, (GFunc)print_list_item, NULL);
  printf ("\n");
}

static void
array_tests (void)
{
  GArray *arr = g_array_new (TRUE, TRUE, sizeof(int));
  gint i, j;

  for (i = 0; i < 30; i++) {
    j = i * 2;
    g_array_append_val (arr, j);
  }

  printf("Should be 16: %d\n", g_array_index (arr, int, 8));
  printf("Should be 32: %d\n", g_array_index (arr, int, 16));
  printf("Should be 10: %d\n", g_array_index (arr, int, 5));
  printf("Should be 4: %d\n", g_array_index (arr, int, 2));

  g_array_remove_index (arr, 8);
  printf ("After removing index 8\n");
  printf("Should be 18: %d\n", g_array_index (arr, int, 8));
}

int main (int argc, char *argv[])
{
  warning_tests();
  msg_tests();
  mem_tests();
  list_tests();
  array_tests();
  return 0;
}
