# include "stdio.h"
# define U(x) ((x)&0377)
# define NLSTATE pp_lexer_previous=YYNEWLINE
# define BEGIN pp_lexer_bgin = pp_lexer_svec + 1 +
# define INITIAL 0
# define YYLERR pp_lexer_svec
# define YYSTATE (pp_lexer_estate-pp_lexer_svec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,pp_lexer_out)
# define input() (((pp_lexer_tchar=pp_lexer_sptr>pp_lexer_sbuf?U(*--pp_lexer_sptr):getc(pp_lexer_in))==10?(pp_lexer_lineno++,pp_lexer_tchar):pp_lexer_tchar)==EOF?0:pp_lexer_tchar)
# define unput(c) {pp_lexer_tchar= (c);if(pp_lexer_tchar=='\n')pp_lexer_lineno--;*pp_lexer_sptr++=pp_lexer_tchar;}
# define pp_lexer_more() (pp_lexer_morfg=1)
# define ECHO fprintf(pp_lexer_out, "%s",pp_lexer_text)
# define REJECT { nstr = pp_lexer_reject(); goto pp_lexer_fussy;}
int pp_lexer_leng; extern unsigned char pp_lexer_text[];
int pp_lexer_morfg;
extern unsigned char *pp_lexer_sptr, pp_lexer_sbuf[];
int pp_lexer_tchar;
FILE *pp_lexer_in = {stdin}, *pp_lexer_out = {stdout};
extern int pp_lexer_lineno;
struct pp_lexer_svf { 
	struct pp_lexer_work *pp_lexer_stoff;
	struct pp_lexer_svf *pp_lexer_other;
	int *pp_lexer_stops;};
struct pp_lexer_svf *pp_lexer_estate;
extern struct pp_lexer_svf pp_lexer_svec[], *pp_lexer_bgin;
/**************************************************************************
   Lex specification for post-process knowledge file 

   6/96 ALB
   Possible areas of improvement:
    . allow sets to be referred to anywhere in file, not just 
      after they are defined. (but then you need to be careful
      about infinite loops involving recursively defined sets) 

**************************************************************************/

#include "pp_lexer.h"
#include "header.h"

#undef pp_lexer_wrap

#define PP_LEXER_MAX_LABELS   1024
#define PP_LEXER_MAX_INCLUDES 1024

static int q_verbose = 0;

/* forward references for non-exported functions */
static void check_string(const char *str);
static void setup();
static void set_label(const char *label);
static void add_string_to_label(const char *str);
static void add_set_of_strings_to_label(const char *label_of_set);
static void show_bindings();
static void copy_string_into(const char *source, char **target);
static int  get_index_of_label(const char *label);
static void push_file(char *fname);
static void pop_file();

# define INCLUDE 2
# define YYNEWLINE 10
pp_lexer_lex(){
int nstr; extern int pp_lexer_previous;
while((nstr = pp_lexer_look()) >= 0)
pp_lexer_fussy: switch(nstr){
case 0:
if(pp_lexer_wrap()) return(0); break;
case 1:
 { BEGIN INCLUDE; }
break;
case 2:
        { q_verbose = 1; }
break;
case 3:
       {  push_file(pp_lexer_text);
                              BEGIN INITIAL; }
break;
case 4:
           {  static char fname[256];
                              strcpy(fname, &pp_lexer_text[1]);
                              fname[strlen(fname)-1]=0; 
                              push_file(fname);
                              BEGIN INITIAL;  }
break;
case 5:
                 ;
break;
case 6:
                  ;
break;
case 7:
         { set_label(pp_lexer_text); }
break;
case 8:
    { add_set_of_strings_to_label(&(pp_lexer_text[1])); }
break;
case 9:
       { add_string_to_label(pp_lexer_text); }
break;
case 10:
{ add_string_to_label(pp_lexer_text); }
break;
case 11:
 { error("pp_lexer: unable to parse knowledge file (line %i).\n",pp_lexer_lineno); }
break;
case -1:
break;
default:
fprintf(pp_lexer_out,"bad switch pp_lexer_look %d",nstr);
} return(0); }
/* end of pp_lexer_lex */

/************************** static variables ***************************/
typedef struct label_node {
  char *str;                      
  struct label_node *next; } LABEL_NODE; /* next=NULL: end of list */

static char *labels[PP_LEXER_MAX_LABELS]; /*array of labels (NULL-terminated)*/
static int idx_of_active_label = -1;
static LABEL_NODE *nodes_of_label[PP_LEXER_MAX_LABELS]; /*str. for each label*/
static LABEL_NODE *last_node_of_label[PP_LEXER_MAX_LABELS];    /* efficiency */
static LABEL_NODE *current_node_of_active_label;

/* variables related to management of a stack of included info files */
static int     file_stack_counter;
static int     num_files_read = 0; 
static FILE    *file_stack[PP_LEXER_MAX_INCLUDES];
static char    *files_read[PP_LEXER_MAX_INCLUDES];

/************************ exported functions ******************************/

void pp_lexer_open(FILE *f)
{
  /* open knowledge file */
  pp_lexer_in = f;
  if (pp_lexer_in==NULL) error("internal error");

  /* set up data structures */
  setup();

  /* perform the lexical analysis */
  pp_lexer_lex();  

  /* for debugging purposes */
  if (q_verbose) {
    show_bindings();
    q_verbose = 0;
    }      
}

int pp_lexer_set_label(const char *label) {
  idx_of_active_label = get_index_of_label(label);
  if (idx_of_active_label==-1) return 0;    /* label not found */
  current_node_of_active_label = nodes_of_label[idx_of_active_label];
  return 1;
}

int pp_lexer_count_tokens_of_label() {
  /* counts all tokens, indiscriminately */
  int n_tokens;
  LABEL_NODE *p;
  if (idx_of_active_label==-1) error("pp_lexer: current label is invalid");
  for (n_tokens=0, p=nodes_of_label[idx_of_active_label]; 
       p!=NULL; 
       p=p->next, n_tokens++);
  return n_tokens;
}


char *pp_lexer_get_next_token_of_label() {
  /* retrieves next token, indiscriminately. Returns NULL if list exhausted */
  static char *p;
  if (current_node_of_active_label == NULL) return NULL;
  p = current_node_of_active_label->str;
  current_node_of_active_label = current_node_of_active_label->next;
  return p;
}

int pp_lexer_count_commas_of_label() {
  int n_commas;
  LABEL_NODE *p;
  if (idx_of_active_label==-1) error("pp_lexer: current label is invalid");
  for (n_commas=0,p=nodes_of_label[idx_of_active_label];p!=NULL;p=p->next)
    if (!strcmp(p->str, ",")) n_commas++;
  return n_commas;
}

void pp_lexer_get_next_group_of_tokens_of_label(int *n_tokens,char ***tokens){ 
  /* all tokens until next comma, null-terminated */
  int i, n_toks;
  LABEL_NODE *p;
  static char **toks;
  static int extents=-1;
  
  /* 1st pass: how many tokens until next comma? Reallocate if needed */
  p=current_node_of_active_label;
  for (n_toks=0; p!=NULL && strcmp(p->str,","); n_toks++, p=p->next);

  /* re-allocate static array of tokens, if necessary */
  if (n_toks>extents) {
    if (extents>-1) {
      for (i=0; i<extents; i++)
   	xfree(toks[i], strlen(toks[i]));
      xfree((char*) toks, extents*sizeof(char*));
    }
    extents=n_toks;   
    toks=(char **) xalloc (extents*sizeof(char*));
  }
  else {
    /* just free those strings which we need to realloc this time */
    for (i=0; i<n_toks; i++)
      xfree(toks[i],strlen(toks[i]));
  }

  /* 2nd pass: fill them in */
  p=current_node_of_active_label;
  for (i=0; i<n_toks; i++, p=p->next)
    copy_string_into(p->str, &(toks[i]));

  /* now update pointer to current node in linked list of strings for label */
  current_node_of_active_label = p;
  if (p!=NULL) current_node_of_active_label=p->next;

  *n_tokens = n_toks;
  *tokens   = toks;
}

int pp_lexer_wrap()
{
  /* must return 1 for end of input, 0 otherwise */
  if (file_stack_counter) 
    {
      pop_file();
      return 0;
    }
  return 1;
}

/********************** non-exported functions ************************/

static void check_string(const char *str)
{
   if (strlen(str)>1 && strchr(str, ',')!=NULL)
      error("pp_lexer: string %s contains a comma, which is a no-no.",str);
}

static void setup() {
  int i;
  for (i=0; i<PP_LEXER_MAX_LABELS; i++)
    {
      nodes_of_label[i]     = NULL;
      last_node_of_label[i] = NULL;
    }
  labels[0]=NULL;
}


static void set_label(const char *label) {
  char *label_sans_colon;
  int i;

  /* first, slice off the trailing colon */
  copy_string_into(label, &label_sans_colon);
  label_sans_colon[strlen(label)-1]=0;       

  /* have we seen this label already? If so, abort */
  for (i=0; labels[i]!=NULL && strcmp(labels[i], label_sans_colon); i++);
  if (labels[i]!=NULL) 
  error("pp_lexer: label %s multiply defined!", label_sans_colon);

  /* new label. Store it */
  if (i == PP_LEXER_MAX_LABELS-1)   /* keep the -1! */
    error("pp_lexer: too many labels. Raise PP_LEXER_MAX_LABELS");
  copy_string_into(label_sans_colon, &labels[i]);     
  idx_of_active_label = i;
}


static void add_string_to_label(const char *str) {
  /* add the single string str to the set of strings associated with label */
  LABEL_NODE *new_node;

  if (idx_of_active_label==-1)
  error("pp_lexer: invalid syntax (line %i)",pp_lexer_lineno);

  /* make sure string is legal */
  check_string(str);

  /* create a new node in (as yet to be determined) linked list of strings */
  new_node = (LABEL_NODE *) xalloc (sizeof(LABEL_NODE));
  copy_string_into(str, &(new_node->str));
  new_node->next = NULL;

  /* stick newly-created node at the *end* of the appropriate linked list */
  if (last_node_of_label[idx_of_active_label]==NULL)
    {
      /* first entry on linked list */
      nodes_of_label[idx_of_active_label] = new_node;      
      last_node_of_label[idx_of_active_label] = new_node;
    }
  else
    {
      /* non-first entry on linked list */
      last_node_of_label[idx_of_active_label]->next = new_node;
      last_node_of_label[idx_of_active_label] = new_node;
    }
}

static void add_set_of_strings_to_label(const char *label_of_set) {
  /* add the set of strings, defined earlier by label_of_set, to the set of 
     strings associated with the current label */
  LABEL_NODE *p;
  int idx_of_label_of_set;
  if (idx_of_active_label==-1)
  error("pp_lexer: invalid syntax (line %i)",pp_lexer_lineno);
  if ((idx_of_label_of_set = get_index_of_label(label_of_set))==-1)
    error("pp_lexer: label %s must be defined before it's referred to(line %i)"
	  ,label_of_set, pp_lexer_lineno);
  for (p=nodes_of_label[idx_of_label_of_set]; p!=NULL; p=p->next)
    add_string_to_label(p->str);
}


static void show_bindings()
{
  /* show contents of knowledge file, as arranged internally */
  int i,j;
  char *la;
  LABEL_NODE *p;
  printf("The symbol table's contents: \n");
  for (i=0; (la=labels[i])!=NULL; i++)
    {
      printf("\n\n%s\n", la);
      for (j=0; j<strlen(la); j++)
	printf("=");
      printf("\n");
      for (p=nodes_of_label[i]; p!=NULL; p=p->next)
	printf(" %s ", p->str);
    }
  printf("\n");
}

static void copy_string_into(const char *source, char **target)
{
  *target = (char*) xalloc ((strlen(source)+1)*sizeof(char));
  strcpy(*target, source);
}


static int get_index_of_label(const char *label) {
  int i;
  for (i=0; labels[i]!=NULL; i++) {
    if (!strcmp(labels[i], label)) return i;
  }
  return -1;
}
    

static void push_file(char *fname)
{
  /* Don't read an include file twice (could go into infinite loop) */
  int i;
  for (i=0; i<num_files_read; i++)
    if (!strcmp(fname, files_read[i])) return;
  
  /* Haven't seen this file yet. Save name to avoid re-reading it later */
  copy_string_into(fname, &(files_read[num_files_read]));

  /* have we exhausted our stack? */
  if (file_stack_counter == PP_LEXER_MAX_INCLUDES)
    error("pp_lexer: exceeded maximum number of allowed include files.\n\
Try increasing PP_LEXER_MAX_INCLUDE_FILES.");
  
  /* Push current file onto stack of active include files; open new one */
  file_stack[file_stack_counter++] = pp_lexer_in;
  pp_lexer_in = fopen(fname, "rt");
  if (pp_lexer_in==0) 
  error("pp_lexer: cannot locate specified include file %s.",fname);
}


static void pop_file()
{
  pp_lexer_in = file_stack[--file_stack_counter];
}











int pp_lexer_vstop[] = {
0,

6,
0,

6,
0,

6,
0,

6,
0,

9,
11,
0,

6,
11,
0,

6,
0,

11,
0,

11,
0,

9,
11,
0,

6,
11,
0,

9,
11,
0,

9,
11,
-5,
0,

3,
11,
0,

11,
0,

3,
11,
-5,
0,

9,
0,

7,
0,

8,
9,
0,

6,
0,

-5,
0,

9,
0,

9,
0,

9,
-5,
0,

5,
0,

7,
-5,
0,

3,
0,

4,
0,

3,
-5,
0,

10,
0,

9,
0,

9,
0,

9,
0,

9,
0,

9,
0,

9,
0,

9,
0,

9,
0,

9,
0,

9,
0,

1,
9,
0,

2,
9,
0,

1,
0,

2,
0,

2,
7,
0,
0};
# define YYTYPE unsigned char
struct pp_lexer_work { YYTYPE verify, advance; } pp_lexer_crank[] = {
0,0,	0,0,	1,5,	0,0,	
0,0,	0,0,	0,0,	3,14,	
0,0,	0,0,	1,6,	1,7,	
29,0,	2,11,	5,17,	3,6,	
3,7,	30,0,	8,19,	4,11,	
6,7,	6,7,	5,0,	5,0,	
0,0,	0,0,	8,0,	8,0,	
0,0,	0,0,	11,21,	11,7,	
0,0,	1,6,	0,0,	1,8,	
2,11,	0,0,	3,6,	2,12,	
3,15,	16,31,	4,11,	6,7,	
0,0,	5,0,	10,20,	5,0,	
22,22,	8,19,	27,22,	8,0,	
0,0,	11,21,	10,0,	10,0,	
31,31,	0,0,	0,0,	1,9,	
12,0,	12,0,	1,5,	2,13,	
3,14,	1,10,	0,0,	3,9,	
2,10,	4,16,	0,0,	5,18,	
19,0,	19,0,	5,17,	8,0,	
0,0,	10,0,	8,19,	10,0,	
11,22,	13,25,	0,0,	12,0,	
0,0,	12,0,	14,28,	46,46,	
0,0,	13,22,	13,26,	15,29,	
45,45,	45,45,	14,0,	14,0,	
46,0,	19,32,	16,31,	15,29,	
15,0,	16,22,	17,0,	17,0,	
0,0,	22,22,	10,20,	27,22,	
22,22,	0,0,	27,22,	0,0,	
13,22,	31,31,	13,22,	45,45,	
31,22,	14,0,	0,0,	14,0,	
0,0,	19,0,	15,29,	0,0,	
15,30,	17,0,	20,20,	17,0,	
0,0,	23,0,	23,0,	0,0,	
0,0,	0,0,	20,0,	20,0,	
0,0,	0,0,	13,27,	24,0,	
24,0,	13,25,	0,0,	14,28,	
46,46,	0,0,	14,0,	46,46,	
15,29,	28,0,	28,0,	15,29,	
23,0,	0,0,	23,0,	0,0,	
12,23,	20,0,	0,0,	20,0,	
33,0,	33,0,	24,0,	0,0,	
24,0,	34,0,	34,0,	0,0,	
0,0,	12,24,	35,0,	35,0,	
28,0,	0,0,	28,0,	36,0,	
36,0,	0,0,	0,0,	37,0,	
37,0,	0,0,	0,0,	33,0,	
0,0,	33,0,	20,20,	0,0,	
34,0,	0,0,	34,0,	38,0,	
38,0,	35,0,	0,0,	35,0,	
40,0,	40,0,	36,0,	47,46,	
36,0,	28,0,	37,0,	0,0,	
37,0,	0,0,	0,0,	0,0,	
47,0,	39,0,	39,0,	0,0,	
41,0,	41,0,	38,0,	0,0,	
38,0,	42,0,	42,0,	40,0,	
44,44,	40,0,	43,45,	43,45,	
0,0,	0,0,	0,0,	0,0,	
44,46,	44,0,	23,33,	24,34,	
39,0,	0,0,	39,0,	41,0,	
0,0,	41,0,	0,0,	0,0,	
42,0,	0,0,	42,0,	0,0,	
0,0,	43,45,	0,0,	43,0,	
0,0,	0,0,	33,35,	44,46,	
0,0,	44,46,	0,0,	0,0,	
47,46,	0,0,	0,0,	47,46,	
0,0,	0,0,	0,0,	0,0,	
36,38,	0,0,	0,0,	0,0,	
0,0,	35,37,	34,36,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	44,47,	0,0,	0,0,	
44,44,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	37,39,	
0,0,	0,0,	0,0,	0,0,	
0,0,	38,40,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
39,41,	0,0,	40,42,	0,0,	
41,43,	0,0,	0,0,	0,0,	
0,0,	42,44,	0,0,	0,0,	
0,0};
struct pp_lexer_svf pp_lexer_svec[] = {
0,	0,	0,
pp_lexer_crank+-1,	0,		pp_lexer_vstop+1,
pp_lexer_crank+-4,	pp_lexer_svec+1,	pp_lexer_vstop+3,
pp_lexer_crank+-6,	0,		pp_lexer_vstop+5,
pp_lexer_crank+-10,	pp_lexer_svec+3,	pp_lexer_vstop+7,
pp_lexer_crank+-13,	0,		pp_lexer_vstop+9,
pp_lexer_crank+11,	0,		pp_lexer_vstop+12,
pp_lexer_crank+0,	pp_lexer_svec+6,	pp_lexer_vstop+15,
pp_lexer_crank+-17,	0,		pp_lexer_vstop+17,
pp_lexer_crank+0,	0,		pp_lexer_vstop+19,
pp_lexer_crank+-45,	pp_lexer_svec+5,	pp_lexer_vstop+21,
pp_lexer_crank+21,	0,		pp_lexer_vstop+24,
pp_lexer_crank+-51,	pp_lexer_svec+5,	pp_lexer_vstop+27,
pp_lexer_crank+-80,	0,		pp_lexer_vstop+30,
pp_lexer_crank+-85,	0,		pp_lexer_vstop+34,
pp_lexer_crank+-90,	0,		pp_lexer_vstop+37,
pp_lexer_crank+-40,	pp_lexer_svec+13,	pp_lexer_vstop+39,
pp_lexer_crank+-93,	pp_lexer_svec+5,	pp_lexer_vstop+43,
pp_lexer_crank+0,	0,		pp_lexer_vstop+45,
pp_lexer_crank+-63,	pp_lexer_svec+8,	0,	
pp_lexer_crank+-125,	pp_lexer_svec+5,	pp_lexer_vstop+47,
pp_lexer_crank+0,	pp_lexer_svec+11,	pp_lexer_vstop+50,
pp_lexer_crank+-47,	pp_lexer_svec+13,	pp_lexer_vstop+52,
pp_lexer_crank+-120,	pp_lexer_svec+5,	pp_lexer_vstop+54,
pp_lexer_crank+-130,	pp_lexer_svec+5,	pp_lexer_vstop+56,
pp_lexer_crank+0,	pp_lexer_svec+13,	pp_lexer_vstop+58,
pp_lexer_crank+0,	0,		pp_lexer_vstop+61,
pp_lexer_crank+-49,	pp_lexer_svec+13,	pp_lexer_vstop+63,
pp_lexer_crank+-140,	pp_lexer_svec+14,	pp_lexer_vstop+66,
pp_lexer_crank+-2,	pp_lexer_svec+15,	0,	
pp_lexer_crank+-7,	pp_lexer_svec+15,	pp_lexer_vstop+68,
pp_lexer_crank+-55,	pp_lexer_svec+13,	pp_lexer_vstop+70,
pp_lexer_crank+0,	0,		pp_lexer_vstop+73,
pp_lexer_crank+-151,	pp_lexer_svec+5,	pp_lexer_vstop+75,
pp_lexer_crank+-156,	pp_lexer_svec+5,	pp_lexer_vstop+77,
pp_lexer_crank+-161,	pp_lexer_svec+5,	pp_lexer_vstop+79,
pp_lexer_crank+-166,	pp_lexer_svec+5,	pp_lexer_vstop+81,
pp_lexer_crank+-170,	pp_lexer_svec+5,	pp_lexer_vstop+83,
pp_lexer_crank+-182,	pp_lexer_svec+5,	pp_lexer_vstop+85,
pp_lexer_crank+-200,	pp_lexer_svec+5,	pp_lexer_vstop+87,
pp_lexer_crank+-187,	pp_lexer_svec+5,	pp_lexer_vstop+89,
pp_lexer_crank+-203,	pp_lexer_svec+5,	pp_lexer_vstop+91,
pp_lexer_crank+-208,	pp_lexer_svec+5,	pp_lexer_vstop+93,
pp_lexer_crank+-213,	pp_lexer_svec+5,	pp_lexer_vstop+95,
pp_lexer_crank+-219,	0,		pp_lexer_vstop+98,
pp_lexer_crank+83,	0,		pp_lexer_vstop+101,
pp_lexer_crank+-86,	pp_lexer_svec+44,	pp_lexer_vstop+103,
pp_lexer_crank+-198,	pp_lexer_svec+44,	pp_lexer_vstop+105,
0,	0,	0};
struct pp_lexer_work *pp_lexer_top = pp_lexer_crank+309;
struct pp_lexer_svf *pp_lexer_bgin = pp_lexer_svec+1;
unsigned char pp_lexer_match[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
' ' ,01  ,'"' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,':' ,01  ,01  ,'=' ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
unsigned char pp_lexer_extra[] = {
0,0,0,0,0,1,0,0,
0,0,0,0,0,0,0,0,
0};
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
*/
/*
#
# IBM CONFIDENTIAL
# Copyright International Business Machines Corp. 1989
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of IBM
#
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
# 
*/
/* @(#)ncform	1.3  com/lib/l,3.1,8951 9/7/89 18:48:47 */
int pp_lexer_lineno =1;
# define YYU(x) x
# define NLSTATE pp_lexer_previous=YYNEWLINE
unsigned char pp_lexer_text[YYLMAX];
struct pp_lexer_svf *pp_lexer_lstate [YYLMAX], **pp_lexer_lsp, **pp_lexer_olsp;
unsigned char pp_lexer_sbuf[YYLMAX];
unsigned char *pp_lexer_sptr = pp_lexer_sbuf;
int *pp_lexer_fnd;
extern struct pp_lexer_svf *pp_lexer_estate;
int pp_lexer_previous = YYNEWLINE;
pp_lexer_look(){
	register struct pp_lexer_svf *pp_lexer_state, **lsp;
	register struct pp_lexer_work *pp_lexer_t;
	struct pp_lexer_svf *pp_lexer_z;
	int pp_lexer_ch, pp_lexer_first;
	struct pp_lexer_work *pp_lexer_r;
# ifdef LEXDEBUG
	int debug;
# endif
	unsigned char *pp_lexer_lastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	pp_lexer_first=1;
	if (!pp_lexer_morfg)
		pp_lexer_lastch = pp_lexer_text;
	else {
		pp_lexer_morfg=0;
		pp_lexer_lastch = pp_lexer_text+pp_lexer_leng;
		}
	for(;;){
		lsp = pp_lexer_lstate;
		pp_lexer_estate = pp_lexer_state = pp_lexer_bgin;
		if (pp_lexer_previous==YYNEWLINE) pp_lexer_state++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(pp_lexer_out,"state %d\n",pp_lexer_state-pp_lexer_svec-1);
# endif
			pp_lexer_t = pp_lexer_state->pp_lexer_stoff;
			if(pp_lexer_t == pp_lexer_crank && !pp_lexer_first){  /* may not be any transitions */
				pp_lexer_z = pp_lexer_state->pp_lexer_other;
				if(pp_lexer_z == 0)break;
				if(pp_lexer_z->pp_lexer_stoff == pp_lexer_crank)break;
				}
			*pp_lexer_lastch++ = pp_lexer_ch = input();
			pp_lexer_first=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(pp_lexer_out,"char ");
				allprint(pp_lexer_ch);
				putchar('\n');
				}
# endif
			pp_lexer_r = pp_lexer_t;
			if ( pp_lexer_t > pp_lexer_crank){
				pp_lexer_t = pp_lexer_r + pp_lexer_ch;
				if (pp_lexer_t <= pp_lexer_top && pp_lexer_t->verify+pp_lexer_svec == pp_lexer_state){
					if(pp_lexer_t->advance+pp_lexer_svec == YYLERR)	/* error transitions */
						{unput(*--pp_lexer_lastch);break;}
					*lsp++ = pp_lexer_state = pp_lexer_t->advance+pp_lexer_svec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if(pp_lexer_t < pp_lexer_crank) {		/* r < pp_lexer_crank */
				pp_lexer_t = pp_lexer_r = pp_lexer_crank+(pp_lexer_crank-pp_lexer_t);
# ifdef LEXDEBUG
				if(debug)fprintf(pp_lexer_out,"compressed state\n");
# endif
				pp_lexer_t = pp_lexer_t + pp_lexer_ch;
				if(pp_lexer_t <= pp_lexer_top && pp_lexer_t->verify+pp_lexer_svec == pp_lexer_state){
					if(pp_lexer_t->advance+pp_lexer_svec == YYLERR)	/* error transitions */
						{unput(*--pp_lexer_lastch);break;}
					*lsp++ = pp_lexer_state = pp_lexer_t->advance+pp_lexer_svec;
					goto contin;
					}
				pp_lexer_t = pp_lexer_r + YYU(pp_lexer_match[pp_lexer_ch]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(pp_lexer_out,"try fall back character ");
					allprint(YYU(pp_lexer_match[pp_lexer_ch]));
					putchar('\n');
					}
# endif
				if(pp_lexer_t <= pp_lexer_top && pp_lexer_t->verify+pp_lexer_svec == pp_lexer_state){
					if(pp_lexer_t->advance+pp_lexer_svec == YYLERR)	/* error transition */
						{unput(*--pp_lexer_lastch);break;}
					*lsp++ = pp_lexer_state = pp_lexer_t->advance+pp_lexer_svec;
					goto contin;
					}
				}
			if ((pp_lexer_state = pp_lexer_state->pp_lexer_other) && (pp_lexer_t= pp_lexer_state->pp_lexer_stoff) != pp_lexer_crank){
# ifdef LEXDEBUG
				if(debug)fprintf(pp_lexer_out,"fall back to state %d\n",pp_lexer_state-pp_lexer_svec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--pp_lexer_lastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(pp_lexer_out,"state %d char ",pp_lexer_state-pp_lexer_svec-1);
				allprint(pp_lexer_ch);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(pp_lexer_out,"stopped at %d with ",*(lsp-1)-pp_lexer_svec-1);
			allprint(pp_lexer_ch);
			putchar('\n');
			}
# endif
		while (lsp-- > pp_lexer_lstate){
			*pp_lexer_lastch-- = 0;
			if (*lsp != 0 && (pp_lexer_fnd= (*lsp)->pp_lexer_stops) && *pp_lexer_fnd > 0){
				pp_lexer_olsp = lsp;
				if(pp_lexer_extra[*pp_lexer_fnd]){		/* must backup */
					while(pp_lexer_back((*lsp)->pp_lexer_stops,-*pp_lexer_fnd) != 1 && lsp > pp_lexer_lstate){
						lsp--;
						unput(*pp_lexer_lastch--);
						}
					}
				pp_lexer_previous = YYU(*pp_lexer_lastch);
				pp_lexer_lsp = lsp;
				pp_lexer_leng = pp_lexer_lastch-pp_lexer_text+1;
				pp_lexer_text[pp_lexer_leng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(pp_lexer_out,"\nmatch ");
					sprint(pp_lexer_text);
					fprintf(pp_lexer_out," action %d\n",*pp_lexer_fnd);
					}
# endif
				return(*pp_lexer_fnd++);
				}
			unput(*pp_lexer_lastch);
			}
		if (pp_lexer_text[0] == 0  /* && feof(pp_lexer_in) */)
			{
			pp_lexer_sptr=pp_lexer_sbuf;
			return(0);
			}
		pp_lexer_previous = pp_lexer_text[0] = input();
		if (pp_lexer_previous>0)
			output(pp_lexer_previous);
		pp_lexer_lastch=pp_lexer_text;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
pp_lexer_back(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
pp_lexer_input(){
	return(input());
	}
pp_lexer_output(c)
  int c; {
	output(c);
	}
pp_lexer_unput(c)
   int c; {
	unput(c);
	}
