 /***************************************************************************/
 /*                                                                         */
 /*       Copyright (C) 1991-1995  Daniel Sleator and Davy Temperley        */
 /*  See file "README" for information about commercial use of this system  */
 /*                                                                         */
 /***************************************************************************/

#include "header.h"

/* The first thing we do is we build a data structure to represent the
   result of the entire parse search.  There will be a set of nodes
   built for each call to the count() function that returned a non-zero
   value, AND which is part of a valid linkage.  Each of these nodes
   represents a valid continuation, and contains pointers to two other
   sets (one for the left continuation and one for the right
   continuation).

 */

Link link_array[MAX_LINKS];
int N_links;
Disjunct * chosen_disjuncts[MAX_SENTENCE];

#if 1

typedef struct Parse_choice_struct Parse_choice;
typedef struct Parse_set_struct Parse_set;

struct Parse_choice_struct {
    Parse_choice * next;
    Parse_set * set[2];
    Link link[2];   /* the lc fields of these is NULL if there is no link used */
    Disjunct *ld, *md, *rd;  /* the chosen disjuncts for the relevant three words */
};

struct Parse_set_struct {
    int count;  /* the number of ways */
    Parse_choice * first;
    Parse_choice * current;  /* used to enumerate linkages */
};

Parse_set * empty_set(void) {
    /* returns an empty set of parses */
    Parse_set *s;
    s = (Parse_set *) xalloc(sizeof(Parse_set));
    s->first = s->current = NULL;
    s->count = 0;
    return s;
}

void free_set(Parse_set *s) {
    Parse_choice *p, *xp;
    if (s == NULL) return;
    for (p=s->first; p != NULL; p = xp) {
	xp = p->next;
	xfree((void *)p, sizeof(*p));
    }
    xfree((void *)s, sizeof(*s));
}

Parse_choice * make_choice(Parse_set *lset, int llw, int lrw, Connector * llc, Connector * lrc,
			   Parse_set *rset, int rlw, int rrw, Connector * rlc, Connector * rrc,
			   Disjunct *ld, Disjunct *md, Disjunct *rd) {
    Parse_choice *pc;
    pc = (Parse_choice *) xalloc(sizeof(*pc));
    pc->next = NULL;
    pc->set[0] = lset;
    pc->link[0].l = llw;
    pc->link[0].r = lrw;
    pc->link[0].lc = llc;
    pc->link[0].rc = lrc;
    pc->set[1] = rset;
    pc->link[1].l = rlw;
    pc->link[1].r = rrw;
    pc->link[1].lc = rlc;
    pc->link[1].rc = rrc;
    pc->ld = ld;
    pc->md = md;
    pc->rd = rd;
    return pc;
}

void put_choice_in_set(Parse_set *s, Parse_choice *pc) {
/* Put this parse_choice into a given set.  The current pointer is always
   left pointing to the end of the list. */
    if (s->first == NULL) {
	s->first = pc;
    } else {
	s->current->next = pc;
    }
    s->current = pc;
    pc->next = NULL;
}

/* unfortunately, we have to duplicate all the hash table functions here
   because we don't want to store this extra set pointer field in
   the other hash table, which is already getting large.  I guess
   templates would obviate this.
 */

typedef struct X_table_connector_struct X_table_connector;
struct X_table_connector_struct {
    short             lw, rw;
    short             cost;
    Parse_set         *set;
    Connector         *le, *re;
    X_table_connector *next;
};

static int x_table_size;
static X_table_connector ** x_table;

int x_hash(int lw, int rw, Connector *le, Connector *re, int cost) {
    int i;
    i = 0;
    
    i = i + (i<<1) + randtable[(lw + i) & (RTSIZE - 1)];
    i = i + (i<<1) + randtable[(rw + i) & (RTSIZE - 1)];
    i = i + (i<<1) + randtable[(((long) le + i) % (x_table_size+1)) & (RTSIZE - 1)];
    i = i + (i<<1) + randtable[(((long) re + i) % (x_table_size+1)) & (RTSIZE - 1)];
    i = i + (i<<1) + randtable[(cost+i) & (RTSIZE - 1)];
    return i & (x_table_size-1);
}

void init_x_table(void) {
    /* A piecewise exponential function determines the size of the hash table.      */
    /* Probably should make use of the actual number of disjuncts, rather than just */
    /* the number of words                                                          */
    int i;
    if (N_words >= 10) {
	x_table_size = (1<<14);
    } else if (N_words >= 4) {
	x_table_size = (1 << (N_words));
    } else {
	x_table_size = (1 << 4);
    }
    /*printf("Allocating x_table of size %d\n", x_table_size);*/
    x_table = (X_table_connector**) xalloc(x_table_size * sizeof(X_table_connector*));
    for (i=0; i<x_table_size; i++) {
	x_table[i] = NULL;
    }
}
    
void free_x_table(void) {
/* This is the function that should be used to free tha set structure. Since
   it's a dag, a recursive free function won't work.  Every time we create
   a set element, we put it in the hash table, so this is OK.*/
    int i;
    X_table_connector *t, *x;

    if (x_table == NULL) {
	/*fprintf(stderr, "Warning: Tried to free a NULL x_table\n");*/
	return;
    }
    
    for (i=0; i<x_table_size; i++) {
	for(t = x_table[i]; t!= NULL; t=x) {
	    x = t->next;
	    free_set(t->set);
	    xfree((void *) t, sizeof(X_table_connector));
	}
    }
    /*printf("Freeing x_table of size %d\n", x_table_size);*/
    xfree((void *) x_table, x_table_size * sizeof(X_table_connector*));
    x_table_size = 0;
    x_table = NULL;
}

X_table_connector * x_table_pointer(int lw, int rw, Connector *le, Connector *re, int cost) {
    /* returns the pointer to this info, NULL if not there */
    X_table_connector *t;
    t = x_table[x_hash(lw, rw, le, re, cost)];
    for (; t != NULL; t = t->next) {
	if ((t->lw == lw) && (t->rw == rw) && (t->le == le) && (t->re == re) && (t->cost == cost))  return t;
    }
    return NULL;
}

#if 0
Parse_set * x_table_lookup(int lw, int rw, Connector *le, Connector *re, int cost) {
    /* returns the count for this quintuple if there, -1 otherwise */    
    X_table_connector *t = x_table_pointer(lw, rw, le, re, cost);

    if (t == NULL) return -1; else return t->set;
}
#endif

X_table_connector * x_table_store(int lw, int rw, Connector *le, Connector *re, int cost, Parse_set * set){
    /* Stores the value in the x_table.  Assumes it's not already there */
    X_table_connector *t, *n;
    int h;
    
    n = (X_table_connector *) xalloc(sizeof(X_table_connector));
    n->set = set; 
    n->lw = lw; n->rw = rw; n->le = le; n->re = re; n->cost = cost;
    h = x_hash(lw, rw, le, re, cost);
    t = x_table[h];
    n->next = t;
    x_table[h] = n;
    return n;
}

void x_table_update(int lw, int rw, Connector *le, Connector *re, int cost, Parse_set * set) {
    /* Stores the value in the x_table.  Unlike x_table_store, it assumes it's already there */
    X_table_connector *t = x_table_pointer(lw, rw, le, re, cost);
    
    assert(t != NULL, "This entry is supposed to be in the x_table.");
    t->set = set;
}

Parse_set * parse_set(Disjunct *ld, Disjunct *rd, int lw, int rw, Connector *le, Connector *re, int cost) {
    /* returns NULL if there are no ways to parse, or returns a pointer to a set structure
       representing all the ways to parse */
    Disjunct * d;
    int start_word, end_word, w;
    int lcost, rcost, Lmatch, Rmatch;
    int i, j;
    Parse_set *ls[4], *rs[4], *lset, *rset;
    Parse_choice * a_choice;

    Match_node * m, *m1;
    X_table_connector *xt;
    int count;

    assert(cost >= 0, "parse_set() called with cost < 0.");

    count = table_lookup(lw, rw, le, re, cost);

    /*
      assert(count >= 0, "parse_set() called on params that were not in the table.");
      Actually, we can't assert this, because of the pseudocount technique that's
      used in count().  It's not the case that every call to parse_set() has already
      been put into the table.
     */

    if (count <= 0) return NULL;
    
    xt = x_table_pointer(lw, rw, le, re, cost);

    if (xt == NULL) {
	xt = x_table_store(lw, rw, le, re, cost, empty_set());
	/* start it out with the empty set of options */
	/* this entry must be updated before we return */
    } else {
	return xt->set;  /* we've already computed it */
    }

    xt->set->count = count;  /* the count we already computed */
    /* this count is non-zero */
    
    if (rw == 1+lw) return xt->set;
    if ((le == NULL) && (re == NULL)) return xt->set;
    
    if (le == NULL) {
	start_word = lw+1;
    } else {
	start_word = le->word;
    }

    if (re == NULL) {
	end_word = MIN(rw-1, lw+maxlinklength); 
    } else {
	end_word = re->word;
    }
    
    for (w=start_word; w <= end_word; w++) {
	m1 = m = form_match_list(w, le, lw, re, rw); 
	for (; m!=NULL; m=m->next) {
	    d = m->d;
	    for (lcost = 0; lcost <= cost; lcost++) {
		rcost = cost-lcost;
		/* now lcost and rcost are the costs we're assigning to those parts respectively */

		/* Now, we determine if (based on table only) we can see that
		   the current range is not parsable. */

		Lmatch = (le != NULL) && (d->left != NULL) && match(le, d->left);
		Rmatch = (d->right != NULL) && (re != NULL) && match(d->right, re);
		for (i=0; i<4; i++) {ls[i] = rs[i] = NULL;}
		if (Lmatch) {
		    ls[0] = parse_set(ld, d, lw, w, le->next, d->left->next, lcost);
		    if (le->multi) ls[1] = parse_set(ld, d, lw, w, le, d->left->next, lcost);
		    if (d->left->multi) ls[2] = parse_set(ld, d, lw, w, le->next, d->left, lcost);
		    if (le->multi && d->left->multi) ls[3] = parse_set(ld, d, lw, w, le, d->left, lcost);
		}
		if (Rmatch) {
		    rs[0] = parse_set(d, rd, w, rw, d->right->next, re->next, rcost);
		    if (d->right->multi) rs[1] = parse_set(d, rd, w,rw,d->right,re->next, rcost);
		    if (re->multi) rs[2] = parse_set(d, rd, w, rw, d->right->next, re, rcost);
		    if (d->right->multi && re->multi) rs[3] = parse_set(d, rd, w, rw, d->right, re, rcost);
		}

		for (i=0; i<4; i++) {
		    /* this ordering is probably not consistent with that needed to use list_links */
		    if (ls[i] == NULL) continue;
		    for (j=0; j<4; j++) {
			if (rs[j] == NULL) continue;
			a_choice = make_choice(ls[i], lw, w, le, d->left,
					       rs[j], w, rw, d->right, re,
					       ld, d, rd);
			put_choice_in_set(xt->set, a_choice);
		    }
		}
		
		if (ls[0] != NULL || ls[1] != NULL || ls[2] != NULL || ls[3] != NULL) {
		    /* evaluate using the left match, but not the right */
		    rset = parse_set(d, rd, w, rw, d->right, re, rcost);
		    if (rset != NULL) {
			for (i=0; i<4; i++) {
			    if (ls[i] == NULL) continue;
			    /* this ordering is probably not consistent with that needed to use list_links */
			    a_choice = make_choice(ls[i], lw, w, le, d->left,
						   rset, w, rw, NULL /* d->right */, re,  /* the NULL indicates no link*/
						   ld, d, rd);
			    put_choice_in_set(xt->set, a_choice);
			}
		    }
		}
		if ((le == NULL) && (rs[0] != NULL || rs[1] != NULL || rs[2] != NULL || rs[3] != NULL)) {
		    /* evaluate using the right match, but not the left */
		    lset = parse_set(ld, d, lw, w, le, d->left, lcost);

		    if (lset != NULL) {
			for (i=0; i<4; i++) {
			    if (rs[i] == NULL) continue;
			    /* this ordering is probably not consistent with that needed to use list_links */
			    a_choice = make_choice(lset, lw, w, NULL /* le */, d->left,  /* NULL indicates no link */
						   rs[i], w, rw, d->right, re,
						   ld, d, rd);
			    put_choice_in_set(xt->set, a_choice);
			}
		    }
		}
	    }
	}
	put_match_list(m1);
    }
    xt->set->current = xt->set->first;
    return xt->set;
}

void verify_set_node(Parse_set *set) {
    Parse_choice *pc;
    int n;
    if (set == NULL || set->first == NULL) return;
    n = 0;
    for (pc = set->first; pc != NULL; pc = pc->next) {
	n += pc->set[0]->count * pc->set[1]->count;
    }
    assert(n == set->count, "verify_set failed");
}

void verify_set(void) {
    X_table_connector *t;
    int i;

    assert(x_table != NULL, "called verify_set when x_table==NULL");
    for (i=0; i<x_table_size; i++) for(t = x_table[i]; t!= NULL; t=t->next) verify_set_node(t->set);
}

static Parse_set whole_set;

void set_union(Parse_set * a, Parse_set * b) {
    /* move the elements of set b into set a. */
    /* make b empty.  Assumes the current pointer of a */
    /* points to the last element of a */
    Parse_choice *pc;

    if (b == NULL || b->first == NULL) return;  /* if b is empty, do nothing */
    for (pc = b->first; pc->next != NULL; pc = pc->next);  /* now pc is the last element of b */

    if (a->first == NULL) {
	a->first = b->first;
	a->current = pc;
    } else {
	a->current->next = b->first;
	a->current = pc;
    }
    b->first = b->current = NULL;
    a->count += b->count;
}

void build_parse_set(int cost) {
    /* This is the top level call that computes the whole parse_set.  It
       puts the result in whole_set.  It creates the necessary hash
       table (x_table) which will be freed at the same time the
       whole_set is freed.

       It also assumes that count() has been run, and that hash table is
       filled with the values thus computed.  Therefore this function
       must be structured just like parse() (the main function for
       count()).  */

    Disjunct * dis;

    init_x_table();

    whole_set.first = whole_set.current = NULL;
    whole_set.count = 0;
    
    for (dis = sentence[0].d; dis != NULL; dis = dis->next) {
	if (dis->left == NULL) {
	    set_union(&whole_set, parse_set(dis, NULL, 0, N_words, dis->right, NULL, cost));
	}
    }

    set_union(&whole_set, parse_set(NULL, NULL, 0, N_words, NULL, NULL, cost));
    if (whole_set.current != NULL) whole_set.current = whole_set.first;

    verify_set();  /* this is here for debugging.  Remove after this works */
}

void free_parse_set(void) {
    /* This uses the x_table to free the whole parse set (the set itself
       cannot be used cause it's a dag).  called from the outside world */
    Parse_set *junk;
    junk = (Parse_set *) xalloc(sizeof(Parse_set));  /* have to allocate
							a new set to
							free whole_set,
							cause it's not
							an allocated
							variable */
    *junk = whole_set;
    free_set(junk);
    whole_set.first = whole_set.current = NULL;
    free_x_table();
}

void initialize_links(void) {
    int i;
    N_links = 0;
    for (i=0; i<N_words; ++i) {
	chosen_disjuncts[i] = NULL;
    }
}

void issue_link(Disjunct * ld, Disjunct * rd, Link link) {
    link_array[N_links] = link;
    N_links++;

    chosen_disjuncts[link.l] = ld;
    chosen_disjuncts[link.r] = rd;
}

void issue_links_for_choice(Parse_choice *pc) {
    if (pc->link[0].lc != NULL) { /* there is a link to generate */
	issue_link(pc->ld, pc->md, pc->link[0]);
    }
    if (pc->link[1].lc != NULL) {
	issue_link(pc->md, pc->rd, pc->link[1]);
    }
}

void build_current_linkage_recursive(Parse_set *set) {
    if (set == NULL) return;
    if (set->current == NULL) return;

    issue_links_for_choice(set->current);
    build_current_linkage_recursive(set->current->set[0]);
    build_current_linkage_recursive(set->current->set[1]);
}

void build_current_linkage(void) {
    /* This function takes the "current" point in the given set and
       generates the linkage that it represents.
     */
    initialize_links();
    build_current_linkage_recursive(&whole_set);
}

int advance_linkage(Parse_set *set) {
    /* Advance the "current" linkage to the next one
       return 1 if there's a "carry" from this node,
       which indicates that the scan of this node has
       just been completed, and it's now back to it's
       starting state. */
    if (set == NULL) return 1;  /* probably can't happen */
    if (set->first == NULL) return 1;  /* the empty set */
    if (advance_linkage(set->current->set[0]) == 1) {
	if (advance_linkage(set->current->set[1]) == 1) {
	    if (set->current->next == NULL) {
		set->current = set->first;
		return 1;
	    }
	    set->current = set->current->next;
	}
    }
    return 0;
}

void advance_parse_set(void) {
     advance_linkage(&whole_set);
}

void list_links(Parse_set *set, int index) {
     Parse_choice *pc;
     int n;

     if (set == NULL || set->first == NULL) return;
     for (pc = set->first; pc != NULL; pc = pc->next) {
	  n = pc->set[0]->count * pc->set[1]->count;
	  if (index < n) break;
	  index -= n;
     }
     assert(pc != NULL, "walked off the end in list_links");
     issue_links_for_choice(pc);
     list_links(pc->set[0], index % pc->set[0]->count);
     list_links(pc->set[1], index / pc->set[0]->count);
}

void extract_links(int index, int cost) {
/* Generate the list of all links of the indexth parsing of the
   sentence.  For this to work, you must have already called parse, and
   already built the whole_set. */
    initialize_links();
    list_links(&whole_set, index);
}

#else

/*
void build_parse_set(int cost);
void free_parse_set(void);
void extract_links(int index, int cost);
void build_current_linkage(void);
void advance_parse_set(void);
*/

void build_parse_set(int cost) {}
void free_parse_set(void) {}
void build_current_linkage(void) {};
void advance_parse_set(void) {};

void issue_link(Disjunct *ld, Disjunct * rd, int lw, int rw,
		Connector * lc, Connector * rc) {
    link_array[N_links].l = lw;
    link_array[N_links].r = rw;
    link_array[N_links].lc = lc;
    link_array[N_links].rc = rc;
    N_links++;

    chosen_disjuncts[lw] = ld;
    chosen_disjuncts[rw] = rd;
}

int magic(int lw, int rw, Connector *le, Connector *re, int cost) {
/* returns the count for this quadruple if there, 0 otherwise */
/* the only difference between this and table_lookup is that  */
/* the latter returns -1 when it's not there, this returns 0  */
/* This will fool list_links into working, even though the    */
/* search may be conducted in a different order.  If one of   */
/* these bogus answers is returned, even though it may be     */
/* wrong, we know that this entry in the table could not be   */
/* used in any of the correct parsings, so it's ok to give the*/
/* wrong answer.                                              */
    int count;

    if (cost < 0) return 0;
    
    count = table_lookup(lw, rw, le, re, cost);
    if (count < 0) return 0; else return count;
}

void list_links(Disjunct *ld, Disjunct * rd, int lw, int rw,
                Connector *le, Connector *re, int cost, int index) {
    Disjunct * d;
    int leftcount, rightcount, total;
    int i, x, delta;
    int lml=0, lmr=0, rml=0, rmr=0;
    int lc, rc, lindex, rindex;
    int lcost, rcost;
    int w, start_word, end_word;
    Match_node * m, *m1;

    if (rw == 1+lw) {
	assert((le == NULL) && (re == NULL) && (index == 0),
	       "Error encountered while extracting links.");
	return;
    }

    if (cost < 0) return;

    if ((le == NULL) && (re == NULL)) {
	total = 0;
	w = lw+1;
	for (d = sentence[w].d; d != NULL; d = d->next) {
	    if (d->left == NULL) {
		i = magic(w, rw, d->right, re, cost-1);
		total += i;
		if ((total-i <= index) && (total > index)) {
		    list_links(d, rd, w, rw, d->right, re, cost-1, index-total+i);
		}
	    }
	}
	i = magic(w, rw, NULL, NULL, cost-1);
	total += i;
	if ((total - i <= index) && (total > index)) {
	    list_links(NULL, rd, w, rw, NULL, re, cost-1, index-total+i);
	}
	return;
    }


    total = 0;
    if (le == NULL) {
	start_word = lw+1;
    } else {
	start_word = le->word;
    }
    if (re == NULL) {
	end_word = MIN(rw-1, lw+maxlinklength);
    } else {
	end_word = re->word;
    }

    for (w=start_word; w <= end_word; w++) {
	m1 = m = form_match_list(w, le, lw, re, rw); 
	for (; m!=NULL; m=m->next) {
	    d = m->d;
	    for (lcost = 0; lcost <= cost; lcost++) {
		rcost = cost-lcost;
		/* now lcost and rcost are the costs we're assigning to those parts respectively */
		if ((le != NULL) && (d->left != NULL) && match(le, d->left)) {
		    lml = le->multi;
		    lmr = d->left->multi;
		    leftcount = magic(lw, w, le->next, d->left->next, lcost);
		    if (lml) leftcount += magic(lw, w, le, d->left->next, lcost);
		    if (lmr) leftcount += magic(lw, w, le->next, d->left, lcost);
		    if (lml&&lmr) leftcount += magic(lw, w, le, d->left, lcost);
		} else {
		    leftcount = 0;
		}
		if ((d->right != NULL) && (re != NULL) && match(d->right, re)) {
		    rml = d->right->multi;
		    rmr = re->multi;
		    rightcount = magic(w, rw, d->right->next,re->next, rcost);
		    if (rml) rightcount+= magic(w, rw, d->right, re->next, rcost);
		    if (rmr) rightcount+= magic(w, rw, d->right->next, re, rcost);
		    if (rml&&rmr) rightcount+= magic(w, rw, d->right, re, rcost);
		} else {
		    rightcount = 0;
		}
		i = leftcount * rightcount;
		total += i;
		
		if ((total-i <= index) && (total > index)) {
		    x = index-total+i;  /* 0 <= x < i */
		    lindex = x / rightcount;
		    rindex = x % rightcount;
		    lc = 0;
		    delta = magic(lw, w, le->next, d->left->next, lcost);
		    lc += delta;
		    if (lc > lindex) {
			issue_link(ld, d, lw, w, le, d->left);
			list_links(ld, d, lw, w, le->next, d->left->next, lcost, lindex-lc+delta);
		    }
		    if (lml) delta = magic(lw, w, le, d->left->next, lcost);
		    else delta = 0;
		    lc += delta;
		    if ((lc-delta <= lindex) && (lc > lindex)) {
			issue_link(ld, d, lw, w, le, d->left);
			list_links(ld, d, lw, w, le, d->left->next, lcost, lindex-lc+delta);
		    }
		    if (lmr) delta = magic(lw, w, le->next, d->left, lcost);
		    else delta=0;
		    lc += delta;
		    if ((lc-delta <=lindex) && lc > lindex) {
			issue_link(ld, d, lw, w, le, d->left);
			list_links(ld, d, lw, w, le->next, d->left, lcost, lindex-lc+delta);
		    }
		    if (lml&&lmr) delta = magic(lw, w, le, d->left, lcost);
		    else delta = 0;
		    lc += delta;
		    if ((lc-delta <=lindex) && lc > lindex) {
			issue_link(ld, d, lw, w, le, d->left);
			list_links(ld, d, lw, w, le, d->left, lcost, lindex-lc+delta);
		    }
		    rc = 0;
		    delta = magic(w, rw, d->right->next,re->next, rcost);
		    rc += delta;
		    if (rc > rindex) {
			issue_link(d, rd, w, rw, d->right, re);
			list_links(d, rd, w, rw, d->right->next, re->next, rcost, rindex-rc+delta);
		    }
		    if (rml) delta = magic(w, rw, d->right, re->next, rcost);
		    else delta = 0;
		    rc += delta;
		    if ((rc-delta <= rindex) && rc > rindex) {
			issue_link(d, rd, w, rw, d->right, re);
			list_links(d, rd, w, rw, d->right, re->next, rcost, rindex-rc+delta);
		    }
		    if (rmr) delta = magic(w, rw, d->right->next, re, rcost);
		    else delta = 0;
		    rc += delta;
		    if ((rc-delta <= rindex) && rc > rindex) {
			issue_link(d, rd, w, rw, d->right, re);
			list_links(d, rd, w, rw, d->right->next, re, rcost, rindex-rc+delta);
		    }
		    if (rml&&rmr) delta = magic(w, rw, d->right, re, rcost);
		    else delta = 0;
		    rc += delta;
		    if ((rc-delta <= rindex) && rc > rindex) {
			issue_link(d, rd, w, rw, d->right, re);
			list_links(d, rd, w, rw, d->right, re, rcost, rindex-rc+delta);
		    }
		}
		
		if (leftcount > 0) {
		    i = leftcount * magic(w, rw, d->right, re, rcost);
		} else {
		    i = 0;
		}
		total += i;
		if ((total-i <= index) && (total > index)) {
		    x = index-total+i;  /* 0 <= x < i */
		    lindex = x % leftcount;
		    rindex = x / leftcount;

		    lc = 0;
		    delta = magic(lw, w, le->next, d->left->next, lcost);
		    lc += delta;
		    if (lc > lindex) {
			issue_link(ld, d, lw, w, le, d->left);
			list_links(ld, d, lw, w, le->next,d->left->next, lcost, lindex-lc+delta);
		    }
		    if (lml) delta = magic(lw, w, le, d->left->next, lcost);
		    else delta = 0;
		    lc += delta;
		    if ((lc-delta <= lindex) && (lc > lindex)) {
			issue_link(ld, d, lw, w, le, d->left);
			list_links(ld, d, lw, w, le, d->left->next, lcost, lindex-lc+delta);
		    }
		    if (lmr) delta = magic(lw, w, le->next, d->left, lcost);
		    else delta=0;
		    lc += delta;
		    if ((lc-delta <=lindex) && lc > lindex) {
			issue_link(ld, d, lw, w, le, d->left);
			list_links(ld, d, lw, w, le->next, d->left, lcost, lindex-lc+delta);
		    }
		    if (lml&&lmr) delta = magic(lw, w, le, d->left, lcost);
		    else delta = 0;
		    lc += delta;
		    if ((lc-delta <=lindex) && lc > lindex) {
			issue_link(ld, d, lw, w, le, d->left);
			list_links(ld, d, lw, w, le, d->left, lcost, lindex-lc+delta);
		    }
		    
		    list_links(d, rd, w, rw, d->right, re, rcost, rindex);
		}
		if ((le == NULL) && (rightcount > 0)) {
		    i = rightcount * magic(lw, w, le, d->left, lcost);
		} else {
		    i = 0;
		}
		total += i;
		if ((total-i <= index) && (total > index)) {
		    x = index-total+i;  /* 0 <= x < i */
		    rindex = x % rightcount;
		    lindex = x / rightcount;
		    
		    rc = 0;
		    delta = magic(w, rw, d->right->next,re->next, rcost);
		    rc += delta;
		    if (rc > rindex) {
			issue_link(d, rd, w, rw, d->right, re);
			list_links(d, rd, w, rw, d->right->next, re->next, rcost, rindex-rc+delta);
		    }
		    if (rml) delta = magic(w, rw, d->right, re->next, rcost);
		    else delta = 0;
		    rc += delta;
		    if ((rc-delta <= rindex) && rc > rindex) {
			issue_link(d, rd, w, rw, d->right, re);
			list_links(d, rd, w, rw, d->right, re->next, rcost, rindex-rc+delta);
		    }
		    if (rmr) delta = magic(w, rw, d->right->next, re, rcost);
		    else delta = 0;
		    rc += delta;
		    if ((rc-delta <= rindex) && rc > rindex) {
			issue_link(d, rd, w, rw, d->right, re);
			list_links(d, rd, w, rw, d->right->next, re, rcost, rindex-rc+delta);
		    }
		    if (rml&&rmr) delta = magic(w, rw, d->right, re, rcost);
		    else delta = 0;
		    rc += delta;
		    if ((rc-delta <= rindex) && rc > rindex) {
			issue_link(d, rd, w, rw, d->right, re);
			list_links(d, rd, w, rw, d->right, re, rcost, rindex-rc+delta);
		    }
		    list_links(ld, d, lw, w, le, d->left, lcost, lindex);
		}
	    }
	}
	put_match_list(m1);
    }
}

void initialize_links(void) {
    int i;
    for (i=0; i<N_words; ++i) {
	chosen_disjuncts[i] = NULL;
    }
}

void extract_links(int index, int cost) {
/* generate the list of all links of the indexth parsing of the sentence */
/* for this to work, the hash table must have already been built with a  */
/* call to count(cost).                                                  */
    
    Disjunct * dis;
    int total, c=0;
    N_links = 0;
    total = 0;

    initialize_links();

    for (dis = sentence[0].d; dis != NULL; dis = dis->next) {
	if (dis->left == NULL) {
	    c = magic(0, N_words, dis->right, NULL, cost);
	    total += c;
	    if (total > index) break;
	}	
    }
    if (total > index) {
	list_links(dis, NULL, 0, N_words, dis->right, NULL, cost, index-total+c);
    } else {
	c = magic(0, N_words, NULL, NULL, cost);
	total += c;
	list_links(NULL, NULL, 0, N_words, NULL, NULL, cost, index-total+c);
    }
}

#endif
