#!/usr/bin/perl
# outputs some stats on an link-grammar output file
# Usage: perl lgout_stats.pl < link-grammar-out.txt

while (<>) {
if ( /^Found (\d+) linkage/ ) { $linkage_sum = $linkage_sum + $1; $linkage_count++;}
if ( /UNUSED=(\d+) / )        { $unused_sum = $unused_sum + $1; $unused_count++;}
if ( /DIS=(\d+) / )           { $dis_sum = $dis_sum + $1; $dis_count++;}
if ( /LEN=(\d+)\)/ )          { $len_sum = $len_sum + $1; $len_count++;}
if ( /(\d+\.\d+) second/ )    { if ($1 > $time_high) { $time_high = $1;}}
if ( /\((\d+\.\d+) total\)/ ) { $time_sum =  $1}

}
print "\nStats on link-grammar output file: $ARGV \n\n";
print "Total sentences  = $linkage_count\n";
print "Total time       = $time_sum seconds\n";
print "Slowest sentence = $time_high seconds\n";
print "Sentence avg     = " . sprintf("%.2f" , ( $time_sum/$linkage_count )) . " seconds (" . sprintf("%.2f" , ( $linkage_count/$time_sum )) . " sentences per second)\n";
print "Linkage avg      = " . sprintf("%.2f" , ( $linkage_sum/$linkage_count )) . "\n";
print "Unused avg       = "   . sprintf("%.2f" , ( $unused_sum/$unused_count )) . "\n";
print "Distance avg     = "   . sprintf("%.2f" , ( $dis_sum/$dis_count )) . "\n";
print "Length avg       = "   . sprintf("%.2f" , ( $len_sum/$len_count )) . "\n\n";

