#!/bin/sh
### Usage: ./arabiclg_pdf.sh < input_file.txt

#export ARABICLG_HOME=/home/tcsh/public_html/arabiclg
export ARABICLG_HOME=../

${ARABICLG_HOME}/bin/aramorph_fast.pl -i roman 2>/dev/null	|	# morphology; assumed romanized input
${ARABICLG_HOME}/bin/buck2lg.sh					|	# some ugly postprocessing to glean morphemes
(echo -e '!width=84\n!max-length=300\n'; cat; echo -e "\n" )	|	# prepends link-grammar width info
link-grammar ${ARABICLG_HOME}/4.0.dict 2>/dev/null		|	# link-grammar parsing
egrep -v 'Opening|width set to|\+Time|RETURN'			|	# eliminates useless lines
#egrep -C 70 --color "UNUSED=[0-9]+|Found [0-9]+ linkages"	|	# highlight number of unused links
enscript -p - -2r						|	# convert from plaintext to postscript
ps2pdf - arabiclg.`date +%F`.pdf					# convert from postscript to pdf
