/* Copyright (c) 2008, AbiSource Corporation B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the AbiSource Corporation B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY AbiSource Corporation B.V. ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTOR BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef _WIN32
#include <windows.h>
#include <winsock.h>
#include <Ws2tcpip.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <shoes.h>

int main(int argc, char* argv[]) {
	if (argc != 5 && argc != 7) {
		fprintf(stderr, "Usage: socks5 <socks host> <socks port> " \
			"<destination host> <destination port> [<username> <password>]\n");
		return -1;
	}

#ifdef _WIN32
	WSADATA wsa_data;
	WSAStartup(MAKEWORD(2,2), &wsa_data);
#endif

	struct addrinfo hints, *addrs, *addr;
	native_socket sock;
	int res;
		
	// connect to the socks server
	memset(&hints, 0, sizeof(struct addrinfo));
	hints.ai_family = AF_INET;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = 0;
	hints.ai_protocol = 0;
	if ((res = getaddrinfo(argv[1], argv[2], &hints, &addrs)) != 0) {
		fprintf(stderr, "Error getting address information: %s\n", 
			gai_strerror(res));
		return -1;
	}
	for (addr = addrs; addr; addr = addr->ai_next) {
		if ((sock = socket(addr->ai_family, addr->ai_socktype, 
				addr->ai_protocol)) == -1)
			continue;
		if (connect(sock, addr->ai_addr, addr->ai_addrlen) != -1)
			break;
	}
	freeaddrinfo(addrs);
	if (addr == NULL) {
		fprintf(stderr, "Failed to connect to SOCKS host '%s:%s'\n", argv[1], 
			argv[2]);
		return -1;
	}

	// request a connection to the given host/port	
	int connected = argc == 5 
			? shoes_socks5_connect(sock, argv[3],
				(unsigned short)atoi(argv[4]))
			: shoes_socks5_connect_username_password(sock, argv[3], 
				(unsigned short)atoi(argv[4]), argv[5], argv[6]);

	if (connected != 0) {
		fprintf(stderr, "Failed to open SOCKS5 connection to '%s:%s'\n",
			argv[3], argv[4]);
		return -1;
	}

	fprintf(stdout, "Connected to '%s:%s'\n", argv[3], argv[4]);

#ifdef _WIN32
	if (closesocket(sock) != 0) {
#else
	if (close(sock) != 0) {
#endif
		perror("Failed to properly close the connection to the SOCKS5 server");
		return -1;
	}

#ifdef _WIN32
	WSACleanup();
#endif
	
	return 0;
}
