/* Copyright (c) 2008, AbiSource Corporation B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the AbiSource Corporation B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY AbiSource Corporation B.V. ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTOR BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <asio.hpp>
#include <shoes++.h>

using namespace asio;

int main(int argc, char* argv[]) {
	if (argc != 5) {
		fprintf(stderr, "Usage: socks4xx <socks host> <socks port> <destination ip> <destination port>\n");
		return -1;
	}
	
	io_service io_service;
	ip::tcp::resolver resolver(io_service);
	
	// connect to the socks server
	ip::tcp::resolver::query socks_host(argv[1], argv[2]);
	ip::tcp::resolver::iterator iterator = resolver.resolve(socks_host);
	ip::tcp::socket socket(io_service);
	try {
		socket.connect(*iterator);
	} catch (asio::system_error& se) {
		fprintf(stderr, "Failed to connect to SOCKS host '%s:%s': %s\n", argv[1], argv[2], se.what());
		return -1;
	}
	
	// request a connection to the given host/port
	ip::tcp::resolver::query dst_host(argv[3], argv[4]);
	try {
		iterator = resolver.resolve(dst_host);
	} catch (asio::system_error& se) {
		fprintf(stderr, "Error resolving the IP of the destination host '%s': %s\n", argv[3], se.what());
		return -1;
	}
	ip::tcp::endpoint socks_endpoint = *iterator;
	ip::address dst_addr = socks_endpoint.address();
	if (!dst_addr.is_v4()) {
		fprintf(stderr, "IPv6 addresses ('%s') are not supported", dst_addr.to_string().c_str());
		return -1;
	}
	
	if (shoes::socks4::connect(socket, dst_addr.to_v4(), atoi(argv[4]), NULL) != 0) {
		fprintf(stderr, "Failed to open SOCKS4 connection to '%s:%s'\n", argv[3], argv[4]);
		return -1;
	}

	fprintf(stdout, "Connected to '%s:%s'\n", argv[3], argv[4]);

	try {
		socket.close();
	} catch (asio::system_error& se) {
		fprintf(stderr, "Failed to properly close the connection to SOCKS server '%s:%s': %s\n", argv[1], argv[2], se.what());
	}
	
	return 0;
}
