/* Copyright (c) 2008, AbiSource Corporation B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the AbiSource Corporation B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY AbiSource Corporation B.V. ''AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTOR BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __SHOES_H__
#define __SHOES_H__

#ifdef _WIN32
#include <winsock2.h>
#endif

#ifdef _WIN32
#ifdef _SHOES_BUILD
#define SHOES_MODULE_EXPORT __declspec(dllexport)
#else
#define SHOES_MODULE_EXPORT __declspec(dllimport)
#endif
#else
#define SHOES_MODULE_EXPORT
#endif

#ifdef _WIN32
typedef SOCKET native_socket;
#else
typedef int native_socket;
#endif

#ifdef __cplusplus
extern "C" {
#endif

SHOES_MODULE_EXPORT
int shoes_socks4_connect(native_socket sock, const char* dst_host,
		unsigned short dst_port, const char* user_id);

SHOES_MODULE_EXPORT
int shoes_socks5_connect(native_socket sock, const char* dst_host,
		unsigned short dst_port);

SHOES_MODULE_EXPORT
int shoes_socks5_connect_username_password(native_socket sock, const char* dst_host,
		unsigned short dst_port, const char* username,
		const char* password);

#ifdef __cplusplus
}
#endif

#endif /* __SHOES_H__ */

