#ifndef lint
static const char yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#endif

#include <stdlib.h>
#include <string.h>

#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYPATCH 20100216

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)


#ifndef yyparse
#define yyparse    itex2MML_yyparse
#endif /* yyparse */

#ifndef yylex
#define yylex      itex2MML_yylex
#endif /* yylex */

#ifndef yyerror
#define yyerror    itex2MML_yyerror
#endif /* yyerror */

#ifndef yychar
#define yychar     itex2MML_yychar
#endif /* yychar */

#ifndef yyval
#define yyval      itex2MML_yyval
#endif /* yyval */

#ifndef yylval
#define yylval     itex2MML_yylval
#endif /* yylval */

#ifndef yydebug
#define yydebug    itex2MML_yydebug
#endif /* yydebug */

#ifndef yynerrs
#define yynerrs    itex2MML_yynerrs
#endif /* yynerrs */

#ifndef yyerrflag
#define yyerrflag  itex2MML_yyerrflag
#endif /* yyerrflag */

#ifndef yylhs
#define yylhs      itex2MML_yylhs
#endif /* yylhs */

#ifndef yylen
#define yylen      itex2MML_yylen
#endif /* yylen */

#ifndef yydefred
#define yydefred   itex2MML_yydefred
#endif /* yydefred */

#ifndef yydgoto
#define yydgoto    itex2MML_yydgoto
#endif /* yydgoto */

#ifndef yysindex
#define yysindex   itex2MML_yysindex
#endif /* yysindex */

#ifndef yyrindex
#define yyrindex   itex2MML_yyrindex
#endif /* yyrindex */

#ifndef yygindex
#define yygindex   itex2MML_yygindex
#endif /* yygindex */

#ifndef yytable
#define yytable    itex2MML_yytable
#endif /* yytable */

#ifndef yycheck
#define yycheck    itex2MML_yycheck
#endif /* yycheck */

#ifndef yyname
#define yyname     itex2MML_yyname
#endif /* yyname */

#ifndef yyrule
#define yyrule     itex2MML_yyrule
#endif /* yyrule */
#define YYPREFIX "itex2MML_yy"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
#ifdef YYPARSE_PARAM_TYPE
#define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
#else
#define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
#endif
#else
#define YYPARSE_DECL() yyparse(void)
#endif /* YYPARSE_PARAM */

extern int YYPARSE_DECL();

#line 6 "itex2MML.y"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "itex2MML.h"

#define YYSTYPE char *
#define YYPARSE_PARAM_TYPE char **
#define YYPARSE_PARAM ret_str

#define yytext itex2MML_yytext

 extern int yylex ();

 extern char * yytext;

 static void itex2MML_default_error (const char * msg)
   {
     if (msg)
       fprintf(stderr, "Line: %d Error: %s\n", itex2MML_lineno, msg);
   }

 void (*itex2MML_error) (const char * msg) = itex2MML_default_error;

 static void yyerror (char * s)
   {
     char * msg = itex2MML_copy3 (s, " at token ", yytext);
     if (itex2MML_error)
       (*itex2MML_error) (msg);
     itex2MML_free_string (msg);
   }

 /* Note: If length is 0, then buffer is treated like a string; otherwise only length bytes are written.
  */
 static void itex2MML_default_write (const char * buffer, unsigned long length)
   {
     if (buffer)
       {
	 if (length)
	   fwrite (buffer, 1, length, stdout);
	 else
	   fputs (buffer, stdout);
       }
   }

 static void itex2MML_default_write_mathml (const char * mathml)
   {
     if (itex2MML_write)
       (*itex2MML_write) (mathml, 0);
   }

#ifdef itex2MML_CAPTURE
    static char * itex2MML_output_string = "" ;

    const char * itex2MML_output ()
    {
        char * copy = (char *) malloc(strlen(itex2MML_output_string) +1);
        if (copy)
          {
           if (itex2MML_output_string)
             {
               strcpy(copy, itex2MML_output_string);
               if (itex2MML_output_string != "")
                   free(itex2MML_output_string);
             }
           else
             copy[0] = 0;
          }
        itex2MML_output_string = "";
        return copy;
    }

 static void itex2MML_capture (const char * buffer, unsigned long length)
    {
     if (buffer)
       {
         if (length)
           {
              unsigned long first_length = itex2MML_output_string ? strlen(itex2MML_output_string) : 0;
              char * copy  = (char *) malloc(first_length + length + 1);
              if (copy)
                {
                  if (itex2MML_output_string)
                    {
                       strcpy(copy, itex2MML_output_string);
                       if (itex2MML_output_string != "")
                          free(itex2MML_output_string);
                    }
                  else
                     copy[0] = 0;
                  strncat(copy, buffer, length);
                 }
              itex2MML_output_string = copy;
            }
         else
            {
              char * copy = itex2MML_copy2(itex2MML_output_string, buffer);
              if (itex2MML_output_string != "")
                 free(itex2MML_output_string);
              itex2MML_output_string = copy;
            }
        }
    }

    static void itex2MML_capture_mathml (const char * buffer)
    {
       char * temp = itex2MML_copy2(itex2MML_output_string, buffer);
       if (itex2MML_output_string != "")
         free(itex2MML_output_string);
       itex2MML_output_string = temp;
    }
    void (*itex2MML_write) (const char * buffer, unsigned long length) = itex2MML_capture;
    void (*itex2MML_write_mathml) (const char * mathml) = itex2MML_capture_mathml;
#else
    void (*itex2MML_write) (const char * buffer, unsigned long length) = itex2MML_default_write;
    void (*itex2MML_write_mathml) (const char * mathml) = itex2MML_default_write_mathml;
#endif 

 char * itex2MML_empty_string = "";

 /* Create a copy of a string, adding space for extra chars
  */
 char * itex2MML_copy_string_extra (const char * str, unsigned extra)
   {
     char * copy = (char *) malloc(extra + (str ? strlen (str) : 0) + 1);
     if (copy)
       {
	 if (str)
	   strcpy(copy, str);
	 else
	   copy[0] = 0;
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string, appending two strings
  */
 char * itex2MML_copy3 (const char * first, const char * second, const char * third)
   {
     int  first_length =  first ? strlen( first) : 0;
     int second_length = second ? strlen(second) : 0;
     int  third_length =  third ? strlen( third) : 0;

     char * copy = (char *) malloc(first_length + second_length + third_length + 1);

     if (copy)
       {
	 if (first)
	   strcpy(copy, first);
	 else
	   copy[0] = 0;

	 if (second) strcat(copy, second);
	 if ( third) strcat(copy,  third);
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string, appending a second string
  */
 char * itex2MML_copy2 (const char * first, const char * second)
   {
     return itex2MML_copy3(first, second, 0);
   }

 /* Create a copy of a string
  */
 char * itex2MML_copy_string (const char * str)
   {
     return itex2MML_copy3(str, 0, 0);
   }

 /* Create a copy of a string, escaping unsafe characters for XML
  */
 char * itex2MML_copy_escaped (const char * str)
   {
     unsigned long length = 0;

     const char * ptr1 = str;

     char * ptr2 = 0;
     char * copy = 0;

     if ( str == 0) return itex2MML_empty_string;
     if (*str == 0) return itex2MML_empty_string;

     while (*ptr1)
       {
	 switch (*ptr1)
	   {
	   case '<':  /* &lt;   */
	   case '>':  /* &gt;   */
	     length += 4;
	     break;
	   case '&':  /* &amp;  */
	     length += 5;
	     break;
	   case '\'': /* &apos; */
	   case '"':  /* &quot; */
	   case '-':  /* &#x2d; */
	     length += 6;
	     break;
	   default:
	     length += 1;
	     break;
	   }
	 ++ptr1;
       }

     copy = (char *) malloc (length + 1);

     if (copy)
       {
	 ptr1 = str;
	 ptr2 = copy;

	 while (*ptr1)
	   {
	     switch (*ptr1)
	       {
	       case '<':
		 strcpy (ptr2, "&lt;");
		 ptr2 += 4;
		 break;
	       case '>':
		 strcpy (ptr2, "&gt;");
		 ptr2 += 4;
		 break;
	       case '&':  /* &amp;  */
		 strcpy (ptr2, "&amp;");
		 ptr2 += 5;
		 break;
	       case '\'': /* &apos; */
		 strcpy (ptr2, "&apos;");
		 ptr2 += 6;
		 break;
	       case '"':  /* &quot; */
		 strcpy (ptr2, "&quot;");
		 ptr2 += 6;
		 break;
	       case '-':  /* &#x2d; */
		 strcpy (ptr2, "&#x2d;");
		 ptr2 += 6;
		 break;
	       default:
		 *ptr2++ = *ptr1;
		 break;
	       }
	     ++ptr1;
	   }
	 *ptr2 = 0;
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a hex character reference string corresponding to code
  */
 char * itex2MML_character_reference (unsigned long int code)
   {
#define ENTITY_LENGTH 10
     char * entity = (char *) malloc(ENTITY_LENGTH);
     sprintf(entity, "&#x%05x;", code);
     return entity;
   }

 void itex2MML_free_string (char * str)
   {
     if (str && str != itex2MML_empty_string)
       free(str);
   }

#line 386 "y.tab.c"
#define TEXOVER 257
#define TEXATOP 258
#define CHAR 259
#define STARTMATH 260
#define STARTDMATH 261
#define ENDMATH 262
#define MI 263
#define MIB 264
#define MN 265
#define MO 266
#define SUP 267
#define SUB 268
#define MROWOPEN 269
#define MROWCLOSE 270
#define LEFT 271
#define RIGHT 272
#define BIG 273
#define BBIG 274
#define BIGG 275
#define BBIGG 276
#define BIGL 277
#define BBIGL 278
#define BIGGL 279
#define BBIGGL 280
#define FRAC 281
#define TFRAC 282
#define MATHOP 283
#define MOP 284
#define MOL 285
#define MOLL 286
#define MOF 287
#define PERIODDELIM 288
#define OTHERDELIM 289
#define LEFTDELIM 290
#define RIGHTDELIM 291
#define MOS 292
#define MOB 293
#define SQRT 294
#define ROOT 295
#define BINOM 296
#define UNDER 297
#define OVER 298
#define OVERBRACE 299
#define UNDERBRACE 300
#define UNDEROVER 301
#define TENSOR 302
#define MULTI 303
#define ARRAY 304
#define COLSEP 305
#define ROWSEP 306
#define ARRAYOPTS 307
#define COLLAYOUT 308
#define COLALIGN 309
#define ROWALIGN 310
#define ALIGN 311
#define EQROWS 312
#define EQCOLS 313
#define ROWLINES 314
#define COLLINES 315
#define FRAME 316
#define PADDING 317
#define ATTRLIST 318
#define ITALICS 319
#define BOLD 320
#define SLASHED 321
#define RM 322
#define BB 323
#define ST 324
#define END 325
#define BBLOWERCHAR 326
#define BBUPPERCHAR 327
#define BBDIGIT 328
#define CALCHAR 329
#define FRAKCHAR 330
#define CAL 331
#define FRAK 332
#define ROWOPTS 333
#define TEXTSIZE 334
#define SCSIZE 335
#define SCSCSIZE 336
#define DISPLAY 337
#define TEXTSTY 338
#define TEXTBOX 339
#define TEXTSTRING 340
#define XMLSTRING 341
#define CELLOPTS 342
#define ROWSPAN 343
#define COLSPAN 344
#define THINSPACE 345
#define MEDSPACE 346
#define THICKSPACE 347
#define QUAD 348
#define QQUAD 349
#define NEGSPACE 350
#define PHANTOM 351
#define HREF 352
#define UNKNOWNCHAR 353
#define EMPTYMROW 354
#define STATLINE 355
#define TOGGLE 356
#define FGHIGHLIGHT 357
#define BGHIGHLIGHT 358
#define SPACE 359
#define INTONE 360
#define INTTWO 361
#define INTTHREE 362
#define BAR 363
#define WIDEBAR 364
#define VEC 365
#define WIDEVEC 366
#define HAT 367
#define WIDEHAT 368
#define CHECK 369
#define WIDECHECK 370
#define TILDE 371
#define WIDETILDE 372
#define DOT 373
#define DDOT 374
#define UNARYMINUS 375
#define UNARYPLUS 376
#define BEGINENV 377
#define ENDENV 378
#define MATRIX 379
#define PMATRIX 380
#define BMATRIX 381
#define BBMATRIX 382
#define VMATRIX 383
#define VVMATRIX 384
#define SVG 385
#define ENDSVG 386
#define SMALLMATRIX 387
#define CASES 388
#define ALIGNED 389
#define GATHERED 390
#define SUBSTACK 391
#define PMOD 392
#define RMCHAR 393
#define COLOR 394
#define BGCOLOR 395
#define YYERRCODE 256
static const short itex2MML_yylhs[] = {                  -1,
    0,    1,    1,    1,    1,    1,    2,    3,    3,    3,
    3,    4,    4,    5,    5,    5,    5,    5,    5,    5,
    5,    5,    5,    5,    5,    5,    5,    5,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,    7,    7,    7,    7,    7,    7,    7,    7,    7,
    7,   64,   64,   64,   65,   65,   65,   70,   70,   70,
   70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
   70,   70,   70,   70,   70,   70,   70,   69,   10,   11,
   12,    8,   13,    6,   14,   14,   14,   14,   14,   14,
   14,   14,   14,   14,   14,   14,   14,   33,   47,   57,
   58,   59,   60,   61,   61,   48,   34,   35,   36,   37,
   38,   39,   45,   40,   41,   42,   42,   43,   71,   71,
   72,   72,   72,   44,   73,   73,   74,   46,   75,   75,
   76,   49,   50,   51,   52,   53,   54,   55,   56,   15,
   15,   16,   16,   16,   77,   77,   78,   78,   78,   78,
   17,   17,   68,   62,   62,   63,   63,   18,   31,   30,
   23,   23,   24,   24,   26,   27,   29,   29,   28,   28,
   25,   25,   19,   20,   21,   22,   32,   66,   66,   66,
   66,   66,   66,   66,   66,   66,   66,   66,   66,   67,
    9,    9,   80,   80,   81,   81,   81,   81,   81,   81,
   81,   81,   81,   81,   82,   83,   84,   85,   86,   87,
   88,   89,   90,   91,   79,   79,   92,   92,   93,   93,
   94,   96,   96,   97,   97,   95,   95,   95,   98,   98,
   99,   99,   99,   99,  100,  101,
};
static const short itex2MML_yylen[] = {                   2,
    1,    0,    1,    1,    2,    2,    1,    2,    2,    3,
    3,    1,    2,    5,    3,    5,    3,    5,    3,    5,
    3,    5,    5,    3,    3,    2,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    3,    3,    3,    1,    1,    1,
    1,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    2,    1,   10,    3,
    3,    3,    3,    3,    3,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    4,    1,    2,    4,    1,    2,
    1,    1,    1,    4,    1,    2,    1,    4,    1,    2,
    1,    1,    1,    1,    1,    1,    1,    2,    3,    5,
    3,    8,    6,    6,    1,    2,    4,    2,    2,    3,
    3,    3,    2,    5,    5,    5,    5,    3,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    3,    3,    3,    4,    5,    5,    5,
    5,    5,    5,    5,    5,    5,    5,    4,    3,    4,
    4,    8,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    2,    1,    3,    1,    1,    1,    3,
    5,    1,    2,    1,    1,    0,    1,    5,    1,    2,
    1,    1,    1,    1,    2,    2,
};
static const short itex2MML_yydefred[] = {                0,
    7,    0,    0,    0,    0,    3,    4,    8,  121,  122,
  123,  127,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  136,  128,  129,
  133,  134,  132,  131,  130,  135,  124,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  172,  173,  174,  175,  176,  177,    0,    0,  118,
  138,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  119,  120,
    0,    0,    0,  156,    0,    0,    0,   12,    0,    0,
    0,   29,   30,   31,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,
   59,   60,   61,   62,    0,   64,   65,   66,   67,   68,
   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
   79,   80,   81,   82,   83,   84,    0,   88,   89,   90,
   91,  126,    9,    0,    5,    6,  125,   27,   32,   26,
    0,    0,   94,   93,   92,  100,   98,   99,  103,  101,
  102,  106,  104,  105,  109,  107,  108,  111,  110,  113,
  112,  115,  114,  117,  116,    0,    0,  137,  213,    0,
    0,    0,    0,  200,  199,    0,    0,    0,    0,    0,
  152,  154,  153,    0,    0,    0,    0,  149,  150,  151,
  147,  148,  146,  178,    0,    0,    0,    0,    0,    0,
  201,  202,  203,  204,  211,  212,  209,  210,  207,  208,
  205,  206,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  193,    0,    0,   10,   13,    0,
    0,    0,    0,    0,    0,  157,    0,   11,    0,    0,
   86,   85,  191,  192,  214,  198,  215,  216,    0,    0,
    0,    0,    0,  185,    0,    0,    0,    0,    0,    0,
    0,  255,    0,  258,  259,    0,  161,  162,  163,    0,
  159,  171,    0,  169,  167,    0,  165,  179,  140,  141,
  142,  143,    0,    0,    0,    0,    0,    0,    0,    0,
  229,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   87,    0,    0,
  217,  189,    0,    0,    0,  186,    0,    0,    0,    0,
    0,  231,    0,    0,  155,  158,  160,  168,  170,  164,
  166,    0,    0,    0,    0,    0,    0,    0,  228,    0,
    0,    0,    0,  230,    0,    0,    0,    0,    0,    0,
    0,    0,   97,   96,   95,  194,  196,  190,    0,  180,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  233,  235,  236,  237,  238,  239,  240,
  241,  242,  243,  244,  264,  265,    0,  262,    0,    0,
  271,  272,    0,  269,  273,  274,  256,  260,    0,  218,
  220,  221,  223,  222,  224,  225,  226,  227,  219,   16,
   14,   23,   22,   20,   18,  195,  197,  187,    0,  183,
  184,  245,  246,  247,  248,  249,  250,  251,  252,  253,
  254,    0,  234,    0,  263,  275,  276,    0,  270,    0,
    0,    0,    0,    0,    0,  182,  232,    0,    0,  139,
};
static const short itex2MML_yydgoto[] = {                 4,
    5,    6,    7,  290,   98,  167,  100,  169,  102,  103,
  104,  105,  106,  107,  108,  109,  110,  111,  112,  113,
  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,
  124,  125,  126,  127,  128,  129,  130,  131,  132,  133,
  134,  135,  136,  137,  138,  139,  140,  141,  142,  143,
  144,  145,  146,  147,  148,  149,  150,  151,  152,  153,
  154,  155,  156,  157,  338,  158,  159,  160,  161,  162,
  300,  301,  306,  307,  303,  304,  283,  284,  291,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,  413,
  414,  292,  293,  294,  295,  417,  418,  423,  424,  425,
  426,
};
static const short itex2MML_yysindex[] = {             -175,
    0, 2676, 2810,    0, -175,    0,    0,    0,    0,    0,
    0,    0, 4275, 4275, 4009, -117,  -68,  -62,  -59,  -56,
  -65,  -53,  -50,    1, 4275, 4275, -263,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 4275, 4275, 4275,
 4275, 4275, 4275, 4275, 4275, 4275, -240, -179, 4275, 4275,
 4275, -224, -221, -216, -195, 4275, 4275, 4275, 4275, 4275,
 -203,    0,    0,    0,    0,    0,    0, 4275, -197,    0,
    0, -193, 4275, -173, -157, -140, 4275, 4275, 4275, 4275,
 4275, 4275, 4275, 4275, 4275, 4275, 4275, 4275,    0,    0,
 -231, -147, 4275,    0, -132, -123, 2944,    0,   25,   34,
   36,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -191,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 4009,    0,    0,    0,
    0,    0,    0, 3078,    0,    0,    0,    0,    0,    0,
 2264, -171,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 4275, 4275,    0,    0, 4275,
 4275, 4275, 4275,    0,    0, 4275,   -8,   38, 4275, 3211,
    0,    0,    0, -187,  -64, -205, -111,    0,    0,    0,
    0,    0,    0,    0, 4275, 4275, 4275, 4275, 4275, -107,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3344, 3344, 3344, 3344, 3344, 3344, -288, 3344,
 3344, 3344, 3344, 3344,    0, 4009, 4009,    0,    0, 4275,
 4275, 4275, 4275, 4275, 4275,    0, 2403,    0, 4009, 4009,
    0,    0,    0,    0,    0,    0,    0,    0, 4275, 4275,
 4142,   38,   38,    0, -100,  -71,  -13,   -3,    8, 4009,
 -200,    0,  -22,    0,    0, -304,    0,    0,    0, -162,
    0,    0, -246,    0,    0, -252,    0,    0,    0,    0,
    0,    0,  -36, -303, -287, -271, -269, -260, -257,  -92,
    0, -247, -243, -239, -238, -196, 4009, 4009,   39,   29,
   42,   46,   49,   47, 4009, 4009,  -95,    0, 3477, 3610,
    0,    0, 4275,   52,  -79,    0, 4275,   38,  -99,   -1,
 -217,    0, 3344, 3743,    0,    0,    0,    0,    0,    0,
    0,   -4,  -58,  -57,  -54,  -60,  -55,  -52,    0,  -51,
  -49,  -48,  -61,    0, 4275, 4275, 4275, 4275, 4275, 4275,
 3876, 3876,    0,    0,    0,    0,    0,    0, 4275,    0,
 -235,  -67,    6,   12,   13,   17,   22,   24,   26,   27,
   31,   32, -134,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -168,    0,   35,   40,
    0,    0, -228,    0,    0,    0,    0,    0,  -18,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   38,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3344,    0, 3743,    0,    0,    0, 4009,    0,   21,
  -63, -194,  -22, 4009,   23,    0,    0,  -14,   37,    0,
};
static const short itex2MML_yyrindex[] = {              354,
    0,    0,    0,    0,  357,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1708, 1847,
 1986,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  596,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2542,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -201,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -258, -258, -258, -258, -258, -258,    0, -258,
 -258, -258, -258, -201,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 2125,    0,    0,    0,    0,    0,    0, -250,
    0,    0, -265,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -234, -218,  735,  874,
 1013, 1152, 1291, 1430,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1569,    0,    0,    0,    0,    0,    0,
    0,    0, -248, -248,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -201,    0, -248,    0,    0,    0,    0,    0,    0,
    0,    0, -244, -245,    0,    0,    0,    0,    0,    0,
};
static const short itex2MML_yygindex[] = {                0,
    0,  355,  356,   30,  -70,   -2,  468,   28,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  145,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  -66,    0,    0,    0,    0,    0,
    0,   69,    0,   64,    0,   68, -202, -281, -236,    0,
  -31,    0, -300, -285,    0,    0,    0,    0,    0,    0,
    0,   20,  -90,    0,   33,    0,  -42,    0,  -47,    0,
    0,
};
#define YYTABLESIZE 4670
static const short itex2MML_yytable[] = {                99,
   99,  346,  353,  346,  257,  285,  314,  315,  316,  317,
  318,  319,   99,  322,  323,  324,  325,  326,  353,  267,
  355,  266,  144,  144,  268,  261,  259,  144,  208,  101,
  101,   97,  164,  449,  353,  144,  353,  144,  145,  145,
  257,  468,  101,  145,  171,  353,  266,  266,  353,  415,
  421,  145,  320,  145,  267,  267,  266,  266,  353,  268,
  268,  261,  353,  346,  416,  422,  353,  353,  266,  352,
  144,  144,  360,  374,  363,  477,  198,  305,  358,  345,
  394,  395,  302,    1,    2,    3,  145,  145,  266,  210,
  364,  394,  395,  259,   99,  262,  263,  321,  272,  214,
  259,  464,  215,  266,  266,  353,  365,  216,  366,  353,
  346,  353,  257,  209,  419,  420,  415,  367,  450,  266,
  368,  254,  421,  302,  101,  419,  420,  267,  217,  266,
  370,  416,  268,  261,  371,  462,  223,  422,  372,  373,
  394,  395,  225,  144,  228,  392,  226,  243,  244,  245,
  246,  247,  248,  249,   99,  250,  251,  252,  253,  145,
  229,   99,  356,  297,  298,  299,  280,  281,   99,  347,
  173,  174,  175,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  230,  101,  256,  267,  280,  281,  346,
  390,  101,  383,  384,  257,  385,  259,  348,  101,  280,
  281,  266,  451,  280,  281,   94,  476,   99,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  305,  259,
  176,  177,  178,  188,  189,  472,  179,  180,  181,  182,
  183,  184,  185,  186,  187,  190,  191,  101,  192,  193,
   99,   99,   99,   99,   99,   99,  471,   99,   99,   99,
   99,   99,  313,   99,   99,  349,  259,  259,  280,  281,
  282,  297,  298,  299,   99,  350,   99,   99,  259,  259,
  101,  101,  101,  101,  101,  101,  351,  101,  101,  101,
  101,  101,  354,  101,  101,  327,  328,   99,  362,  194,
  195,  260,  261,  369,  101,  376,  101,  101,  339,  340,
  262,  263,  264,  265,  280,  281,  375,  394,  395,  377,
  259,  259,  378,  380,  446,  447,  379,  101,  389,  429,
  430,  433,  431,  452,   99,   99,  432,  434,  439,  453,
  454,  435,   99,   99,  455,  436,   99,   99,  437,  456,
  438,  457,  470,  458,  459,  475,  478,  479,  460,  461,
   99,   99,  466,    2,  101,  101,    1,  467,  296,  165,
  166,  480,  101,  101,  381,  382,  101,  101,  357,  361,
  359,  463,  427,  473,  465,  469,    0,    0,   99,   99,
  101,  101,    0,    0,    0,    0,  428,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  259,    0,    0,    0,    0,  101,  101,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   99,
    0,   99,    0,    0,    0,   99,    0,    0,    0,    0,
    0,   99,    0,    0,    0,    0,    0,    0,    0,    0,
  168,  170,  172,    0,    0,    0,    0,    0,    0,  101,
    0,  101,  196,  197,    0,  101,    0,  474,    0,    0,
    0,  101,    0,    0,    0,  199,  200,  201,  202,  203,
  204,  205,  206,  207,    0,    0,  211,  212,  213,    0,
    0,    0,    0,  218,  219,  220,  221,  222,    0,    0,
    0,    0,    0,    0,    0,  224,    0,    0,    0,    0,
  227,    0,    0,    0,  231,  232,  233,  234,  235,  236,
  237,  238,  239,  240,  241,  242,    0,    0,    0,    0,
  255,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  273,  274,    0,    0,  275,  276,  277,
  278,    0,    0,  279,    0,    0,  286,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  308,  309,  310,  311,  312,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  329,  330,  331,
  332,  333,  334,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  341,  342,  344,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  388,    0,    0,    0,  391,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  440,  441,  442,  443,  444,  445,    0,    0,
    0,    0,   63,   63,    0,    0,  448,   63,   63,   63,
   63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
   63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
   63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
   63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
   63,   63,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   63,   63,   63,   63,   63,    0,
    0,    0,    0,    0,    0,    0,   63,   63,    0,   63,
   63,   63,   63,   63,   63,    0,    0,    0,    0,    0,
   63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
   63,   63,   63,   63,   63,    0,    0,    0,   63,   63,
   63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
   63,   63,   63,   63,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   63,   63,    0,   63,
   63,   17,   17,    0,    0,    0,   17,   17,   17,   17,
   17,   17,    0,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   17,   17,   17,   17,   17,    0,    0,
    0,    0,    0,    0,    0,   17,   17,    0,   17,   17,
   17,   17,   17,   17,    0,    0,    0,    0,    0,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,    0,    0,    0,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   17,   17,   17,   17,   17,
   15,   15,    0,    0,    0,   15,   15,   15,   15,   15,
    0,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   15,   15,   15,   15,   15,    0,    0,    0,
    0,    0,    0,    0,   15,   15,    0,   15,   15,   15,
   15,   15,   15,    0,    0,    0,    0,    0,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,   15,    0,    0,    0,   15,   15,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   15,
   15,   15,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   15,   15,   15,   15,   15,   25,
   25,    0,    0,    0,   25,   25,   25,   25,   25,   25,
    0,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   25,   25,   25,   25,   25,    0,    0,    0,    0,
    0,    0,    0,   25,   25,    0,   25,   25,   25,   25,
   25,   25,    0,    0,    0,    0,    0,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,   25,    0,    0,    0,   25,   25,   25,   25,   25,
   25,   25,   25,   25,   25,   25,   25,   25,   25,   25,
   25,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   25,   25,   25,   25,   25,   24,   24,
    0,    0,    0,   24,   24,   24,   24,   24,    0,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   24,   24,   24,   24,   24,    0,    0,    0,    0,    0,
    0,    0,   24,   24,    0,   24,   24,   24,   24,   24,
   24,    0,    0,    0,    0,    0,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
   24,    0,    0,    0,   24,   24,   24,   24,   24,   24,
   24,   24,   24,   24,   24,   24,   24,   24,   24,   24,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   24,   24,   24,   24,   24,   21,   21,    0,
    0,    0,   21,   21,   21,   21,   21,   21,    0,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   21,
   21,   21,   21,   21,    0,    0,    0,    0,    0,    0,
    0,   21,   21,    0,   21,   21,   21,   21,   21,   21,
    0,    0,    0,    0,    0,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
    0,    0,    0,   21,   21,   21,   21,   21,   21,   21,
   21,   21,   21,   21,   21,   21,   21,   21,   21,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   21,   21,   21,   21,   21,   19,   19,    0,    0,
    0,   19,   19,   19,   19,   19,    0,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   19,   19,
   19,   19,   19,    0,    0,    0,    0,    0,    0,    0,
   19,   19,    0,   19,   19,   19,   19,   19,   19,    0,
    0,    0,    0,    0,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,   19,    0,
    0,    0,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   19,   19,   19,   19,   19,   19,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   19,   19,   19,   19,   19,  188,  188,    0,    0,    0,
  188,  188,  188,  188,  188,    0,  188,  188,  188,  188,
  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
  188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
  188,  188,  188,  188,  188,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  188,  188,  188,
  188,  188,    0,    0,    0,    0,    0,    0,    0,  188,
  188,    0,  188,  188,  188,  188,  188,  188,    0,    0,
    0,    0,    0,  188,  188,  188,  188,  188,  188,  188,
  188,  188,  188,  188,  188,  188,  188,  188,    0,    0,
    0,  188,  188,  188,  188,  188,  188,  188,  188,  188,
  188,  188,  188,  188,  188,  188,  188,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  188,
  188,  188,  188,  188,  125,  125,    0,    0,    0,  125,
  125,  125,  125,  125,    0,    0,  125,  125,  125,  125,
  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
  125,  125,  125,  125,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  125,  125,  125,  125,
  125,    0,    0,    0,    0,    0,    0,    0,  125,  125,
    0,  125,  125,  125,  125,  125,  125,    0,    0,    0,
    0,    0,  125,  125,  125,  125,  125,  125,  125,  125,
  125,  125,  125,  125,  125,  125,  125,    0,    0,    0,
  125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
  125,  125,  125,  125,  125,  125,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  125,  125,
  125,  125,  125,   28,   28,    0,    0,    0,   28,   28,
   28,   28,   28,    0,    0,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   28,   28,   28,   28,   28,
    0,    0,    0,    0,    0,    0,    0,   28,   28,    0,
   28,   28,   28,   28,   28,   28,    0,    0,    0,    0,
    0,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,    0,    0,    0,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   28,   28,   28,
   28,   28,   32,   32,    0,    0,    0,   32,   32,   32,
   32,   32,    0,    0,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   32,   32,   32,   32,   32,    0,
    0,    0,    0,    0,    0,    0,   32,   32,    0,   32,
   32,   32,   32,   32,   32,    0,    0,    0,    0,    0,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,   32,    0,    0,    0,   32,   32,
   32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
   32,   32,   32,   32,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   32,   32,   32,   32,
   32,  181,  181,    0,    0,    0,  181,  181,  181,  181,
  181,    0,    0,  181,  181,  181,  181,  181,  181,  181,
  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
  181,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  181,  181,  181,  181,  181,    0,    0,
    0,    0,    0,    0,    0,  181,  181,    0,  181,  181,
  181,  181,  181,  181,    0,    0,    0,    0,    0,  181,
  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
  181,  181,  181,  181,    0,    0,    0,  181,  181,  181,
  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
  181,  181,  181,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  181,  181,  181,  181,  181,
  269,  270,    0,    0,    0,    0,    9,   10,   11,   12,
   13,   14,   15,  271,   16,    0,   17,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
   41,   42,   43,   44,   45,   46,   47,   48,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   49,   50,   51,   52,   53,    0,    0,    0,
    0,    0,    0,    0,   54,   55,    0,   56,   57,   58,
   59,   60,   61,    0,    0,    0,    0,    0,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
   74,   75,   76,    0,    0,    0,   77,   78,   79,   80,
   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
   91,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,   95,   96,  335,
  336,    0,    0,    0,    0,    9,   10,   11,   12,   13,
   14,   15,    0,   16,  337,   17,   18,   19,   20,   21,
   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
   42,   43,   44,   45,   46,   47,   48,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   49,   50,   51,   52,   53,    0,    0,    0,    0,
    0,    0,    0,   54,   55,    0,   56,   57,   58,   59,
   60,   61,    0,    0,    0,    0,    0,   62,   63,   64,
   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
   75,   76,    0,    0,    0,   77,   78,   79,   80,   81,
   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   92,   93,   94,   95,   96,   28,   28,
    0,    0,    0,    0,   28,   28,   28,   28,    0,    0,
   28,    0,   28,    0,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   28,   28,   28,   28,   28,    0,    0,    0,    0,    0,
    0,    0,   28,   28,    0,   28,   28,   28,   28,   28,
   28,    0,    0,    0,    0,    0,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,   28,
   28,    0,    0,    0,   28,   28,   28,   28,   28,   28,
   28,   28,   28,   28,   28,   28,   28,   28,   28,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   28,   28,   28,   28,   28,    8,    9,   10,
   11,   12,   13,   14,   15,    0,   16,    0,   17,   18,
   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   49,   50,   51,   52,   53,    0,
    0,    0,    0,    0,    0,    0,   54,   55,    0,   56,
   57,   58,   59,   60,   61,    0,    0,    0,    0,    0,
   62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
   72,   73,   74,   75,   76,    0,    0,    0,   77,   78,
   79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
   89,   90,   91,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,   95,
   96,  163,    9,   10,   11,   12,   13,   14,   15,    0,
   16,    0,   17,   18,   19,   20,   21,   22,   23,   24,
   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
   45,   46,   47,   48,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   49,   50,
   51,   52,   53,    0,    0,    0,    0,    0,    0,    0,
   54,   55,    0,   56,   57,   58,   59,   60,   61,    0,
    0,    0,    0,    0,   62,   63,   64,   65,   66,   67,
   68,   69,   70,   71,   72,   73,   74,   75,   76,    0,
    0,    0,   77,   78,   79,   80,   81,   82,   83,   84,
   85,   86,   87,   88,   89,   90,   91,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,   95,   96,  258,    9,   10,   11,   12,
   13,   14,   15,    0,   16,    0,   17,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
   41,   42,   43,   44,   45,   46,   47,   48,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   49,   50,   51,   52,   53,    0,    0,    0,
    0,    0,    0,    0,   54,   55,    0,   56,   57,   58,
   59,   60,   61,    0,    0,    0,    0,    0,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
   74,   75,   76,    0,    0,    0,   77,   78,   79,   80,
   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
   91,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,   95,   96,  268,
    9,   10,   11,   12,   13,   14,   15,    0,   16,    0,
   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,
   27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
   47,   48,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   49,   50,   51,   52,
   53,    0,    0,    0,    0,    0,    0,    0,   54,   55,
    0,   56,   57,   58,   59,   60,   61,    0,    0,    0,
    0,    0,   62,   63,   64,   65,   66,   67,   68,   69,
   70,   71,   72,   73,   74,   75,   76,    0,    0,    0,
   77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
   87,   88,   89,   90,   91,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   92,   93,
   94,   95,   96,    9,   10,   11,   12,   13,   14,   15,
    0,   16,    0,   17,   18,   19,   20,   21,   22,   23,
   24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
   44,   45,   46,   47,   48,    0,    0,  287,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   49,
   50,   51,   52,   53,    0,    0,    0,    0,    0,    0,
    0,   54,   55,  288,   56,   57,   58,   59,   60,   61,
    0,    0,  289,    0,    0,   62,   63,   64,   65,   66,
   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
    0,    0,    0,   77,   78,   79,   80,   81,   82,   83,
   84,   85,   86,   87,   88,   89,   90,   91,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   92,   93,   94,   95,   96,    9,   10,   11,   12,
   13,   14,   15,    0,   16,    0,   17,   18,   19,   20,
   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,
   31,   32,   33,   34,   35,   36,   37,   38,   39,   40,
   41,   42,   43,   44,   45,   46,   47,   48,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   49,   50,   51,   52,   53,    0,    0,    0,
    0,    0,    0,    0,   54,   55,  288,   56,   57,   58,
   59,   60,   61,    0,    0,  289,    0,    0,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
   74,   75,   76,    0,    0,    0,   77,   78,   79,   80,
   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
   91,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   92,   93,   94,   95,   96,    9,
   10,   11,   12,   13,   14,   15,  386,   16,    0,   17,
   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,
   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   49,   50,   51,   52,   53,
    0,    0,    0,    0,    0,    0,    0,   54,   55,    0,
   56,   57,   58,   59,   60,   61,    0,    0,    0,    0,
    0,   62,   63,   64,   65,   66,   67,   68,   69,   70,
   71,   72,   73,   74,   75,   76,    0,    0,    0,   77,
   78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
   88,   89,   90,   91,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   92,   93,   94,
   95,   96,    9,   10,   11,   12,   13,   14,   15,  387,
   16,    0,   17,   18,   19,   20,   21,   22,   23,   24,
   25,   26,   27,   28,   29,   30,   31,   32,   33,   34,
   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
   45,   46,   47,   48,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   49,   50,
   51,   52,   53,    0,    0,    0,    0,    0,    0,    0,
   54,   55,    0,   56,   57,   58,   59,   60,   61,    0,
    0,    0,    0,    0,   62,   63,   64,   65,   66,   67,
   68,   69,   70,   71,   72,   73,   74,   75,   76,    0,
    0,    0,   77,   78,   79,   80,   81,   82,   83,   84,
   85,   86,   87,   88,   89,   90,   91,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   92,   93,   94,   95,   96,    9,   10,   11,   12,   13,
   14,   15,    0,   16,    0,   17,   18,   19,   20,   21,
   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
   42,   43,   44,   45,   46,   47,   48,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   49,   50,   51,   52,   53,    0,    0,    0,    0,
    0,    0,    0,   54,   55,    0,   56,   57,   58,   59,
   60,   61,    0,    0,  289,    0,    0,   62,   63,   64,
   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
   75,   76,    0,    0,    0,   77,   78,   79,   80,   81,
   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   92,   93,   94,   95,   96,    9,   10,
   11,   12,   13,   14,   15,    0,   16,  337,   17,   18,
   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,
   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   49,   50,   51,   52,   53,    0,
    0,    0,    0,    0,    0,    0,   54,   55,    0,   56,
   57,   58,   59,   60,   61,    0,    0,    0,    0,    0,
   62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
   72,   73,   74,   75,   76,    0,    0,    0,   77,   78,
   79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
   89,   90,   91,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   92,   93,   94,   95,
   96,    9,   10,   11,   12,   13,   14,   15,    0,   16,
    0,   17,   18,   19,   20,   21,   22,   23,   24,   25,
   26,   27,   28,   29,   30,   31,   32,   33,   34,   35,
   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,
   46,   47,   48,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   49,   50,   51,
   52,   53,    0,    0,    0,    0,    0,    0,    0,   54,
   55,    0,   56,   57,   58,   59,   60,   61,    0,    0,
    0,    0,    0,   62,   63,   64,   65,   66,   67,   68,
   69,   70,   71,   72,   73,   74,   75,   76,    0,    0,
    0,   77,   78,   79,   80,   81,   82,   83,   84,   85,
   86,   87,   88,   89,   90,   91,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   92,
   93,   94,   95,   96,    9,   10,   11,   12,  343,    0,
   15,    0,   16,    0,   17,   18,   19,   20,   21,   22,
   23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   47,   48,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   49,   50,   51,   52,   53,    0,    0,    0,    0,    0,
    0,    0,   54,   55,    0,   56,   57,   58,   59,   60,
   61,    0,    0,    0,    0,    0,   62,   63,   64,   65,
   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
   76,    0,    0,    0,   77,   78,   79,   80,   81,   82,
   83,   84,   85,   86,   87,   88,   89,   90,   91,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   92,   93,   94,   95,   96,    9,   10,   11,
   12,    0,    0,   15,    0,   16,    0,   17,   18,   19,
   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
   30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
   40,   41,   42,   43,   44,   45,   46,   47,   48,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   49,   50,   51,   52,   53,    0,    0,
    0,    0,    0,    0,    0,   54,   55,    0,   56,   57,
   58,   59,   60,   61,    0,    0,    0,    0,    0,   62,
   63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
   73,   74,   75,   76,    0,    0,    0,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
   90,   91,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   92,   93,   94,   95,   96,
};
static const short itex2MML_yycheck[] = {                 2,
    3,  283,  306,  285,  270,  208,  243,  244,  245,  246,
  247,  248,   15,  250,  251,  252,  253,  254,  306,  270,
  325,  270,  257,  258,  270,  270,   97,  262,  269,    2,
    3,    2,    3,  269,  306,  270,  306,  272,  257,  258,
  306,  270,   15,  262,   15,  306,  305,  306,  306,  350,
  351,  270,  341,  272,  305,  306,  305,  306,  306,  305,
  306,  306,  306,  345,  350,  351,  306,  306,  270,  270,
  305,  306,  325,  270,  378,  270,  340,  330,  325,  282,
  309,  310,  329,  259,  260,  261,  305,  306,  393,  269,
  378,  309,  310,  164,   97,  267,  268,  386,  270,  324,
  171,  270,  324,  305,  306,  306,  378,  324,  378,  306,
  392,  306,  378,  354,  343,  344,  417,  378,  354,  378,
  378,  269,  423,  329,   97,  343,  344,  378,  324,  378,
  378,  417,  378,  378,  378,  270,  340,  423,  378,  378,
  309,  310,  340,  378,  318,  348,  340,  379,  380,  381,
  382,  383,  384,  385,  157,  387,  388,  389,  390,  378,
  318,  164,  325,  326,  327,  328,  267,  268,  171,  270,
  288,  289,  290,  308,  309,  310,  311,  312,  313,  314,
  315,  316,  317,  324,  157,  318,  157,  267,  268,  471,
  270,  164,  288,  289,  318,  291,  267,  269,  171,  267,
  268,  393,  270,  267,  268,  393,  270,  210,  308,  309,
  310,  311,  312,  313,  314,  315,  316,  317,  330,  290,
  289,  290,  291,  289,  290,  462,  289,  290,  291,  289,
  290,  291,  289,  290,  291,  289,  290,  210,  289,  290,
  243,  244,  245,  246,  247,  248,  449,  250,  251,  252,
  253,  254,  360,  256,  257,  269,  327,  328,  267,  268,
  269,  326,  327,  328,  267,  269,  269,  270,  339,  340,
  243,  244,  245,  246,  247,  248,  269,  250,  251,  252,
  253,  254,  305,  256,  257,  256,  257,  290,  325,  289,
  290,  267,  268,  386,  267,  267,  269,  270,  269,  270,
  267,  268,  267,  268,  267,  268,  268,  309,  310,  268,
  381,  382,  267,  267,  381,  382,  268,  290,  267,  324,
  379,  382,  380,  318,  327,  328,  381,  383,  390,  318,
  318,  384,  335,  336,  318,  387,  339,  340,  388,  318,
  389,  318,  361,  318,  318,  325,  324,  362,  318,  318,
  353,  354,  318,    0,  327,  328,    0,  318,  214,    5,
    5,  325,  335,  336,  335,  336,  339,  340,  300,  306,
  303,  403,  353,  464,  417,  423,   -1,   -1,  381,  382,
  353,  354,   -1,   -1,   -1,   -1,  354,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  474,   -1,   -1,   -1,   -1,  381,  382,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  462,
   -1,  464,   -1,   -1,   -1,  468,   -1,   -1,   -1,   -1,
   -1,  474,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   13,   14,   15,   -1,   -1,   -1,   -1,   -1,   -1,  462,
   -1,  464,   25,   26,   -1,  468,   -1,  468,   -1,   -1,
   -1,  474,   -1,   -1,   -1,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   -1,   -1,   49,   50,   51,   -1,
   -1,   -1,   -1,   56,   57,   58,   59,   60,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   68,   -1,   -1,   -1,   -1,
   73,   -1,   -1,   -1,   77,   78,   79,   80,   81,   82,
   83,   84,   85,   86,   87,   88,   -1,   -1,   -1,   -1,
   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  196,  197,   -1,   -1,  200,  201,  202,
  203,   -1,   -1,  206,   -1,   -1,  209,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  225,  226,  227,  228,  229,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  260,  261,  262,
  263,  264,  265,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  279,  280,  281,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  343,   -1,   -1,   -1,  347,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  375,  376,  377,  378,  379,  380,   -1,   -1,
   -1,   -1,  257,  258,   -1,   -1,  389,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
  305,  306,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  334,
  335,  336,  337,  338,  339,   -1,   -1,   -1,   -1,   -1,
  345,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,  358,  359,   -1,   -1,   -1,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,  373,  374,
  375,  376,  377,  378,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,  394,
  395,  257,  258,   -1,   -1,   -1,  262,  263,  264,  265,
  266,  267,   -1,  269,  270,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,  305,
  306,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  319,  320,  321,  322,  323,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  334,  335,
  336,  337,  338,  339,   -1,   -1,   -1,   -1,   -1,  345,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,  358,  359,   -1,   -1,   -1,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,  373,  374,  375,
  376,  377,  378,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  391,  392,  393,  394,  395,
  257,  258,   -1,   -1,   -1,  262,  263,  264,  265,  266,
   -1,  268,  269,  270,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  319,  320,  321,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  331,  332,   -1,  334,  335,  336,
  337,  338,  339,   -1,   -1,   -1,   -1,   -1,  345,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,  358,  359,   -1,   -1,   -1,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  377,  378,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  391,  392,  393,  394,  395,  257,
  258,   -1,   -1,   -1,  262,  263,  264,  265,  266,  267,
   -1,  269,  270,  271,  272,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,  304,  305,  306,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  319,  320,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  331,  332,   -1,  334,  335,  336,  337,
  338,  339,   -1,   -1,   -1,   -1,   -1,  345,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
  358,  359,   -1,   -1,   -1,  363,  364,  365,  366,  367,
  368,  369,  370,  371,  372,  373,  374,  375,  376,  377,
  378,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  391,  392,  393,  394,  395,  257,  258,
   -1,   -1,   -1,  262,  263,  264,  265,  266,   -1,  268,
  269,  270,  271,  272,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,  305,  306,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  319,  320,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  331,  332,   -1,  334,  335,  336,  337,  338,
  339,   -1,   -1,   -1,   -1,   -1,  345,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
  359,   -1,   -1,   -1,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,  373,  374,  375,  376,  377,  378,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  391,  392,  393,  394,  395,  257,  258,   -1,
   -1,   -1,  262,  263,  264,  265,  266,  267,   -1,  269,
  270,  271,  272,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,  305,  306,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,
  320,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  331,  332,   -1,  334,  335,  336,  337,  338,  339,
   -1,   -1,   -1,   -1,   -1,  345,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,  358,  359,
   -1,   -1,   -1,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,  373,  374,  375,  376,  377,  378,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  391,  392,  393,  394,  395,  257,  258,   -1,   -1,
   -1,  262,  263,  264,  265,  266,   -1,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,  305,  306,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,
  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  331,  332,   -1,  334,  335,  336,  337,  338,  339,   -1,
   -1,   -1,   -1,   -1,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,   -1,
   -1,   -1,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,  373,  374,  375,  376,  377,  378,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  391,  392,  393,  394,  395,  257,  258,   -1,   -1,   -1,
  262,  263,  264,  265,  266,   -1,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,  305,  306,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  331,
  332,   -1,  334,  335,  336,  337,  338,  339,   -1,   -1,
   -1,   -1,   -1,  345,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  357,  358,  359,   -1,   -1,
   -1,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,  373,  374,  375,  376,  377,  378,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,
  392,  393,  394,  395,  257,  258,   -1,   -1,   -1,  262,
  263,  264,  265,  266,   -1,   -1,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,  304,  305,  306,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,
   -1,  334,  335,  336,  337,  338,  339,   -1,   -1,   -1,
   -1,   -1,  345,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,  358,  359,   -1,   -1,   -1,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
  373,  374,  375,  376,  377,  378,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,
  393,  394,  395,  257,  258,   -1,   -1,   -1,  262,  263,
  264,  265,  266,   -1,   -1,  269,  270,  271,  272,  273,
  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,  299,  300,  301,  302,  303,
  304,  305,  306,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,
  334,  335,  336,  337,  338,  339,   -1,   -1,   -1,   -1,
   -1,  345,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  358,  359,   -1,   -1,   -1,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,  373,
  374,  375,  376,  377,  378,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393,
  394,  395,  257,  258,   -1,   -1,   -1,  262,  263,  264,
  265,  266,   -1,   -1,  269,  270,  271,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
  305,  306,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  334,
  335,  336,  337,  338,  339,   -1,   -1,   -1,   -1,   -1,
  345,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,  358,  359,   -1,   -1,   -1,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,  373,  374,
  375,  376,  377,  378,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393,  394,
  395,  257,  258,   -1,   -1,   -1,  262,  263,  264,  265,
  266,   -1,   -1,  269,  270,  271,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,  305,
  306,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  319,  320,  321,  322,  323,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  334,  335,
  336,  337,  338,  339,   -1,   -1,   -1,   -1,   -1,  345,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,  358,  359,   -1,   -1,   -1,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,  373,  374,  375,
  376,  377,  378,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  391,  392,  393,  394,  395,
  257,  258,   -1,   -1,   -1,   -1,  263,  264,  265,  266,
  267,  268,  269,  270,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  319,  320,  321,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  331,  332,   -1,  334,  335,  336,
  337,  338,  339,   -1,   -1,   -1,   -1,   -1,  345,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,  358,  359,   -1,   -1,   -1,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  391,  392,  393,  394,  395,  257,
  258,   -1,   -1,   -1,   -1,  263,  264,  265,  266,  267,
  268,  269,   -1,  271,  272,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  319,  320,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  331,  332,   -1,  334,  335,  336,  337,
  338,  339,   -1,   -1,   -1,   -1,   -1,  345,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
  358,  359,   -1,   -1,   -1,  363,  364,  365,  366,  367,
  368,  369,  370,  371,  372,  373,  374,  375,  376,  377,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  391,  392,  393,  394,  395,  257,  258,
   -1,   -1,   -1,   -1,  263,  264,  265,  266,   -1,   -1,
  269,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  319,  320,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  331,  332,   -1,  334,  335,  336,  337,  338,
  339,   -1,   -1,   -1,   -1,   -1,  345,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
  359,   -1,   -1,   -1,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,  373,  374,  375,  376,  377,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  391,  392,  393,  394,  395,  262,  263,  264,
  265,  266,  267,  268,  269,   -1,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  334,
  335,  336,  337,  338,  339,   -1,   -1,   -1,   -1,   -1,
  345,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,  358,  359,   -1,   -1,   -1,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,  373,  374,
  375,  376,  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393,  394,
  395,  262,  263,  264,  265,  266,  267,  268,  269,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,
  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  331,  332,   -1,  334,  335,  336,  337,  338,  339,   -1,
   -1,   -1,   -1,   -1,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,   -1,
   -1,   -1,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,  373,  374,  375,  376,  377,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  391,  392,  393,  394,  395,  262,  263,  264,  265,  266,
  267,  268,  269,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  319,  320,  321,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  331,  332,   -1,  334,  335,  336,
  337,  338,  339,   -1,   -1,   -1,   -1,   -1,  345,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,  358,  359,   -1,   -1,   -1,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  391,  392,  393,  394,  395,  262,
  263,  264,  265,  266,  267,  268,  269,   -1,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  285,  286,  287,  288,  289,  290,  291,  292,
  293,  294,  295,  296,  297,  298,  299,  300,  301,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,
   -1,  334,  335,  336,  337,  338,  339,   -1,   -1,   -1,
   -1,   -1,  345,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,  357,  358,  359,   -1,   -1,   -1,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
  373,  374,  375,  376,  377,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,
  393,  394,  395,  263,  264,  265,  266,  267,  268,  269,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  285,  286,  287,  288,  289,
  290,  291,  292,  293,  294,  295,  296,  297,  298,  299,
  300,  301,  302,  303,  304,   -1,   -1,  307,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,
  320,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  331,  332,  333,  334,  335,  336,  337,  338,  339,
   -1,   -1,  342,   -1,   -1,  345,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,  358,  359,
   -1,   -1,   -1,  363,  364,  365,  366,  367,  368,  369,
  370,  371,  372,  373,  374,  375,  376,  377,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  391,  392,  393,  394,  395,  263,  264,  265,  266,
  267,  268,  269,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  319,  320,  321,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  331,  332,  333,  334,  335,  336,
  337,  338,  339,   -1,   -1,  342,   -1,   -1,  345,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,  358,  359,   -1,   -1,   -1,  363,  364,  365,  366,
  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  391,  392,  393,  394,  395,  263,
  264,  265,  266,  267,  268,  269,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,  280,  281,  282,  283,
  284,  285,  286,  287,  288,  289,  290,  291,  292,  293,
  294,  295,  296,  297,  298,  299,  300,  301,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,
  334,  335,  336,  337,  338,  339,   -1,   -1,   -1,   -1,
   -1,  345,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,  357,  358,  359,   -1,   -1,   -1,  363,
  364,  365,  366,  367,  368,  369,  370,  371,  372,  373,
  374,  375,  376,  377,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393,
  394,  395,  263,  264,  265,  266,  267,  268,  269,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  285,  286,  287,  288,  289,  290,
  291,  292,  293,  294,  295,  296,  297,  298,  299,  300,
  301,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,
  321,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  331,  332,   -1,  334,  335,  336,  337,  338,  339,   -1,
   -1,   -1,   -1,   -1,  345,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,  358,  359,   -1,
   -1,   -1,  363,  364,  365,  366,  367,  368,  369,  370,
  371,  372,  373,  374,  375,  376,  377,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  391,  392,  393,  394,  395,  263,  264,  265,  266,  267,
  268,  269,   -1,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  285,  286,  287,
  288,  289,  290,  291,  292,  293,  294,  295,  296,  297,
  298,  299,  300,  301,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  319,  320,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  331,  332,   -1,  334,  335,  336,  337,
  338,  339,   -1,   -1,  342,   -1,   -1,  345,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
  358,  359,   -1,   -1,   -1,  363,  364,  365,  366,  367,
  368,  369,  370,  371,  372,  373,  374,  375,  376,  377,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  391,  392,  393,  394,  395,  263,  264,
  265,  266,  267,  268,  269,   -1,  271,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
  285,  286,  287,  288,  289,  290,  291,  292,  293,  294,
  295,  296,  297,  298,  299,  300,  301,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  319,  320,  321,  322,  323,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  334,
  335,  336,  337,  338,  339,   -1,   -1,   -1,   -1,   -1,
  345,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,  358,  359,   -1,   -1,   -1,  363,  364,
  365,  366,  367,  368,  369,  370,  371,  372,  373,  374,
  375,  376,  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  391,  392,  393,  394,
  395,  263,  264,  265,  266,  267,  268,  269,   -1,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  285,  286,  287,  288,  289,  290,  291,
  292,  293,  294,  295,  296,  297,  298,  299,  300,  301,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  319,  320,  321,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  331,
  332,   -1,  334,  335,  336,  337,  338,  339,   -1,   -1,
   -1,   -1,   -1,  345,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  357,  358,  359,   -1,   -1,
   -1,  363,  364,  365,  366,  367,  368,  369,  370,  371,
  372,  373,  374,  375,  376,  377,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  391,
  392,  393,  394,  395,  263,  264,  265,  266,  267,   -1,
  269,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,  280,  281,  282,  283,  284,  285,  286,  287,  288,
  289,  290,  291,  292,  293,  294,  295,  296,  297,  298,
  299,  300,  301,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  319,  320,  321,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  331,  332,   -1,  334,  335,  336,  337,  338,
  339,   -1,   -1,   -1,   -1,   -1,  345,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,  357,  358,
  359,   -1,   -1,   -1,  363,  364,  365,  366,  367,  368,
  369,  370,  371,  372,  373,  374,  375,  376,  377,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  391,  392,  393,  394,  395,  263,  264,  265,
  266,   -1,   -1,  269,   -1,  271,   -1,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  286,  287,  288,  289,  290,  291,  292,  293,  294,  295,
  296,  297,  298,  299,  300,  301,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  319,  320,  321,  322,  323,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  331,  332,   -1,  334,  335,
  336,  337,  338,  339,   -1,   -1,   -1,   -1,   -1,  345,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,  358,  359,   -1,   -1,   -1,  363,  364,  365,
  366,  367,  368,  369,  370,  371,  372,  373,  374,  375,
  376,  377,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  391,  392,  393,  394,  395,
};
#define YYFINAL 4
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 395
#if YYDEBUG
static const char *yyname[] = {

"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"TEXOVER","TEXATOP","CHAR",
"STARTMATH","STARTDMATH","ENDMATH","MI","MIB","MN","MO","SUP","SUB","MROWOPEN",
"MROWCLOSE","LEFT","RIGHT","BIG","BBIG","BIGG","BBIGG","BIGL","BBIGL","BIGGL",
"BBIGGL","FRAC","TFRAC","MATHOP","MOP","MOL","MOLL","MOF","PERIODDELIM",
"OTHERDELIM","LEFTDELIM","RIGHTDELIM","MOS","MOB","SQRT","ROOT","BINOM","UNDER",
"OVER","OVERBRACE","UNDERBRACE","UNDEROVER","TENSOR","MULTI","ARRAY","COLSEP",
"ROWSEP","ARRAYOPTS","COLLAYOUT","COLALIGN","ROWALIGN","ALIGN","EQROWS",
"EQCOLS","ROWLINES","COLLINES","FRAME","PADDING","ATTRLIST","ITALICS","BOLD",
"SLASHED","RM","BB","ST","END","BBLOWERCHAR","BBUPPERCHAR","BBDIGIT","CALCHAR",
"FRAKCHAR","CAL","FRAK","ROWOPTS","TEXTSIZE","SCSIZE","SCSCSIZE","DISPLAY",
"TEXTSTY","TEXTBOX","TEXTSTRING","XMLSTRING","CELLOPTS","ROWSPAN","COLSPAN",
"THINSPACE","MEDSPACE","THICKSPACE","QUAD","QQUAD","NEGSPACE","PHANTOM","HREF",
"UNKNOWNCHAR","EMPTYMROW","STATLINE","TOGGLE","FGHIGHLIGHT","BGHIGHLIGHT",
"SPACE","INTONE","INTTWO","INTTHREE","BAR","WIDEBAR","VEC","WIDEVEC","HAT",
"WIDEHAT","CHECK","WIDECHECK","TILDE","WIDETILDE","DOT","DDOT","UNARYMINUS",
"UNARYPLUS","BEGINENV","ENDENV","MATRIX","PMATRIX","BMATRIX","BBMATRIX",
"VMATRIX","VVMATRIX","SVG","ENDSVG","SMALLMATRIX","CASES","ALIGNED","GATHERED",
"SUBSTACK","PMOD","RMCHAR","COLOR","BGCOLOR",
};
static const char *yyrule[] = {
"$accept : doc",
"doc : xmlmmlTermList",
"xmlmmlTermList :",
"xmlmmlTermList : char",
"xmlmmlTermList : expression",
"xmlmmlTermList : xmlmmlTermList char",
"xmlmmlTermList : xmlmmlTermList expression",
"char : CHAR",
"expression : STARTMATH ENDMATH",
"expression : STARTDMATH ENDMATH",
"expression : STARTMATH compoundTermList ENDMATH",
"expression : STARTDMATH compoundTermList ENDMATH",
"compoundTermList : compoundTerm",
"compoundTermList : compoundTermList compoundTerm",
"compoundTerm : mob SUB closedTerm SUP closedTerm",
"compoundTerm : mob SUB closedTerm",
"compoundTerm : mob SUP closedTerm SUB closedTerm",
"compoundTerm : mob SUP closedTerm",
"compoundTerm : mib SUB closedTerm SUP closedTerm",
"compoundTerm : mib SUB closedTerm",
"compoundTerm : mib SUP closedTerm SUB closedTerm",
"compoundTerm : mib SUP closedTerm",
"compoundTerm : closedTerm SUB closedTerm SUP closedTerm",
"compoundTerm : closedTerm SUP closedTerm SUB closedTerm",
"compoundTerm : closedTerm SUB closedTerm",
"compoundTerm : closedTerm SUP closedTerm",
"compoundTerm : SUB closedTerm",
"compoundTerm : SUP closedTerm",
"compoundTerm : closedTerm",
"closedTerm : array",
"closedTerm : unaryminus",
"closedTerm : unaryplus",
"closedTerm : mib",
"closedTerm : mi",
"closedTerm : mn",
"closedTerm : mo",
"closedTerm : tensor",
"closedTerm : multi",
"closedTerm : mfrac",
"closedTerm : binom",
"closedTerm : msqrt",
"closedTerm : mroot",
"closedTerm : munder",
"closedTerm : mover",
"closedTerm : bar",
"closedTerm : vec",
"closedTerm : hat",
"closedTerm : dot",
"closedTerm : ddot",
"closedTerm : check",
"closedTerm : tilde",
"closedTerm : moverbrace",
"closedTerm : munderbrace",
"closedTerm : munderover",
"closedTerm : emptymrow",
"closedTerm : displaystyle",
"closedTerm : textstyle",
"closedTerm : textsize",
"closedTerm : scriptsize",
"closedTerm : scriptscriptsize",
"closedTerm : italics",
"closedTerm : bold",
"closedTerm : roman",
"closedTerm : rmchars",
"closedTerm : bbold",
"closedTerm : frak",
"closedTerm : slashed",
"closedTerm : cal",
"closedTerm : space",
"closedTerm : textstring",
"closedTerm : thinspace",
"closedTerm : medspace",
"closedTerm : thickspace",
"closedTerm : quad",
"closedTerm : qquad",
"closedTerm : negspace",
"closedTerm : phantom",
"closedTerm : href",
"closedTerm : statusline",
"closedTerm : toggle",
"closedTerm : fghighlight",
"closedTerm : bghighlight",
"closedTerm : color",
"closedTerm : texover",
"closedTerm : texatop",
"closedTerm : MROWOPEN closedTerm MROWCLOSE",
"closedTerm : MROWOPEN compoundTermList MROWCLOSE",
"closedTerm : left compoundTermList right",
"closedTerm : mathenv",
"closedTerm : substack",
"closedTerm : pmod",
"closedTerm : unrecognized",
"left : LEFT LEFTDELIM",
"left : LEFT OTHERDELIM",
"left : LEFT PERIODDELIM",
"right : RIGHT RIGHTDELIM",
"right : RIGHT OTHERDELIM",
"right : RIGHT PERIODDELIM",
"bigdelim : BIG LEFTDELIM",
"bigdelim : BIG RIGHTDELIM",
"bigdelim : BIG OTHERDELIM",
"bigdelim : BBIG LEFTDELIM",
"bigdelim : BBIG RIGHTDELIM",
"bigdelim : BBIG OTHERDELIM",
"bigdelim : BIGG LEFTDELIM",
"bigdelim : BIGG RIGHTDELIM",
"bigdelim : BIGG OTHERDELIM",
"bigdelim : BBIGG LEFTDELIM",
"bigdelim : BBIGG RIGHTDELIM",
"bigdelim : BBIGG OTHERDELIM",
"bigdelim : BIGL LEFTDELIM",
"bigdelim : BIGL OTHERDELIM",
"bigdelim : BBIGL LEFTDELIM",
"bigdelim : BBIGL OTHERDELIM",
"bigdelim : BIGGL LEFTDELIM",
"bigdelim : BIGGL OTHERDELIM",
"bigdelim : BBIGGL LEFTDELIM",
"bigdelim : BBIGGL OTHERDELIM",
"unrecognized : UNKNOWNCHAR",
"unaryminus : UNARYMINUS",
"unaryplus : UNARYPLUS",
"mi : MI",
"mib : MIB",
"mn : MN",
"mob : MOB",
"mo : mob",
"mo : bigdelim",
"mo : MO",
"mo : MOL",
"mo : MOLL",
"mo : RIGHTDELIM",
"mo : LEFTDELIM",
"mo : OTHERDELIM",
"mo : MOF",
"mo : PERIODDELIM",
"mo : MOS",
"mo : MOP",
"mo : MATHOP TEXTSTRING",
"emptymrow : EMPTYMROW",
"space : SPACE ST INTONE END ST INTTWO END ST INTTHREE END",
"statusline : STATLINE TEXTSTRING closedTerm",
"toggle : TOGGLE closedTerm closedTerm",
"fghighlight : FGHIGHLIGHT ATTRLIST closedTerm",
"bghighlight : BGHIGHLIGHT ATTRLIST closedTerm",
"color : COLOR ATTRLIST compoundTermList",
"color : BGCOLOR ATTRLIST compoundTermList",
"textstring : TEXTBOX TEXTSTRING",
"displaystyle : DISPLAY closedTerm",
"textstyle : TEXTSTY closedTerm",
"textsize : TEXTSIZE closedTerm",
"scriptsize : SCSIZE closedTerm",
"scriptscriptsize : SCSCSIZE closedTerm",
"italics : ITALICS closedTerm",
"slashed : SLASHED closedTerm",
"bold : BOLD closedTerm",
"roman : RM ST rmchars END",
"rmchars : RMCHAR",
"rmchars : rmchars RMCHAR",
"bbold : BB ST bbchars END",
"bbchars : bbchar",
"bbchars : bbchars bbchar",
"bbchar : BBLOWERCHAR",
"bbchar : BBUPPERCHAR",
"bbchar : BBDIGIT",
"frak : FRAK ST frakletters END",
"frakletters : frakletter",
"frakletters : frakletters frakletter",
"frakletter : FRAKCHAR",
"cal : CAL ST calletters END",
"calletters : calletter",
"calletters : calletters calletter",
"calletter : CALCHAR",
"thinspace : THINSPACE",
"medspace : MEDSPACE",
"thickspace : THICKSPACE",
"quad : QUAD",
"qquad : QQUAD",
"negspace : NEGSPACE",
"phantom : PHANTOM closedTerm",
"href : HREF TEXTSTRING closedTerm",
"tensor : TENSOR closedTerm MROWOPEN subsupList MROWCLOSE",
"tensor : TENSOR closedTerm subsupList",
"multi : MULTI MROWOPEN subsupList MROWCLOSE closedTerm MROWOPEN subsupList MROWCLOSE",
"multi : MULTI MROWOPEN subsupList MROWCLOSE closedTerm EMPTYMROW",
"multi : MULTI EMPTYMROW closedTerm MROWOPEN subsupList MROWCLOSE",
"subsupList : subsupTerm",
"subsupList : subsupList subsupTerm",
"subsupTerm : SUB closedTerm SUP closedTerm",
"subsupTerm : SUB closedTerm",
"subsupTerm : SUP closedTerm",
"subsupTerm : SUB SUP closedTerm",
"mfrac : FRAC closedTerm closedTerm",
"mfrac : TFRAC closedTerm closedTerm",
"pmod : PMOD closedTerm",
"texover : MROWOPEN compoundTermList TEXOVER compoundTermList MROWCLOSE",
"texover : left compoundTermList TEXOVER compoundTermList right",
"texatop : MROWOPEN compoundTermList TEXATOP compoundTermList MROWCLOSE",
"texatop : left compoundTermList TEXATOP compoundTermList right",
"binom : BINOM closedTerm closedTerm",
"munderbrace : UNDERBRACE closedTerm",
"moverbrace : OVERBRACE closedTerm",
"bar : BAR closedTerm",
"bar : WIDEBAR closedTerm",
"vec : VEC closedTerm",
"vec : WIDEVEC closedTerm",
"dot : DOT closedTerm",
"ddot : DDOT closedTerm",
"tilde : TILDE closedTerm",
"tilde : WIDETILDE closedTerm",
"check : CHECK closedTerm",
"check : WIDECHECK closedTerm",
"hat : HAT closedTerm",
"hat : WIDEHAT closedTerm",
"msqrt : SQRT closedTerm",
"mroot : ROOT closedTerm closedTerm",
"munder : UNDER closedTerm closedTerm",
"mover : OVER closedTerm closedTerm",
"munderover : UNDEROVER closedTerm closedTerm closedTerm",
"mathenv : BEGINENV MATRIX tableRowList ENDENV MATRIX",
"mathenv : BEGINENV GATHERED tableRowList ENDENV GATHERED",
"mathenv : BEGINENV PMATRIX tableRowList ENDENV PMATRIX",
"mathenv : BEGINENV BMATRIX tableRowList ENDENV BMATRIX",
"mathenv : BEGINENV VMATRIX tableRowList ENDENV VMATRIX",
"mathenv : BEGINENV BBMATRIX tableRowList ENDENV BBMATRIX",
"mathenv : BEGINENV VVMATRIX tableRowList ENDENV VVMATRIX",
"mathenv : BEGINENV SMALLMATRIX tableRowList ENDENV SMALLMATRIX",
"mathenv : BEGINENV CASES tableRowList ENDENV CASES",
"mathenv : BEGINENV ALIGNED tableRowList ENDENV ALIGNED",
"mathenv : BEGINENV SVG XMLSTRING ENDSVG",
"mathenv : BEGINENV SVG ENDSVG",
"substack : SUBSTACK MROWOPEN tableRowList MROWCLOSE",
"array : ARRAY MROWOPEN tableRowList MROWCLOSE",
"array : ARRAY MROWOPEN ARRAYOPTS MROWOPEN arrayopts MROWCLOSE tableRowList MROWCLOSE",
"arrayopts : anarrayopt",
"arrayopts : arrayopts anarrayopt",
"anarrayopt : collayout",
"anarrayopt : colalign",
"anarrayopt : rowalign",
"anarrayopt : align",
"anarrayopt : eqrows",
"anarrayopt : eqcols",
"anarrayopt : rowlines",
"anarrayopt : collines",
"anarrayopt : frame",
"anarrayopt : padding",
"collayout : COLLAYOUT ATTRLIST",
"colalign : COLALIGN ATTRLIST",
"rowalign : ROWALIGN ATTRLIST",
"align : ALIGN ATTRLIST",
"eqrows : EQROWS ATTRLIST",
"eqcols : EQCOLS ATTRLIST",
"rowlines : ROWLINES ATTRLIST",
"collines : COLLINES ATTRLIST",
"frame : FRAME ATTRLIST",
"padding : PADDING ATTRLIST",
"tableRowList : tableRow",
"tableRowList : tableRowList ROWSEP tableRow",
"tableRow : simpleTableRow",
"tableRow : optsTableRow",
"simpleTableRow : tableCell",
"simpleTableRow : simpleTableRow COLSEP tableCell",
"optsTableRow : ROWOPTS MROWOPEN rowopts MROWCLOSE simpleTableRow",
"rowopts : arowopt",
"rowopts : rowopts arowopt",
"arowopt : colalign",
"arowopt : rowalign",
"tableCell :",
"tableCell : compoundTermList",
"tableCell : CELLOPTS MROWOPEN cellopts MROWCLOSE compoundTermList",
"cellopts : acellopt",
"cellopts : cellopts acellopt",
"acellopt : colalign",
"acellopt : rowalign",
"acellopt : rowspan",
"acellopt : colspan",
"rowspan : ROWSPAN ATTRLIST",
"colspan : COLSPAN ATTRLIST",

};
#endif
#ifndef YYSTYPE
typedef int YYSTYPE;
#endif
#if YYDEBUG
#include <stdio.h>
#endif

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH  500
#endif
#endif

#define YYINITSTACKSIZE 500

int      yydebug;
int      yynerrs;

typedef struct {
    unsigned stacksize;
    short    *s_base;
    short    *s_mark;
    short    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;

#define YYPURE 0

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;

/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 1550 "itex2MML.y"

char * itex2MML_parse (const char * buffer, unsigned long length)
{
  char * mathml = 0;

  int result;

  itex2MML_setup (buffer, length);
  itex2MML_restart ();

  result = itex2MML_yyparse (&mathml);

  if (result && mathml) /* shouldn't happen? */
    {
      itex2MML_free_string (mathml);
      mathml = 0;
    }
  return mathml;
}

int itex2MML_filter (const char * buffer, unsigned long length)
{
  itex2MML_setup (buffer, length);
  itex2MML_restart ();

  return itex2MML_yyparse (0);
}

#define ITEX_DELIMITER_DOLLAR 0
#define ITEX_DELIMITER_DOUBLE 1
#define ITEX_DELIMITER_SQUARE 2

static char * itex2MML_last_error = 0;

static void itex2MML_keep_error (const char * msg)
{
  if (itex2MML_last_error)
    {
      itex2MML_free_string (itex2MML_last_error);
      itex2MML_last_error = 0;
    }
  itex2MML_last_error = itex2MML_copy_escaped (msg);
}

int itex2MML_html_filter (const char * buffer, unsigned long length)
{
  return itex2MML_do_html_filter (buffer, length, 0);
}

int itex2MML_strict_html_filter (const char * buffer, unsigned long length)
{
  return itex2MML_do_html_filter (buffer, length, 1);
}

int itex2MML_do_html_filter (const char * buffer, unsigned long length, const int forbid_markup)
{
  int result = 0;

  int type = 0;
  int skip = 0;
  int match = 0;

  const char * ptr1 = buffer;
  const char * ptr2 = 0;

  const char * end = buffer + length;

  char * mathml = 0;

  void (*save_error_fn) (const char * msg) = itex2MML_error;

  itex2MML_error = itex2MML_keep_error;

 _until_math:
  ptr2 = ptr1;

  while (ptr2 < end)
    {
      if (*ptr2 == '$') break;
      if ((*ptr2 == '\\') && (ptr2 + 1 < end))
	{
	  if (*(ptr2+1) == '[') break;
	}
      ++ptr2;
    }
  if (itex2MML_write)
    (*itex2MML_write) (ptr1, ptr2 - ptr1);

  if (ptr2 == end) goto _finish;

 _until_html:
  ptr1 = ptr2;

  if (ptr2 + 1 < end)
    {
      if ((*ptr2 == '\\') && (*(ptr2+1) == '['))
	{
	  type = ITEX_DELIMITER_SQUARE;
	  ptr2 += 2;
	}
      else if ((*ptr2 == '$') && (*(ptr2+1) == '$'))
	{
	  type = ITEX_DELIMITER_DOUBLE;
	  ptr2 += 2;
	}
      else
	{
	  type = ITEX_DELIMITER_DOLLAR;
	  ptr2 += 2;
	}
    }
  else goto _finish;

  skip = 0;
  match = 0;

  while (ptr2 < end)
    {
      switch (*ptr2)
	{
	case '<':
	case '>':
	  if (forbid_markup == 1) skip = 1;
	  break;

	case '\\':
	  if (ptr2 + 1 < end)
	    {
	      if (*(ptr2 + 1) == '[')
		{
		  skip = 1;
		}
	      else if (*(ptr2 + 1) == ']')
		{
		  if (type == ITEX_DELIMITER_SQUARE)
		    {
		      ptr2 += 2;
		      match = 1;
		    }
		  else
		    {
		      skip = 1;
		    }
		}
	    }
	  break;

	case '$':
	  if (type == ITEX_DELIMITER_SQUARE)
	    {
	      skip = 1;
	    }
	  else if (ptr2 + 1 < end)
	    {
	      if (*(ptr2 + 1) == '$')
		{
		  if (type == ITEX_DELIMITER_DOLLAR)
		    {
		      ptr2++;
		      match = 1;
		    }
		  else
		    {
		      ptr2 += 2;
		      match = 1;
		    }
		}
	      else
		{
		  if (type == ITEX_DELIMITER_DOLLAR)
		    {
		      ptr2++;
		      match = 1;
		    }
		  else
		    {
		      skip = 1;
		    }
		}
	    }
	  else
	    {
	      if (type == ITEX_DELIMITER_DOLLAR)
		{
		  ptr2++;
		  match = 1;
		}
	      else
		{
		  skip = 1;
		}
	    }
	  break;

	default:
	  break;
	}
      if (skip || match) break;

      ++ptr2;
    }
  if (skip)
    {
      if (type == ITEX_DELIMITER_DOLLAR)
	{
	  if (itex2MML_write)
	    (*itex2MML_write) (ptr1, 1);
	  ptr1++;
	}
      else
	{
	  if (itex2MML_write)
	    (*itex2MML_write) (ptr1, 2);
	  ptr1 += 2;
	}
      goto _until_math;
    }
  if (match)
    {
      mathml = itex2MML_parse (ptr1, ptr2 - ptr1);

      if (mathml)
	{
	  if (itex2MML_write_mathml)
	    (*itex2MML_write_mathml) (mathml);
	  itex2MML_free_string (mathml);
	  mathml = 0;
	}
      else
	{
	  ++result;
	  if (itex2MML_write)
	    {
	      if (type == ITEX_DELIMITER_DOLLAR)
		(*itex2MML_write) ("<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'><merror><mtext>", 0);
	      else
		(*itex2MML_write) ("<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'><merror><mtext>", 0);

	      (*itex2MML_write) (itex2MML_last_error, 0);
	      (*itex2MML_write) ("</mtext></merror></math>", 0);
	    }
	}
      ptr1 = ptr2;

      goto _until_math;
    }
  if (itex2MML_write)
    (*itex2MML_write) (ptr1, ptr2 - ptr1);

 _finish:
  if (itex2MML_last_error)
    {
      itex2MML_free_string (itex2MML_last_error);
      itex2MML_last_error = 0;
    }
  itex2MML_error = save_error_fn;

  return result;
}
#line 2319 "y.tab.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = data->s_mark - data->s_base;
    newss = (data->s_base != 0)
          ? (short *)realloc(data->s_base, newsize * sizeof(*newss))
          : (short *)malloc(newsize * sizeof(*newss));
    if (newss == 0)
        return -1;

    data->s_base  = newss;
    data->s_mark = newss + i;

    newvs = (data->l_base != 0)
          ? (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs))
          : (YYSTYPE *)malloc(newsize * sizeof(*newvs));
    if (newvs == 0)
        return -1;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != 0)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack)) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
        {
            goto yyoverflow;
        }
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;

    yyerror("syntax error");

    goto yyerrlab;

yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yystack.s_mark]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
                {
                    goto yyoverflow;
                }
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 1:
#line 284 "itex2MML.y"
	{/* all processing done in body*/}
break;
case 2:
#line 287 "itex2MML.y"
	{/* nothing - do nothing*/}
break;
case 3:
#line 288 "itex2MML.y"
	{/* proc done in body*/}
break;
case 4:
#line 289 "itex2MML.y"
	{/* all proc. in body*/}
break;
case 5:
#line 290 "itex2MML.y"
	{/* all proc. in body*/}
break;
case 6:
#line 291 "itex2MML.y"
	{/* all proc. in body*/}
break;
case 7:
#line 293 "itex2MML.y"
	{printf("%s", yystack.l_mark[0]);}
break;
case 8:
#line 295 "itex2MML.y"
	{/* empty math group - ignore*/}
break;
case 9:
#line 296 "itex2MML.y"
	{/* ditto */}
break;
case 10:
#line 297 "itex2MML.y"
	{
  char ** r = (char **) ret_str;
  char * s = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>", yystack.l_mark[-1], "</math>");
  itex2MML_free_string(yystack.l_mark[-1]);
  if (r) {
    (*r) = (s == itex2MML_empty_string) ? 0 : s;
  }
  else {
    if (itex2MML_write_mathml)
      (*itex2MML_write_mathml) (s);
    itex2MML_free_string(s);
  }
}
break;
case 11:
#line 310 "itex2MML.y"
	{
  char ** r = (char **) ret_str;
  char * s = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'>", yystack.l_mark[-1], "</math>");
  itex2MML_free_string(yystack.l_mark[-1]);
  if (r) {
    (*r) = (s == itex2MML_empty_string) ? 0 : s;
  }
  else {
    if (itex2MML_write_mathml)
      (*itex2MML_write_mathml) (s);
    itex2MML_free_string(s);
  }
}
break;
case 12:
#line 324 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 13:
#line 328 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 14:
#line 334 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 15:
#line 353 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munder>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</munder>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msub>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msub>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 16:
#line 367 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 17:
#line 386 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<mover>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mover>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msup>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msup>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 18:
#line 400 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 19:
#line 419 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munder>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</munder>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msub>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msub>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 20:
#line 433 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
    char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
    yyval = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 21:
#line 452 "itex2MML.y"
	{
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<mover>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mover>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msup>", yystack.l_mark[-2], " ");
    yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msup>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 22:
#line 466 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
  char * s2 = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  yyval = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 23:
#line 476 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msubsup>", yystack.l_mark[-4], " ");
  char * s2 = itex2MML_copy3(yystack.l_mark[0], " ", yystack.l_mark[-2]);
  yyval = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 24:
#line 486 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msub>", yystack.l_mark[-2], " ");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msub>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 25:
#line 493 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<msup>", yystack.l_mark[-2], " ");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</msup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 26:
#line 500 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<msub><mo></mo>", yystack.l_mark[0], "</msub>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 27:
#line 504 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<msup><mo></mo>", yystack.l_mark[0], "</msup>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 28:
#line 508 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 33:
#line 517 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[0], "</mi>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 34:
#line 521 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mn>", yystack.l_mark[0], "</mn>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 85:
#line 575 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 86:
#line 579 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow>", yystack.l_mark[-1], "</mrow>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 87:
#line 583 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow>", yystack.l_mark[-2], yystack.l_mark[-1]);
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 92:
#line 596 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 93:
#line 601 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 94:
#line 606 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy_string("");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 95:
#line 612 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 96:
#line 616 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 97:
#line 620 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 98:
#line 625 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 99:
#line 630 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 100:
#line 634 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 101:
#line 638 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 102:
#line 643 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 103:
#line 647 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 104:
#line 651 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 105:
#line 656 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 106:
#line 660 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 107:
#line 664 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 108:
#line 669 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 109:
#line 673 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 110:
#line 677 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 111:
#line 682 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.2em\" minsize=\"1.2em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 112:
#line 687 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 113:
#line 692 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"1.8em\" minsize=\"1.8em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 114:
#line 697 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 115:
#line 702 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"2.4em\" minsize=\"2.4em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 116:
#line 707 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 117:
#line 712 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo maxsize=\"3em\" minsize=\"3em\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 118:
#line 718 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<merror><mtext>Unknown character</mtext></merror>");
}
break;
case 119:
#line 722 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mo lspace=\"verythinmathspace\" rspace=\"0em\">&minus;</mo>");
}
break;
case 120:
#line 726 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mo lspace=\"verythinmathspace\" rspace=\"0em\">+</mo>");
}
break;
case 122:
#line 732 "itex2MML.y"
	{
  itex2MML_rowposn=2;
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[0], "</mi>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 124:
#line 740 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"thinmathspace\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 127:
#line 748 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 128:
#line 753 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 129:
#line 758 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"0\"><mo>", yystack.l_mark[0], "</mo></mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 130:
#line 763 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 131:
#line 767 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 132:
#line 772 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 133:
#line 776 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo stretchy=\"false\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 134:
#line 780 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mo>", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 135:
#line 784 "itex2MML.y"
	{
  itex2MML_rowposn=2;
  yyval = itex2MML_copy3("<mo lspace=\"mediummathspace\" rspace=\"mediummathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 136:
#line 789 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 137:
#line 794 "itex2MML.y"
	{
  itex2MML_rowposn = 2;
  yyval = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"thinmathspace\">", yystack.l_mark[0], "</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 138:
#line 800 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mrow></mrow>");
}
break;
case 139:
#line 804 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mspace height=\"", yystack.l_mark[-7], "ex\" depth=\"");
  char * s2 = itex2MML_copy3(yystack.l_mark[-4], "ex\" width=\"", yystack.l_mark[-1]);
  yyval = itex2MML_copy3(s1, s2, "em\"></mspace>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-7]);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 140:
#line 815 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"statusline\">", yystack.l_mark[0], "<mtext>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mtext></maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 141:
#line 823 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"toggle\" selection=\"2\">", yystack.l_mark[-1], " ");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 142:
#line 831 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='color=", yystack.l_mark[-1], "'>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 143:
#line 839 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='background=", yystack.l_mark[-1], "'>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 144:
#line 847 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mstyle mathcolor=", yystack.l_mark[-1], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 145:
#line 854 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mstyle mathbackground=", yystack.l_mark[-1], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 146:
#line 862 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mtext>", yystack.l_mark[0], "</mtext>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 147:
#line 867 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle displaystyle=\"true\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 148:
#line 872 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle displaystyle=\"false\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 149:
#line 877 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"0\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 150:
#line 882 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"1\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 151:
#line 887 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"2\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 152:
#line 892 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle mathvariant=\"italic\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 153:
#line 897 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mpadded width=\"0.125em\"><mo>&#xff0f;</mo></mpadded>", yystack.l_mark[0], "</mrow>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 154:
#line 902 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle mathvariant=\"bold\">", yystack.l_mark[0], "</mstyle>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 155:
#line 907 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi mathvariant=\"normal\">", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 156:
#line 912 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 157:
#line 916 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 158:
#line 922 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 159:
#line 927 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 160:
#line 931 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 161:
#line 937 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "opf;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 162:
#line 941 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "opf;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 163:
#line 945 "itex2MML.y"
	{
  /* Blackboard digits 0-9 correspond to Unicode characters 0x1D7D8-0x1D7E1 */
  char * end = yystack.l_mark[0] + 1;
  int code = 0x1D7D8 + strtoul(yystack.l_mark[0], &end, 10);
  yyval = itex2MML_character_reference(code);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 164:
#line 953 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 165:
#line 958 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 166:
#line 962 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 167:
#line 968 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "fr;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 168:
#line 973 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mi>", yystack.l_mark[-1], "</mi>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 169:
#line 978 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 170:
#line 982 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[-1], yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 171:
#line 988 "itex2MML.y"
	{
  yyval = itex2MML_copy3("&", yystack.l_mark[0], "scr;");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 172:
#line 993 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"thinmathspace\"></mspace>");
}
break;
case 173:
#line 997 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"mediummathspace\"></mspace>");
}
break;
case 174:
#line 1001 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"thickmathspace\"></mspace>");
}
break;
case 175:
#line 1005 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"1em\"></mspace>");
}
break;
case 176:
#line 1009 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"2em\"></mspace>");
}
break;
case 177:
#line 1013 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mspace width=\"-0.1667 em\"></mspace>");
}
break;
case 178:
#line 1017 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mphantom>", yystack.l_mark[0], "</mphantom>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 179:
#line 1022 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow xmlns:xlink=\"http://www.w3.org/1999/xlink\" xlink:type=\"simple\" xlink:href=\"", yystack.l_mark[-1], "\">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 180:
#line 1030 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-3], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 181:
#line 1037 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 182:
#line 1045 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-3], yystack.l_mark[-1]);
  char * s2 = itex2MML_copy3("<mprescripts></mprescripts>", yystack.l_mark[-5], "</mmultiscripts>");
  yyval = itex2MML_copy2(s1, s2);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-5]);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 183:
#line 1055 "itex2MML.y"
	{
  char * s1 = itex2MML_copy2("<mmultiscripts>", yystack.l_mark[-1]);
  char * s2 = itex2MML_copy3("<mprescripts></mprescripts>", yystack.l_mark[-3], "</mmultiscripts>");
  yyval = itex2MML_copy2(s1, s2);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 184:
#line 1064 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mmultiscripts>", yystack.l_mark[-3], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]); 
}
break;
case 185:
#line 1072 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 186:
#line 1076 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 187:
#line 1082 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 188:
#line 1087 "itex2MML.y"
	{
  yyval = itex2MML_copy2(yystack.l_mark[0], " <none></none>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 189:
#line 1091 "itex2MML.y"
	{
  yyval = itex2MML_copy2("<none></none> ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 190:
#line 1095 "itex2MML.y"
	{
  yyval = itex2MML_copy2("<none></none> ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 191:
#line 1100 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mfrac>", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 192:
#line 1107 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mstyle displaystyle=\"false\"><mfrac>", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac></mstyle>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 193:
#line 1115 "itex2MML.y"
	{
  yyval = itex2MML_copy3( "<mo lspace=\"mediummathspace\">(</mo><mo rspace=\"thinmathspace\">mod</mo>", yystack.l_mark[0], "<mo rspace=\"mediummathspace\">)</mo>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 194:
#line 1120 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mfrac><mrow>", yystack.l_mark[-3], "</mrow><mrow>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mrow></mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 195:
#line 1127 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow>", yystack.l_mark[-4], "<mfrac><mrow>");
  char * s2 = itex2MML_copy3(yystack.l_mark[-3], "</mrow><mrow>", yystack.l_mark[-1]);
  char * s3 = itex2MML_copy3("</mrow></mfrac>", yystack.l_mark[0], "</mrow>");
  yyval = itex2MML_copy3(s1, s2, s3);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 196:
#line 1141 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mfrac linethickness=\"0\"><mrow>", yystack.l_mark[-3], "</mrow><mrow>");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mrow></mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 197:
#line 1148 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow>", yystack.l_mark[-4], "<mfrac linethickness=\"0\"><mrow>");
  char * s2 = itex2MML_copy3(yystack.l_mark[-3], "</mrow><mrow>", yystack.l_mark[-1]);
  char * s3 = itex2MML_copy3("</mrow></mfrac>", yystack.l_mark[0], "</mrow>");
  yyval = itex2MML_copy3(s1, s2, s3);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string(s3);
  itex2MML_free_string(yystack.l_mark[-4]);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 198:
#line 1162 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow><mo>(</mo><mfrac linethickness=\"0\">", yystack.l_mark[-1], yystack.l_mark[0]);
  yyval = itex2MML_copy2(s1, "</mfrac><mo>)</mo></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 199:
#line 1170 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<munder>", yystack.l_mark[0], "<mo>&UnderBrace;</mo></munder>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 200:
#line 1175 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&OverBrace;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 201:
#line 1180 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&OverBar;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 202:
#line 1184 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&OverBar;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 203:
#line 1189 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&RightVector;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 204:
#line 1193 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&RightVector;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 205:
#line 1198 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&dot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 206:
#line 1203 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&Dot;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 207:
#line 1208 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&tilde;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 208:
#line 1212 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&tilde;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 209:
#line 1217 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&#x2c7;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 210:
#line 1221 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&#x2c7;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 211:
#line 1226 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo stretchy=\"false\">&#x302;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 212:
#line 1230 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mover>", yystack.l_mark[0], "<mo>&#x302;</mo></mover>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 213:
#line 1235 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<msqrt>", yystack.l_mark[0], "</msqrt>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 214:
#line 1240 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mroot>", yystack.l_mark[0], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mroot>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 215:
#line 1248 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munder>", yystack.l_mark[0], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</munder>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 216:
#line 1256 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mover>", yystack.l_mark[0], yystack.l_mark[-1]);
  yyval = itex2MML_copy2(s1, "</mover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 217:
#line 1264 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<munderover>", yystack.l_mark[0], yystack.l_mark[-2]);
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</munderover>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 218:
#line 1273 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 219:
#line 1277 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable rowspacing=\"1.0ex\">", yystack.l_mark[-2], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 220:
#line 1281 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>(</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>)</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 221:
#line 1285 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>[</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>]</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 222:
#line 1289 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>&VerticalBar;</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>&VerticalBar;</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 223:
#line 1293 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>{</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>}</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 224:
#line 1297 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>&DoubleVerticalBar;</mo><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow><mo>&DoubleVerticalBar;</mo></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 225:
#line 1301 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mstyle scriptlevel=\"2\"><mrow><mtable rowspacing=\"0.5ex\">", yystack.l_mark[-2], "</mtable></mrow></mstyle>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 226:
#line 1305 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mo>{</mo><mrow><mtable columnalign=\"left left\">", yystack.l_mark[-2], "</mtable></mrow></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 227:
#line 1309 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable columnalign=\"right left right left right left right left right left\" columnspacing=\"0em\">", yystack.l_mark[-2], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-2]);
}
break;
case 228:
#line 1313 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<semantics><annotation-xml encoding=\"SVG1.1\">", yystack.l_mark[-1], "</annotation-xml></semantics>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 229:
#line 1317 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(" ");
}
break;
case 230:
#line 1321 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable columnalign=\"center\" rowspacing=\"0.5ex\">", yystack.l_mark[-1], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 231:
#line 1326 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mrow><mtable>", yystack.l_mark[-1], "</mtable></mrow>");
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 232:
#line 1330 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mrow><mtable ", yystack.l_mark[-3], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[-1], "</mtable></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-3]);
  itex2MML_free_string(yystack.l_mark[-1]);
}
break;
case 233:
#line 1338 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 234:
#line 1342 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 235:
#line 1348 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 236:
#line 1352 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 237:
#line 1356 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 238:
#line 1360 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 239:
#line 1364 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 240:
#line 1368 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 241:
#line 1372 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 242:
#line 1376 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 243:
#line 1380 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 244:
#line 1384 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 245:
#line 1389 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnalign=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 246:
#line 1394 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnalign=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 247:
#line 1399 "itex2MML.y"
	{
  yyval = itex2MML_copy2("rowalign=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 248:
#line 1404 "itex2MML.y"
	{
  yyval = itex2MML_copy2("align=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 249:
#line 1409 "itex2MML.y"
	{
  yyval = itex2MML_copy2("equalrows=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 250:
#line 1414 "itex2MML.y"
	{
  yyval = itex2MML_copy2("equalcolumns=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 251:
#line 1419 "itex2MML.y"
	{
  yyval = itex2MML_copy2("rowlines=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 252:
#line 1424 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnlines=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 253:
#line 1429 "itex2MML.y"
	{
  yyval = itex2MML_copy2("frame=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 254:
#line 1434 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("rowspacing=", yystack.l_mark[0], " columnspacing=");
  yyval = itex2MML_copy2(s1, yystack.l_mark[0]);
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 255:
#line 1441 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 256:
#line 1445 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 257:
#line 1451 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mtr>", yystack.l_mark[0], "</mtr>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 258:
#line 1455 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 259:
#line 1460 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 260:
#line 1464 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-2], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 261:
#line 1470 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtr ", yystack.l_mark[-2], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mtr>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 262:
#line 1478 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 263:
#line 1482 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 264:
#line 1488 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 265:
#line 1492 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 266:
#line 1497 "itex2MML.y"
	{
  yyval = itex2MML_copy_string("<mtd></mtd>");
}
break;
case 267:
#line 1500 "itex2MML.y"
	{
  yyval = itex2MML_copy3("<mtd>", yystack.l_mark[0], "</mtd>");
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 268:
#line 1504 "itex2MML.y"
	{
  char * s1 = itex2MML_copy3("<mtd ", yystack.l_mark[-2], ">");
  yyval = itex2MML_copy3(s1, yystack.l_mark[0], "</mtd>");
  itex2MML_free_string(s1);
  itex2MML_free_string(yystack.l_mark[-2]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 269:
#line 1512 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 270:
#line 1516 "itex2MML.y"
	{
  yyval = itex2MML_copy3(yystack.l_mark[-1], " ", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[-1]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 271:
#line 1522 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 272:
#line 1526 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 273:
#line 1530 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 274:
#line 1534 "itex2MML.y"
	{
  yyval = itex2MML_copy_string(yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 275:
#line 1539 "itex2MML.y"
	{
  yyval = itex2MML_copy2("rowspan=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
case 276:
#line 1544 "itex2MML.y"
	{
  yyval = itex2MML_copy2("columnspan=", yystack.l_mark[0]);
  itex2MML_free_string(yystack.l_mark[0]);
}
break;
#line 4263 "y.tab.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack))
    {
        goto yyoverflow;
    }
    *++yystack.s_mark = (short) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    yyerror("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
