dnl= ##########################################################################
dnl= # abiword-plugins: autogen.sh header
dnl= # this file is executed as a shell script
dnl= 
dnl= # 1. abi_plugin_macro is the name of the main macro defined here:
dnl= abi_plugin_macro="ABIPGN_OPENXML"
dnl= 
dnl= # 2. abi_plugin_files is the list of files that configure must generate:
dnl= abi_plugin_files="GNUmakefile common/GNUmakefile common/xp/GNUmakefile exp/GNUmakefile exp/xp/GNUmakefile imp/GNUmakefile imp/xp/GNUmakefile"
dnl= 
dnl= # 3. abi_plugin_desc is a short description of the plugin
dnl= abi_plugin_desc="Plugin to allow AbiWord to read OpenXML .docx files"
dnl=
dnl= # 4. abi_plugin_enable - whether plugin should be enabled by default 
dnl= abi_plugin_enable="no"
dnl=
dnl= return
dnl= ##########################################################################

AC_DEFUN([ABIPGN_OPENXML],[

_abi_cppflags_save="$CPPFLAGS"
_abi_ldflags_save="$LDFLAGS"

ABI_OPENXML_CPPFLAGS=""
ABI_OPENXML_LDFLAGS=""

# Checks for libraries.
# Checks for header files.

PKG_CHECK_MODULES(_abi_openxml,[
	libgsf-1 >= 1.14.4
],[	ABI_PLUGIN_REPORT([OpenXML: okay])
],[	ABI_PLUGIN_REPORT([libgsf: error - libgsf >= 1.14.4 required])
	abi_plugin_disable=yes
])

AX_BOOST_BASE([1.33.1])

AC_SUBST(ABI_OPENXML_CPPFLAGS)
AC_SUBST(ABI_OPENXML_LDFLAGS)

CPPFLAGS="$_abi_cppflags_save"
LDFLAGS="$_abi_ldflags_save"
])
