dnl= ##########################################################################
dnl= # abiword-plugins: autogen.sh header
dnl= # this file is executed as a shell script
dnl= 
dnl= # 1. abi_plugin_macro is the name of the main macro defined here:
dnl= abi_plugin_macro="ABIPGN_PRESENTATION"
dnl= 
dnl= # 2. abi_plugin_files is the list of files that configure must generate:
dnl= abi_plugin_files="GNUmakefile xp/GNUmakefile"
dnl= 
dnl= # 3. abi_plugin_desc is a short description of the plugin
dnl= abi_plugin_desc="Enable AbiWord to make presentations"
dnl= 
dnl= # 4. abi_plugin_enable - whether plugin should be enabled by default
dnl= abi_plugin_enable="yes"
dnl= 
dnl= return
dnl= ##########################################################################

AC_DEFUN([ABIPGN_PRESENTATION],[

_abi_cppflags_save="$CPPFLAGS"
_abi_ldflags_save="$LDFLAGS"

PRESENTATION_CPPFLAGS=""
PRESENTATION_LDFLAGS=""

# Checks for libraries.
# Checks for header files.

PKG_CHECK_MODULES(_abi_glib,glib-2.0 >= 2.0 ,,[	ABI_PLUGIN_REPORT([Prsentation: error - glib-2.0 >= 2.0 required])
	abi_plugin_disable=yes
])

if test $abi_plugin_disable = no; then
	PRESENTATION_CPPFLAGS="$_abi_glib_CFLAGS"
	PRESENTATION_LDFLAGS="$_abi_glib_LIBS"
	ABI_PLUGIN_REPORT([presentation: okay])
fi

AC_SUBST(PRESENTATION_CPPFLAGS)
AC_SUBST(PRESENTATION_LDFLAGS)

CPPFLAGS="$_abi_cppflags_save"
LDFLAGS="$_abi_ldflags_save"
])
