/* OLPC Floating Toolbar
 * Copyright (C) 2006 Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef __OLPCTOOLBARMANAGER_H__
#define __OLPCTOOLBARMANAGER_H__

#include "xap_App.h"
#include "xap_Frame.h"
#include "xav_Listener.h"
#include "xav_View.h"
#include "ut_timer.h"
#include "../unix/ev_UnixOlpcToolbar.h"
#include <map>

// TODO: remove hardcoded "Unix" part
typedef std::map<AV_View*, EV_UnixOlpcToolbar*>		ToolbarMap;
typedef std::map<AV_View*, UT_Timer*>				ToolbarTimerMap;

class ABI_EXPORT OlpcToolbarManager : public AV_Listener
{
public:
	OlpcToolbarManager();
	virtual ~OlpcToolbarManager();

	static OlpcToolbarManager*		getManager();

	// View listener callbacks
	virtual bool					notify(AV_View *pView, const AV_ChangeMask mask);
	virtual AV_ListenerType			getType(void);

	// Timer callbacks
	void							eventTimer(AV_View* pView, UT_Timer* pTimer);

private:
	static OlpcToolbarManager*		m_pManager;
	
	AV_ListenerId					m_avListenerId;
	ToolbarMap						m_toolbars;
	ToolbarTimerMap					m_toolbarTimers;
};

#endif /* __OLPCTOOLBARMANAGER_H__ */
