/* Copyright (C) 2006 by Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
 
#ifndef __XMLSESSIONEVENTPACKET_H__
#define __XMLSESSIONEVENTPACKET_H__

#include "SessionEventPacket.h"

class AbiCollab;

class ABI_EXPORT StartSessionXMLEventPacket : public StartSessionEventPacket
{	
	const UT_UTF8String		serialize() 
		{ return "<StartSession/>"; }
};

class ABI_EXPORT JoinSessionXMLEventPacket : public JoinSessionEventPacket
{
public:
	JoinSessionXMLEventPacket(const UT_UTF8String& sessionId)
		: m_sSessionId(sessionId)
	{
	}

	const UT_UTF8String		serialize()
		{
			UT_UTF8String packet = "<JoinSession sessionId=\"";
			packet += m_sSessionId;
			packet += "\"/>";
			return packet;
		}

private:
	UT_UTF8String			m_sSessionId;		
};

class ABI_EXPORT DisjoinSessionXMLEventPacket : public DisjoinSessionEventPacket
{
public:
	DisjoinSessionXMLEventPacket(const UT_UTF8String& sessionId)
		: m_sSessionId(sessionId)
	{
	}

	const UT_UTF8String		serialize()
		{
			UT_UTF8String packet = "<DisjoinSession sessionId=\"";
			packet += m_sSessionId;
			packet += "\"/>";
			return packet;
		}

private:
	UT_UTF8String			m_sSessionId;		
};

class ABI_EXPORT CloseSessionXMLEventPacket	: public CloseSessionEventPacket
{
public:

	CloseSessionXMLEventPacket(const UT_UTF8String& sessionId)
		: m_sSessionId(sessionId)
	{
	}

	const UT_UTF8String		serialize()
		{
			UT_UTF8String packet = "<CloseSession sessionId=\"";
			packet += m_sSessionId;
			packet += "\"/>";
			return packet;
		}

private:
	UT_UTF8String			m_sSessionId;
};


#endif /* __XMLSESSIONEVENTPACKET_H__ */
