/*
 * AbiCollab - Code to enable the modification of remote documents.
 * Copyright (C) 2005 by Martin Sevior
 * Copyright (C) 2006 by Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef ABI_COLLAB_IMPORT_H
#define ABI_COLLAB_IMPORT_H

#include "ut_types.h"
#include "pt_Types.h"
#include "px_ChangeRecord.h"
#include "ut_stack.h"
#include "stdio.h"
#include "xav_Listener.h"
#include "pl_Listener.h"
#include "ut_string_class.h"
#include "AbiCollab_Export.h"
#include "AbiCollab_Packet.h"

class FL_DocLayout;
class PD_Document;
class UT_Stack;
class ABI_xmpp;
class ChangeAdjust;

class ABI_EXPORT ABI_Collab_Import
{
public:
	ABI_Collab_Import(AbiCollab* pAbiCollab, PD_Document* doc);
	virtual ~ABI_Collab_Import();

	bool					import(const SessionPacket& sPacket);
	UT_sint32				adjustImportPointForCR(UT_sint32 iCRNum, UT_sint32 ipos);
	const UT_GenericVector<ChangeAdjust *> * getAdjusts(void) const
			{ return & m_vecAdjusts;}
	PT_DocPosition			getEndOfDoc(void);
private:
	bool					getStruxType(UT_UTF8String& sInPacket, PTStruxType& struxType,
									UT_UTF8String& sAttributes, UT_UTF8String& sOutpacket);
	bool					getObjectType(UT_UTF8String& sInPacket,PTObjectType& objectType,
									UT_UTF8String& sAttributes, UT_UTF8String& sOutpacket);

	PD_Document*			m_pDoc;
	AbiCollab *				m_pAbiCollab;

	UT_sint32				m_iGlobCounter;
	UT_GenericVector<ChangeAdjust *>	m_vecAdjusts;

};

#endif /* ABI_COLLAB_IMPORT_H */
