dnl= ##########################################################################
dnl= # abiword-plugins: autogen.sh header
dnl= # this file is executed as a shell script
dnl= 
dnl= # 1. abi_plugin_macro is the name of the main macro defined here:
dnl= abi_plugin_macro="ABIPGN_ABICOLLAB"
dnl= 
dnl= # 2. abi_plugin_files is the list of files that configure must generate:
dnl= abi_plugin_files="GNUmakefile xp/GNUmakefile unix/GNUmakefile handlers/GNUmakefile handlers/xmpp/GNUmakefile handlers/xmpp/xp/GNUmakefile handlers/xmpp/unix/GNUmakefile handlers/tcp/GNUmakefile handlers/tcp/xp/GNUmakefile  handlers/tcp/unix/GNUmakefile handlers/xp/GNUmakefile"
dnl= 
dnl= # 3. abi_plugin_desc is a short description of the plugin
dnl= abi_plugin_desc="Real-time collaborative editing"
dnl=
dnl= # 4. abi_plugin_enable - whether plugin should be enabled by default 
dnl= abi_plugin_enable="yes"
dnl=
dnl= return
dnl= ##########################################################################
AC_DEFUN([ABIPGN_ABICOLLAB],[
_abi_cppflags_save="$CPPFLAGS"
_abi_ldflags_save="$LDFLAGS"

ABICOLLAB_LIBXML2_CPPFLAGS=""
ABICOLLAB_LIBXML2_LIBS=""

ABICOLLAB_XMPP_CPPFLAGS=""
ABICOLLAB_XMPP_LIBS=""

ABICOLLAB_TCP_CPFLAGS=""
ABICOLLAB_TCP_LIBS=""

#
# General checks
#
PKG_CHECK_MODULES(_abi_libxml2,[libxml-2.0 >= 2.4.0],[
	ABI_PLUGIN_REPORT([abicollab: okay])
],[	ABI_PLUGIN_REPORT([abicollab: error, libxml-2.0 >= 2.4.0 required])
	abi_plugin_disable=yes
])
if test "x$abi_plugin_disable" = "xno"; then
	ABICOLLAB_LIBXML2_CPPFLAGS="$_abi_libxml2_CFLAGS"
	ABICOLLAB_LIBXML2_LIBS="$_abi_libxml2_LIBS"
fi
AC_SUBST(ABICOLLAB_LIBXML2_CPPFLAGS)
AC_SUBST(ABICOLLAB_LIBXML2_LIBS)


#
# Checks for XMPP support (using loudmouth)
#
PKG_CHECK_MODULES(_abi_loudmouth,[loudmouth-1.0 >= 1.0.1 ],[
	ABI_PLUGIN_REPORT([abicollab XMPP support: yes])
	abicollab_handler_xmpp=yes
],[	ABI_PLUGIN_REPORT([abicollab XMPP support: no, loudmouth >= 1.0.1 required])
])
if test "x$abicollab_handler_xmpp" = "xyes"; then
	ABICOLLAB_XMPP_CPPFLAGS="$_abi_loudmouth_CFLAGS -DABICOLLAB_HANDLER_XMPP"
	ABICOLLAB_XMPP_LIBS="$_abi_loudmouth_LIBS"
fi
AM_CONDITIONAL(ABICOLLAB_HANDLER_XMPP, test "x$abicollab_handler_xmpp" = "xyes")
AC_SUBST(ABICOLLAB_XMPP_CPPFLAGS)
AC_SUBST(ABICOLLAB_XMPP_LIBS)


#
# Checks for TCP support (using asio)
#
AC_LANG_PUSH(C++)
ABICOLLAB_ASIO_CFLAGS=""
ABICOLLAB_ASIO_DIR=""
AC_ARG_WITH(asio,[  --with-asio=DIR       use ASIO in DIR],[
	ABICOLLAB_ASIO_DIR="$withval"
	asio_dir=yes
],[
	asio_dir=auto
])
if test "x$asio_dir" = "xyes"; then
	ABICOLLAB_ASIO_CPPFLAGS="-I$ABICOLLAB_ASIO_DIR/include"
fi

CPPFLAGS="$CPPFLAGS $ABICOLLAB_ASIO_CPPFLAGS"
AC_CHECK_HEADERS(asio.hpp,[
	ABI_PLUGIN_REPORT([abicollab TCP support: yes]) 
	abicollab_handler_tcp=yes
],[	ABI_PLUGIN_REPORT([abicollab TCP support: no, asio >= 0.3.8rc1 required])
])
if test "x$abicollab_handler_tcp" = "xyes" ; then
	ABICOLLAB_TCP_CPPFLAGS="-DABICOLLAB_HANDLER_TCP $ABICOLLAB_ASIO_CPPFLAGS"
	ABICOLLAB_TCP_LIBS="-lboost_thread"
fi
AM_CONDITIONAL(ABICOLLAB_HANDLER_TCP, test "x$abicollab_handler_tcp" = "xyes")
CPPFLAGS="$_abi_cppflags_save"
LDFLAGS="$_abi_ldflags_save"
AC_SUBST(ABICOLLAB_TCP_CPPFLAGS)
AC_SUBST(ABICOLLAB_TCP_LIBS)
AC_LANG_POP


CPPFLAGS="$_abi_cppflags_save"
LDFLAGS="$_abi_ldflags_save"
])
