/* Copyright (C) 2006 by Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __SESSIONEVENT_H__
#define __SESSIONEVENT_H__

#include "Event.h"
#include <xp/AbiCollab.h>
#include <xp/AbiCollab_Packet.h>
// TODO: remove this include, and replace it with a (Session) Event Packet Factory
#include <xp/XMLSessionEventPacket.h>

ABI_EXPORT class StartSessionEvent : public Event
{
public:
	StartSessionEvent()
		: Event(Event::StartSession)
	{
	}
		
	virtual EventPacket*		constructPacket() const
	{
		// TODO: use a factory to create the actual event packet
		return new StartSessionXMLEventPacket();
	}
};

ABI_EXPORT class JoinSessionEvent : public Event
{
public:
	JoinSessionEvent(const UT_UTF8String& sessionId)
		: Event(Event::JoinSession),
		m_sSessionId(sessionId)
	{
		UT_ASSERT(m_sSessionId != "");
	}

	const UT_UTF8String&		getSessionId()
		{ return m_sSessionId; }
		
	virtual EventPacket*		constructPacket() const
	{
		// TODO: use a factory to create the actual event packet
		return new JoinSessionXMLEventPacket(m_sSessionId);
	}

private:
	UT_UTF8String				m_sSessionId;	
};

ABI_EXPORT class DisjoinSessionEvent : public Event
{
public:
	DisjoinSessionEvent(const UT_UTF8String& sessionId)
		: Event(Event::JoinSession),
		m_sSessionId(sessionId)
	{
		UT_ASSERT(m_sSessionId != "");
	}

	const UT_UTF8String&		getSessionId()
		{ return m_sSessionId; }
		
	virtual EventPacket*		constructPacket() const
	{
		// TODO: use a factory to create the actual event packet
		return new DisjoinSessionXMLEventPacket(m_sSessionId);
	}

private:
	UT_UTF8String				m_sSessionId;	
};

ABI_EXPORT class CloseSessionEvent : public Event
{
public:
	CloseSessionEvent(const UT_UTF8String& sessionId)
		: Event(Event::CloseSession),
		m_sSessionId(sessionId)
	{
		UT_ASSERT(m_sSessionId != "");
	}

	const UT_UTF8String&		getSessionId()
		{ return m_sSessionId; }
		
	virtual EventPacket*		constructPacket() const
	{
		// TODO: use a factory to create the actual event packet
		return new CloseSessionXMLEventPacket(m_sSessionId);
	}

private:
	UT_UTF8String				m_sSessionId;
};

#endif /* __SESSIONEVENT_H__ */
