/*
 * Copyright (C) 2005 by Martin Sevior
 * Copyright (C) 2006 by Marc Maurer <uwog@uwog.net> 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __XMPPACCOUNTHANDLER__
#define __XMPPACCOUNTHANDLER__

#include <vector>
#include <map>

using std::string;
using std::map;

#include <loudmouth/loudmouth.h>
#include <libxml/tree.h>

#include <handlers/xp/AccountHandler.h>
#include "stdio.h"
#include "ut_string_class.h"
#include "ut_types.h"
#include "XMPPBuddy.h"

class RawPacket;

#define XMPP_RESOURCE "AbiCollab"

extern AccountHandlerConstructor XMPPAccountHandlerConstructor;
	
class ABI_EXPORT XMPPAccountHandler : public AccountHandler
{
public:
	XMPPAccountHandler();
	virtual ~XMPPAccountHandler(void);

	virtual UT_UTF8String	getDescription();	
	virtual UT_UTF8String	getDisplayType();
	virtual UT_UTF8String	getStorageType();	

	// connection management
	virtual UT_sint32		connect();
	virtual bool			disconnect(void);
	virtual bool			isOnline()
		{ return m_bLoggedIn; }		
	
	// dialog management
	virtual void			embedDialogWidgets(void* pEmbeddingParent) = 0;
	virtual void			removeDialogWidgets(void* pEmbeddingParent) = 0;
	virtual void			storeProperties() = 0;
	
	// packet management
	void 					handleMessage(RawPacket* pRp);

	// user management
	virtual Buddy*			constructBuddy(const PropertyMap& vProps);

	// session management
	virtual void			getSessionsAsync(const Buddy& buddy);
	virtual void			joinSessionAsync(const Buddy& buddy, DocHandle& docHandle);
	
protected:

	// packet management
	virtual bool			_send(const UT_UTF8String& packet);
	virtual bool 			_send(const UT_UTF8String& packet, const Buddy& buddy);

private:
	UT_UTF8String			_getNameFromFqa(const UT_UTF8String& fqa);

	// packet handling functions
	void					_handleGetSessionsRequest(xmlNode* parent, RawPacket* pRp);
	void					_handleGetSessionsResponse(xmlNode* parent, RawPacket* pRp);
	void					_handleJoinSessionRequest(xmlNode* parent, RawPacket* pRp);
	void					_handleJoinSessionResponse(xmlNode* parent, RawPacket* pRp);

	// connection management
	LmConnection *			m_pConnection;
	LmMessageHandler *		m_pPresenceHandler;
	LmMessageHandler *		m_pStreamErrorHandler;
	LmMessageHandler *		m_pChatHandler;
	bool					m_bLoggedIn;
};

#endif /* __XMPPACCOUNTHANDLER__ */
