/* Copyright (C) 2006,2007 by Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __TCPACCOUNTHANDLER__
#define __TCPACCOUNTHANDLER__

#include "asio.hpp"
#include <handlers/xp/AccountHandler.h>

#define DEFAULT_TCP_PORT 58599  /* e * 10^4 + pi * 10^4 */

extern AccountHandlerConstructor TCPAccountHandlerConstructor;

class ABI_EXPORT TCPAccountHandler : public AccountHandler
{
public:
	TCPAccountHandler();
	virtual ~TCPAccountHandler();

	// housekeeping
	virtual UT_UTF8String					getDescription();
	virtual UT_UTF8String					getDisplayType();
	virtual UT_UTF8String					getStorageType();
	
	// dialog management 
	virtual void							storeProperties();

	// connection management
	virtual UT_sint32						connect();
	virtual bool							disconnect();
	virtual bool							isOnline();

	// user management
	virtual Buddy*							constructBuddy(const PropertyMap& props);
		
	// session management
	virtual void							getSessionsAsync(const Buddy& buddy);
	virtual void							joinSessionAsync(const Buddy& buddy, DocHandle& docHandle);

protected:

	// connection management
	virtual UT_sint32						_getPort(const PropertyMap& props);

	// packet management
	virtual bool							_send(const UT_UTF8String& packet);
	virtual bool							_send(const UT_UTF8String& packet, const Buddy& buddy);
	
private:
	bool									m_bConnected;
	asio::io_service						m_io_service;	
};

#endif /* __TCPACCOUNTHANDLER__ */
