/* Copyright (C) 2006 by Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "TCPAccountHandler.h"
#include "TCPBuddy.h"
#include "ut_timer.h"

#include "ServerIOHandler.h" 

TCPAccountHandler::TCPAccountHandler()
	: AccountHandler(),
	m_bConnected(false),
	m_io_service()
{
}

TCPAccountHandler::~TCPAccountHandler()
{
	disconnect();
}

UT_UTF8String TCPAccountHandler::getDescription()
{
	const std::string host = getProperty("server");
	const std::string port = getProperty("port");	
	return UT_UTF8String_sprintf("%s:%s", host.c_str(), port.c_str());
}

UT_UTF8String TCPAccountHandler::getDisplayType()
{
	return "Direct Connection (TCP)";
}

UT_UTF8String TCPAccountHandler::getStorageType()
{
	return "com.abisource.abiword.abicollab.handler.tcp";
}

void TCPAccountHandler::storeProperties()
{
}

UT_sint32 TCPAccountHandler::connect()
{
	UT_DEBUGMSG(("TCPAccountHandler::connect()\n"));
	
	bool isServer = getProperty("server") == "";
	
	// set up the connection
	if (isServer)
	{
		UT_sint32 port = _getPort(getProperties());
		UT_DEBUGMSG(("Start accepting connections on port %d...\n", port));
		// TODO: register this

		ServerIOHandler* pHandler = new ServerIOHandler(m_io_service, port);
	}
	else
	{
	}
}

bool TCPAccountHandler::disconnect()
{
	UT_DEBUGMSG(("TCPAccountHandler::disconnect()\n"));
}

bool TCPAccountHandler::isOnline()
{
	return m_bConnected;
}

Buddy* TCPAccountHandler::constructBuddy(const PropertyMap& props)
{
	UT_DEBUGMSG(("TCPAccountHandler::constructBuddy()\n"));

	PropertyMap::const_iterator hi = props.find("server");
	UT_return_val_if_fail(hi != props.end(), 0);
	UT_return_val_if_fail(hi->second.size() > 0, 0);

	UT_sint32 port = _getPort(props);
	UT_return_val_if_fail(port != -1, 0);
	
	UT_DEBUGMSG(("Constructing TCP Buddy (host: %s, port: %d)\n", hi->second.c_str(), port));
	UT_UTF8String name;
	UT_UTF8String_sprintf(name, "%s:%d", hi->second.c_str(), port); 
	return new TCPBuddy(this, name);
}

void TCPAccountHandler::getSessionsAsync(const Buddy& buddy)
{
}

void TCPAccountHandler::joinSessionAsync(const Buddy& buddy, DocHandle& docHandle)
{
}

UT_sint32 TCPAccountHandler::_getPort(const PropertyMap& props)
{
	PropertyMap::const_iterator pi = props.find("port");

	UT_sint32 port = -1;
	if (pi == props.end()) // no port specified, use the default port
	{
		port = DEFAULT_TCP_PORT;
	}
	else
	{
		long portl = strtol(pi->second.c_str(), (char **)NULL, 10);
		if (portl == LONG_MIN || portl == LONG_MAX) // TODO: we should check errno here for ERANGE
			port = DEFAULT_TCP_PORT;
		else
			port = (UT_sint32)portl;	
	}
	
	return port;
}

bool TCPAccountHandler::_send(const UT_UTF8String& packet)
{
}

bool TCPAccountHandler::_send(const UT_UTF8String& packet, const Buddy& buddy)
{
}
