/* The AbiWord library
 *
 * Copyright (C) 2006 Robert Staudinger <robert.staudinger@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#include "ap_Args.h"
#include "ap_UnixApp.h"
#include "libabiword.h"

static AP_UnixApp *_abiword_app = NULL;

void libabiword_init (int argc, const char **argv)
{
	if (!_abiword_app) {
		XAP_Args XArgs(argc, argv);
		_abiword_app = new AP_UnixApp(&XArgs, PACKAGE);
		AP_Args Args = AP_Args(&XArgs, PACKAGE, _abiword_app);
		Args.parsePoptOpts();
		_abiword_app->initialize(TRUE);
		/* TODO set up segfault handlers */
	}
}

void libabiword_init_noargs ()
{
	if (!_abiword_app) {
		static const char *argv[] = {"libabiword", NULL};
		XAP_Args XArgs(1, argv);
		_abiword_app = new AP_UnixApp(&XArgs, PACKAGE);
		AP_Args Args = AP_Args(&XArgs, PACKAGE, _abiword_app);
		Args.parsePoptOpts();
		_abiword_app->initialize(TRUE);
		/* TODO set up segfault handlers */
	}
}

void libabiword_shutdown ()
{
	if (_abiword_app ) 
	{
		_abiword_app->shutdown();
		delete _abiword_app;
		_abiword_app = NULL;
	}
}
