/*
 * AbiCollab - Code to enable the modification of remote documents.
 * Copyright (C) 2005 by Martin Sevior
 * Copyright (C) 2006 by Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef ABI_COLLAB_H
#define ABI_COLLAB_H

#include <vector>
#include "ut_types.h"
#include "pt_Types.h"
#include "px_ChangeRecord.h"
#include "ut_stack.h"
#include "stdio.h"
#include "xav_Listener.h"
#include "pl_Listener.h"
#include "ut_string_class.h"
#include "ut_uuid.h"
#include "AbiCollab_Export.h"
#include "AbiCollab_Import.h"
#include "AbiCollab_Packet.h"

class FL_DocLayout;
class PD_Document;
class UT_Stack;
class PX_ChangeRecord;
class CommandLine;
class Buddy;

class ABI_EXPORT ChangeAdjust
{
public:
	ChangeAdjust(void);
	ChangeAdjust(PT_DocPosition dPos, UT_sint32 iAdjust, UT_sint32 iCR);
	virtual ~ChangeAdjust(void) {}
		
	PT_DocPosition			m_iDocPos;
	UT_sint32				m_iAdjust;
	UT_sint32				m_iCRNumber;
};

class ABI_EXPORT AbiCollab
{
	friend class ABI_Collab_Export;

public:
	AbiCollab(PD_Document* pDoc);
	AbiCollab(const UT_UTF8String& sSessionId, PD_Document* pDoc, Buddy* pControler);
	virtual ~AbiCollab();

	void								_init(PD_Document* pDoc, bool createUUID = true);

	// collaborator management
	void								addCollaborator(Buddy* pCollaborator);
	void								removeCollaborator(Buddy* pCollaborator);
	const UT_GenericVector<Buddy*>&		getCollaborators()
		{ return m_vecCollaborators; }

	// import/export management
	ABI_Collab_Import *					getImport(void)
		{ return m_pImport; }
	ABI_Collab_Export *					getExport(void)
		{ return m_pExport; }
	void								push(const UT_UTF8String& packet);
	void								maskExport();
	virtual std::vector<UT_UTF8String*>&	unmaskExport();
	bool								isExportMasked(void)
		{ return m_bExportMasked; }
	void								import(SessionPacket* pPacket, const Buddy& collaborator);
	
	// document management
	PD_Document*						getDocument(void) const
		{ return m_pDoc; }

	void								setClose(void)
		{ m_bCloseNow = true; }
	bool								isClose(void)
		{ return  m_bCloseNow; }

	const UT_UTF8String&				getSessionId() const
		{ return m_sId; }

	bool								isLocallyControlled() const
		{ return m_pController == NULL; }
	
private:
	// document management
	void								_setDocument(PD_Document* pDoc);
	void								_setDocListenerId(UT_uint32 iDocListenerId)
		{ m_iDocListenerId = iDocListenerId; }


	PD_Document *					m_pDoc;
	ABI_Collab_Import *				m_pImport;
	ABI_Collab_Export *				m_pExport;

	UT_GenericVector<Buddy*>		m_vecCollaborators;
	UT_uint32						m_iDocListenerId;
	bool							m_bExportMasked;

	UT_UTF8String					m_sId;

	Buddy*							m_pController;

	CommandLine *					m_pCommandLine;
	bool							m_bCloseNow;

protected:
	std::vector<UT_UTF8String*>		m_pMaskedPackets;

};

#endif /* ABI_COLLAB_H */
