/* -*- mode: C++; tab-width: 4; c-basic-offset: 4; -*- */

/* AbiCollab- Code to enable the modification of remote documents.
 * Copyright (C) 2005 by Martin Sevior
 * Copyright (C) 2006 by Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "ut_assert.h"
#include "ut_debugmsg.h"
#include "xap_App.h"
#include "xap_Frame.h"
#include "fv_View.h"
#include "xav_View.h"
#include "xav_Listener.h"
#include "fl_BlockLayout.h"
#include "pd_Document.h"
#include "CommandLine.h"
#include "ie_types.h"
#include "ut_types.h"
#include "ut_misc.h"
#include "ut_units.h"
#include "ap_Strings.h"
#include "xap_Prefs.h"
#include "ap_Frame.h"

#ifdef WIN32
#include <windows.h>
#endif

#include "AbiCollab.h"
#include <handlers/xp/AccountHandler.h>
#include <handlers/xp/Buddy.h>

/*
bool AbiCollabFactoryContainer::extractParams(UT_UTF8String & sCommandLine,
						 UT_UTF8String & sServer,
						 UT_UTF8String & sPort, 
						 UT_UTF8String & sUsername,
						 UT_UTF8String & sPassword,
						 UT_UTF8String ** psRemoteUser,
						 UT_UTF8String ** psRemoteServer,
						 UT_UTF8String ** psPathName)
{
	int _argc = 0;
	char **_argv = NULL;

	if (g_shell_parse_argv (sCommandLine.utf8_str(), &_argc, &_argv, NULL))
	{
		if(_argc < 4)
		{
			return false;
		}
		sServer = _argv[0];
		sPort = _argv[1];
		sUsername = _argv[2];
		sPassword = _argv[3];
		if (_argc > 4)
		{
			*psRemoteUser = new UT_UTF8String(_argv[4]);
		}
		if (_argc > 5)
		{
			*psRemoteServer = new UT_UTF8String(_argv[5]);
		}
		if (_argc > 6)
		{
			*psPathName = new UT_UTF8String(_argv[6]);
		}
	}
}

*/

ChangeAdjust::ChangeAdjust(void): m_iDocPos(0),m_iAdjust(0),m_iCRNumber(0)
{
}

ChangeAdjust::ChangeAdjust(PT_DocPosition iPos, UT_sint32 iAdjust, UT_sint32 iCRNum) 
	: m_iDocPos(iPos),
	m_iAdjust(iAdjust),
	m_iCRNumber(iCRNum)
{
}

/*AbiCollab::AbiCollab(AbiCollabFactoryContainer* pFactory, PD_Document * pDoc, UT_UTF8String sID, bool bAsCommandLine, UT_UTF8String * pPathName)
	: m_pFactory(pFactory),
	  m_pDoc(pDoc),
	  m_pImport(NULL),
	  m_pExport(NULL),
	  m_sID(sID),
	  m_iDocListenerId(0),
	  m_bOffering(false),
	  m_pCommandLine(NULL),
	  m_bCloseNow(false),
	  m_bExportMasked(false),
	  m_pRemoteListener(NULL),
	  m_bIsMaster(false),
	  m_iServiceID(0),
	  m_pServiceExport(NULL)
{
	// TODO: we should lazy-create these; ie. only if there are remote clients
	bool bLoadOK = false;
	if (bAsCommandLine)
	{
	    m_pCommandLine = new CommandLine();
	    if (pPathName != NULL)
	    {
			bLoadOK = m_pCommandLine->loadDocument(*pPathName);
			if (!bLoadOK)
			{
		 	   m_pCommandLine->newDocument();
			}
	    }
	    else
	    {
	        m_pCommandLine->newDocument();
	    }
		UT_ASSERT(m_pCommandLine->getCurrentDocument());
	    setDocument(m_pCommandLine->getCurrentDocument());
	}
}*/

AbiCollab::AbiCollab(PD_Document* pDoc)
	: m_pDoc(pDoc),
	m_pImport(NULL),
	m_pExport(NULL),
	m_bExportMasked(false),
	m_pController(NULL)
{
	_init(pDoc);
}

AbiCollab::AbiCollab(const UT_UTF8String& sSessionId, PD_Document* pDoc, Buddy* pController)
	: m_sId(sSessionId),
	m_pDoc(pDoc),
	m_pImport(NULL),
	m_pExport(NULL),
	m_bExportMasked(false),
	m_pController(pController),
	m_iDocListenerId(0)
{
	_init(pDoc, false);
	addCollaborator(pController);
}

AbiCollab::~AbiCollab(void)
{
	UT_DEBUGMSG(("AbiCollab::~AbiCollab()\n"));
	if (m_pExport)
	{
		if (m_iDocListenerId != 0)
			m_pDoc->removeListener(m_iDocListenerId);
		else
			UT_ASSERT_HARMLESS(UT_SHOULD_NOT_HAPPEN);
	}
	m_iDocListenerId = 0;
	DELETEP(m_pImport);
	DELETEP(m_pExport);
}

void AbiCollab::_init(PD_Document* pDoc, bool createUUID)
{
	UT_return_if_fail(pDoc);
	
	// TODO: this can be made a lil' more efficient, as setDocument
	// will create import and export listeners, which is kinda useless
	// when there is no single collaborator yet
	_setDocument(pDoc);

	if (createUUID)
	{
		XAP_App* pApp = XAP_App::getApp();	
		UT_UUID* pUUID = pApp->getUUIDGenerator()->createUUID();
		pUUID->toString(m_sId);
		UT_DEBUGMSG(("Inited AbiCollab Session with UUID: %s\n", m_sId.utf8_str()));
	}
}

void AbiCollab::removeCollaborator(Buddy* pCollaborator)
{
	UT_return_if_fail(pCollaborator);

	for (UT_sint32 i = 0; i < m_vecCollaborators.getItemCount(); i++)
	{
		Buddy* pBuddy = m_vecCollaborators.getNthItem(i);
		if (pBuddy)
		{
			if (pBuddy->getName() == pCollaborator->getName())
			{
				UT_DEBUGMSG(("AbiCollab::removeCollaborator - removing buddy (%s) from session (%s)\n", pCollaborator->getName().utf8_str(), getSessionId().utf8_str()));
				m_vecCollaborators.deleteNthItem(i);
				// NOTE: let's continue finding buddies with the same name, as we might have missed
				// some buddy disconnects, for example by lost events
			}
		}
		else
			UT_ASSERT_HARMLESS(UT_SHOULD_NOT_HAPPEN);
	}
}

void AbiCollab::addCollaborator(Buddy* pCollaborator)
{
	// TODO: check for duplicates (as long as we assume a collaborator can only be part of a collaboration session once)
	m_vecCollaborators.push_back(pCollaborator);
}

void AbiCollab::_setDocument(PD_Document* pDoc)
{
	UT_DEBUGMSG(("AbiCollab::setDocument()\n"));
	UT_return_if_fail(pDoc);

	// disconnect all old listeners
	if (m_pExport)
	{
		if (m_iDocListenerId > 0)
			m_pDoc->removeListener(m_iDocListenerId);
		else
			UT_ASSERT(UT_SHOULD_NOT_HAPPEN);
	}

	// update the frame
	m_pDoc = pDoc;
	
	// if the document doesn't belong to a frame already, then create a 
	// new frame for this session (except when the document in the current 
	// frame is not dirty, and doesn't have a filename yet (which means it 
	// is a brand new empty document)
	XAP_Frame *pFrame = XAP_App::getApp()->getLastFocussedFrame();
	PD_Document * pFrameDoc = static_cast<PD_Document *>(pFrame->getCurrentDoc());
	if (pFrameDoc != pDoc)
	{
		const char* szName = pFrameDoc->getFilename();
		if (!szName && !pFrameDoc->isDirty())
		{
			// we can replace the document in this frame safely, as it is 
			// brand new, and doesn't have any contents yet
		}
		else
		{
			// the current frame has already a document loaded, let's create
			// a new frame
			pFrame = XAP_App::getApp()->newFrame();
		}
	}
	pFrame->loadDocument(m_pDoc); // this will also delete the old document (or at least, it should)
	// TODO: the frame shouldn't be raised

	// recreate the importers and exporters	
	if (m_pImport)
	{
		DELETEP(m_pImport);
	}
	m_pImport = new ABI_Collab_Import(this, m_pDoc);
	
	if (m_pExport)
	{
		DELETEP(m_pExport);
	}
	m_pExport = new ABI_Collab_Export(this, m_pDoc);
	
	// add the new export listeners
	UT_uint32 lid = 0;
	pDoc->addListener(static_cast<PL_Listener *>(m_pExport), &lid);
	_setDocListenerId(lid);
	UT_DEBUGMSG(("Added document listener %d\n", lid));
}

void AbiCollab::push(const UT_UTF8String& packet)
{
	UT_DEBUGMSG(("AbiCollab::push()\n"));

	if (m_bExportMasked)
	{
		UT_UTF8String* copy = new UT_UTF8String(packet);
		m_pMaskedPackets.push_back(copy);
		return;
	}	

	// TODO: this could go in the session manager
	for (UT_sint32 i = 0; i < m_vecCollaborators.getItemCount(); i++)
	{
		Buddy* pCollaborator = m_vecCollaborators.getNthItem(i);
		if (pCollaborator)
		{
			AccountHandler* pHandler = pCollaborator->getHandler();
			if (pHandler)
			{
				bool res = pHandler->send(this, packet, PT_Session, *pCollaborator);
				if (!res)
					UT_DEBUGMSG(("Error sending a packet!\n"));
			}
		}
	}
}

void AbiCollab::maskExport()
{
	m_bExportMasked = true;
	
	for (std::vector<UT_UTF8String *>::const_iterator pos = m_pMaskedPackets.begin(); pos != m_pMaskedPackets.end(); pos++)
	{
		delete (*pos);
	}
	m_pMaskedPackets.clear();
}

std::vector<UT_UTF8String*>& AbiCollab::unmaskExport()
{
	m_bExportMasked = false;
	if(m_pExport)
		m_pExport->clearGLOB();
	return m_pMaskedPackets;
}

void AbiCollab::import(SessionPacket* pPacket, const Buddy& collaborator)
{
	UT_DEBUGMSG(("AbiCollab::import()\n"));
	UT_return_if_fail(pPacket);
	UT_return_if_fail(m_pImport);
	UT_return_if_fail(m_pExport);	

	// TODO: do this masking in the session manager
	maskExport();
	m_pImport->import(*pPacket);
	std::vector<UT_UTF8String*>& maskedPackets = unmaskExport();
	
	UT_DEBUGMSG(("AbiCollab::import() - TODO: handle masked packets\n"));							

	if (m_vecCollaborators.getItemCount() > 1 && maskedPackets.size() > 0)
	{
		// It seems we are in the center of a collaboration session.
		// It's our duty to reroute the packets to the other collaborators
		
		for (UT_sint32 i = 0; i < m_vecCollaborators.getItemCount(); i++)
		{
			// send all masked packets during import to everyone, except to the
			// person who initialy sent us the packet
			Buddy* pBuddy = m_vecCollaborators.getNthItem(i);
			if (pBuddy && pBuddy->getName() != collaborator.getName())
			{
				for (std::vector<UT_UTF8String*>::const_iterator cit = maskedPackets.begin(); cit != maskedPackets.end(); cit++)
				{
					const UT_UTF8String* pMaskedPacket = (*cit);
					if (pMaskedPacket)
					{
						AccountHandler* pHandler = pBuddy->getHandler();
						if (pHandler)
						{
							pHandler->send(this, *pMaskedPacket, PT_Session, *pBuddy);
						}
						else
							UT_ASSERT(UT_SHOULD_NOT_HAPPEN);
					}
					else
						UT_ASSERT(UT_SHOULD_NOT_HAPPEN);
				}
			}
		}
	}
}

/*
bool AbiCollab::handleImportEvent()
{
	XAP_Frame *pFrame = XAP_App::getApp()->getLastFocussedFrame();

	// If the remote user disconnects, disconnect here too.
	if (isClose())
	{
		UT_UTF8String sID = getID();
		UT_DEBUGMSG(("Removing This connection from remote signal \n"));
		// remove the main loop idle handler
		if(m_pRemoteListener)
		{
				m_pRemoteListener->stop();
		}
		DELETEP(m_pRemoteListener);
		
		m_pFactory->destroy(const_cast<PD_Document *>(getDocument()),sID);
	}
	return TRUE;
}
*/	


