dnl= ##########################################################################
dnl= # abiword-plugins: autogen.sh header
dnl= # this file is executed as a shell script
dnl= 
dnl= # 1. abi_plugin_macro is the name of the main macro defined here:
dnl= abi_plugin_macro="ABIPGN_ABICOLLAB"
dnl= 
dnl= # 2. abi_plugin_files is the list of files that configure must generate:
dnl= abi_plugin_files="GNUmakefile xp/GNUmakefile unix/GNUmakefile handlers/GNUmakefile handlers/xmpp/GNUmakefile handlers/xmpp/xp/GNUmakefile handlers/xmpp/unix/GNUmakefile handlers/xp/GNUmakefile"
dnl= 
dnl= # 3. abi_plugin_desc is a short description of the plugin
dnl= abi_plugin_desc="Interface with GOCollab"
dnl=
dnl= # 4. abi_plugin_enable - whether plugin should be enabled by default 
dnl= abi_plugin_enable="yes"
dnl=
dnl= return
dnl= ##########################################################################
AC_DEFUN([ABIPGN_ABICOLLAB],[
_abi_cppflags_save="$CPPFLAGS"
_abi_ldflags_save="$LDFLAGS"

ABI_ABIXMPP_CPPFLAGS=""
ABI_ABIXMPP_LDFLAGS=""

# Checks for libraries.
# Checks for header files.

PKG_CHECK_MODULES(_abi_loudmouth,[loudmouth-1.0 >= 1.0.1 ],[
	ABI_PLUGIN_REPORT([abicollab - Loudmouth: okay]) \
],[	ABI_PLUGIN_REPORT([abicollab error - Loudmouth >= 1.0.1 required])
	abi_plugin_disable=yes
])

PKG_CHECK_MODULES(_abi_libxml2,[libxml-2.0 >= 2.4.0 ],[
	ABI_PLUGIN_REPORT([abicollab - libxml2: okay]) \
],[	ABI_PLUGIN_REPORT([abicollab error - libxml-2.0 >= 2.4.0 required])
	abi_plugin_disable=yes
])

if test $abi_plugin_disable = no; then
	ABI_ABIXMPP_CPPFLAGS="$_abi_loudmouth_CFLAGS $_abi_libxml2_CFLAFS"
	ABI_ABIXMPP_LDFLAGS="$_abi_loudmouth_LIBS $_abi_libxml2_LIBS"
fi

AC_SUBST(ABI_ABIXMPP_CPPFLAGS)
AC_SUBST(ABI_ABIXMPP_LDFLAGS)

CPPFLAGS="$_abi_cppflags_save"
LDFLAGS="$_abi_ldflags_save"
])
