/* Copyright (C) 2006 by Marc Maurer <uwog@uwog.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __ACCOUNTEVENT_H__
#define __ACCOUNTEVENT_H__

#include "Event.h"
// TODO: remove this include, and replace it with a (Account) Event Packet Factory
#include <xp/XMLAccountEventPacket.h>

ABI_EXPORT class AccountNewEvent : public Event
{
public:
	AccountNewEvent()
		: Event(Event::AccountNew)
	{
	}

	virtual EventPacket*			constructPacket() const
	{
		// this packet should never be transmitted over a network
		return 0;
	}
};

ABI_EXPORT class AccountOnlineEvent : public Event
{
public:
	AccountOnlineEvent()
		: Event(Event::AccountOnline)
	{
	}

	virtual EventPacket*			constructPacket() const
	{
		// this packet should never be transmitted over a network
		return 0;
	}
};

ABI_EXPORT class AccountOfflineEvent : public Event
{
public:
	AccountOfflineEvent()
		: Event(Event::AccountOffline)
	{
	}

	virtual EventPacket*			constructPacket() const
	{
		// this packet should never be transmitted over a network
		return 0;
	}
};

ABI_EXPORT class AccountAddBuddyEvent : public Event
{
public:
	AccountAddBuddyEvent()
		: Event(Event::AccountAddBuddy)
	{
	}

	virtual EventPacket*		constructPacket() const
	{
		// this packet should never be transmitted over a network
		return 0;
	}
};

ABI_EXPORT class AccountDeleteBuddyEvent : public Event
{
public:
	AccountDeleteBuddyEvent()
		: Event(Event::AccountDeleteBuddy)
	{
	}

	virtual EventPacket*		constructPacket() const
	{
		// this packet should never be transmitted over a network
		return 0;
	} 
};

ABI_EXPORT class AccountBuddyOnlineEvent : public Event
{
public:
	AccountBuddyOnlineEvent()
		: Event(Event::AccountBuddyOnline)
	{
	}

	virtual EventPacket*		constructPacket() const
	{
		// this packet should never be transmitted over a network
		return 0;
	} 
};

ABI_EXPORT class AccountBuddyOfflineEvent : public Event
{
public:
	AccountBuddyOfflineEvent()
		: Event(Event::AccountBuddyOffline)
	{
	}

	virtual EventPacket*		constructPacket() const
	{
		// this packet should never be transmitted over a network
		return 0;
	} 
};

ABI_EXPORT class AccountAddBuddyRequestEvent : public Event
{
public:
	AccountAddBuddyRequestEvent()
		: Event(Event::AccountAddBuddyRequest)
	{
	}

	virtual EventPacket*		constructPacket() const
	{
		// this packet should never be transmitted over a network
		// FIXME: ... but for now, we'll add it, at least until we have a proper presence
		// implementation in our XMPP handler
		return new XMLAccountAddBuddyRequestEventPacket();
	} 		
};


ABI_EXPORT class AccountBuddyAddDocumentEvent : public Event
{
public:
	AccountBuddyAddDocumentEvent(DocHandle* pDocHandle)
		: Event(Event::AccountBuddyAddDocument),
		m_pDocHandle(pDocHandle)
	{
	}

	virtual EventPacket*		constructPacket() const
	{
		// this packet should never be transmitted over a network
		return 0;
	}
	
	DocHandle*					getDocHandle() const
		{ return m_pDocHandle; }
	
private:
	DocHandle* 					m_pDocHandle;	
};
#endif /* __ACCOUNTEVENT_H__ */
