/* AbiSource Program Utilities
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OD_LISTLEVELSTYLE_H_
#define _OD_LISTLEVELSTYLE_H_

// Internal includes
#include "OD_ListenerState.h"

// Internal classes
class OD_Style_Style;

// AbiWord classes
class PD_Document;

/**
 * Abstract class
 */
class OD_ListLevelStyle : public OD_ListenerState {
    
public:
    
    OD_ListLevelStyle(const char* pStateName, OD_ElementStack& rElementStack);
    
    virtual void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                               OD_ListenerStateAction& rAction);
                               
    virtual void endElement (const XML_Char* pName,
                             OD_ListenerStateAction& rAction);
                             
    virtual void charData (const XML_Char* pBuffer, int length) {}
    
    UT_uint32 getLevelNumber() const {return m_levelNumber;}
    
    void setAbiListID(UT_uint32 abiListID);
    const UT_UTF8String* getAbiListID() const {return &m_abiListID;}
    
    void setAbiListParentID(const UT_UTF8String& rAbiListParentID) {
        m_abiListParentID = rAbiListParentID;
    }
    
    void setAbiListParentID(const XML_Char* pParentID) {
        m_abiListParentID.assign(pParentID);
    }
    
    const UT_UTF8String* getTextStyleName() const {return &m_textStyleName;}
    void setTextStyle(const OD_Style_Style* pTextStyle) {m_pTextStyle = pTextStyle;}
    
    const UT_UTF8String* getAbiListParentID() const {return &m_abiListParentID;}

    /**
     * The AbiWord properties of the list depends on some properties already
     * defined by the AbiWord paragraph style.
     * 
     * @param rProps Will have the properties string appended.
     * @param pStyle Pointer to the paragraph style used on this list paragraph.
     */    
    void getAbiProperties(UT_UTF8String& rProps, const OD_Style_Style* pStyle = NULL) const;
    
    void defineAbiList(PD_Document* pDocument);
    
    virtual void buildAbiPropsString();
    
    const UT_UTF8String* getMinLabelDistance() const {return &m_minLabelDistance;}
    
protected:

    UT_UTF8String m_level;
    UT_uint32 m_levelNumber;
    
    // The AbiWord list (<l> tag) ID.
    UT_UTF8String m_abiListID;
    
    // The AbiWord list (<l> tag) parent id.
    UT_UTF8String m_abiListParentID;
    
    // The AbiWord list (<l> tag) type.
    UT_UTF8String m_abiListType;
    
    // The AbiWord list (<l> tag) start value.
    UT_UTF8String m_abiListStartValue;
    
    // The AbiWord list (<l> tag) list delim.
    // It's a printf like string with the list maker format.
    UT_UTF8String m_abiListListDelim;
    
    // The AbiWord list (<l> tag) list decimal. 
    // It's the level delimiter, usually a ".", "," or "-"
    // Looks like the property name and its real name (the one used on the GUI)
    // don't match.
    UT_UTF8String m_abiListListDecimal;
    
    // The properties of the list, to be used on the "props" attribute of
    // abi paragraphs (<p>) that uses this list level style.
    UT_UTF8String m_abiProperties;


    
    // text:space-before attribute of <style:list-level-properties>
    UT_UTF8String m_spaceBefore;

    // text:min-label-width attribute of <style:list-level-properties>
    UT_UTF8String m_minLabelWidth;
    
    // text:min-label-distance attribute of <style:list-level-properties>
    // The minumum distance between the list label and the list text.
    // Can't be translated to AbiWord easily.
    UT_UTF8String m_minLabelDistance;
    
    
    // text:style-name attribute of <text:list-level-style-*>
    // Maps, indirectly, to the AbiWord "field-font" property.
    UT_UTF8String m_textStyleName;
    const OD_Style_Style* m_pTextStyle;
};


/**
 * Represents a <text:list-level-style-bullet> element.
 */
class OD_Bullet_ListLevelStyle : public OD_ListLevelStyle {
    
public:

    OD_Bullet_ListLevelStyle(OD_ElementStack& m_rElementStack);
    
    /*void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                               OD_ListenerStateAction& rAction);
                               
    void endElement (const XML_Char* pName,
                             OD_ListenerStateAction& rAction);
                             
    void charData (const XML_Char* pBuffer, int length);*/
    
    void buildAbiPropsString();
};


/**
 * Represents a <text:list-level-style-number> element.
 */
class OD_Numbered_ListLevelStyle : public OD_ListLevelStyle {
    
public:

    OD_Numbered_ListLevelStyle(OD_ElementStack& m_rElementStack);
    
    void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                               OD_ListenerStateAction& rAction);
                               
    /*void endElement (const XML_Char* pName,
                             OD_ListenerStateAction& rAction);
                             
    void charData (const XML_Char* pBuffer, int length);*/
    
    void buildAbiPropsString();
    
private:

    /**
     * Maps the value of the OpenDocument attribute style:num-format to the
     * correspondent AbiWord "type" attribute of the list (<l>) element tag.
     * 
     * @param pStyleNumFormat The value of the style:num-format attribute.
     */
    void _setAbiListType(const XML_Char* pStyleNumFormat);
};

#endif //_OD_LISTLEVELSTYLE_H_
