/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


// Class definition include
#include "ie_exp_OpenDocument.h"

// Internal includes
#include "OO_Common.h"
#include "OO_MetaDataWriter.h"
#include "OO_SettingsWriter.h"
#include "OO_PicturesWriter.h"
#include "OO_ManifestWriter.h"
#include "OO_StylesWriter.h"
#include "OO_StylesContainer.h"
#include "OO_AccumulatorImpl.h"
#include "OO_Listener.h"
#include "OO_WriterImpl.h"


// Abiword includes
#include <ut_assert.h>

// External includes
#include <gsf/gsf-outfile.h>
#include <gsf/gsf-output-stdio.h>
#include <gsf/gsf-outfile-zip.h>



/**
 * Constructor
 */
IE_Exp_OpenDocument::IE_Exp_OpenDocument (PD_Document * pDoc)
  : IE_Exp (pDoc), m_oo(0)
{
}




/**
 * Destructor
 */
IE_Exp_OpenDocument::~IE_Exp_OpenDocument()
{
}





/**
 * This writes out our AbiWord file as an OpenOffice
 * compound document
 */
UT_Error IE_Exp_OpenDocument::_writeDocument(void)
{
    UT_return_val_if_fail(m_oo, UT_ERROR);

    {
        GsfOutput * mimetype = gsf_outfile_new_child (m_oo, "mimetype", FALSE);
        if (!mimetype)
            return UT_ERROR;

        oo_gsf_output_write(mimetype,
            strlen("application/vnd.oasis.opendocument.text"),
            (const guint8 *)"application/vnd.oasis.opendocument.text");
            
        oo_gsf_output_close(mimetype);
    }

    if (!OO_MetaDataWriter::writeMetaData(getDoc(), m_oo))
        return UT_ERROR;

    if (!OO_SettingsWriter::writeSettings(getDoc(), m_oo))
        return UT_ERROR;

    if (!OO_PicturesWriter::writePictures(getDoc(), m_oo))
        return UT_ERROR;

    if (!OO_ManifestWriter::writeManifest(getDoc(), m_oo))
        return UT_ERROR;

    OO_StylesContainer stylesContainer;
    OO_AccumulatorImpl accumulatorImpl(&stylesContainer);
    OO_Listener listener1(getDoc(), this, &accumulatorImpl);
    if (!getDoc()->tellListener(static_cast<PL_Listener *>(&listener1)))
        return UT_ERROR;

    if (!OO_StylesWriter::writeStyles(getDoc(), m_oo, stylesContainer))
        return UT_ERROR;

    OO_WriterImpl writerImpl(m_oo, &stylesContainer);
    OO_Listener listener2(getDoc(), this, &writerImpl);
    if (!getDoc()->tellListener(static_cast<PL_Listener *>(&listener2)))
        return UT_ERROR;
    listener2.endDocument();

    return UT_OK;
}




/**
 * Open the underlying ZIP file for writing
 */
bool IE_Exp_OpenDocument::_openFile(const char * szFilename)
{
    UT_return_val_if_fail(!m_oo, false);

    GsfOutput * sink = GSF_OUTPUT (gsf_output_stdio_new (szFilename, NULL));
    if (!sink)
        return false;

    m_oo = GSF_OUTFILE (gsf_outfile_zip_new (sink, NULL));
    g_object_unref(G_OBJECT(sink));

    return (m_oo != 0);
}




/**
 * Close our underlying ZIP file
 */
bool IE_Exp_OpenDocument::_closeFile(void)
{
    if(m_oo) {
        oo_gsf_output_close(GSF_OUTPUT(m_oo));
        m_oo = 0;
    }

    return true;
}
