/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OD_TEXTCONTENT_LISTENERSTATE_H_
#define _OD_TEXTCONTENT_LISTENERSTATE_H_

// Internal includes
#include "OD_ListenerState.h"

// AbiWord includes
#include <ut_types.h>
#include <ut_stack.h>

// External includes
#include <gsf/gsf.h>

// Internal classes
class OD_Office_Styles;
class OD_Style_List;

// AbiWord classes
class PD_Document;

/**
 * It parses the regular content of a text document. It is used to parse the
 * document text body itself (<office:text>) and the contents of headers
 * (<style:header>) and footers (<style:footer>).
 * 
 * Regular text content may have the following main elements (that is, not
 * mentioning their child elements):
 * <text-h>
 * <text-p>
 * <text-list>
 * <table-table>
 * <text-section>
 * <text-table-of-content>
 * <text-illustration-index>
 * <text-table-index>
 * <text-object-index>
 * <text-user-index>
 * <text-alphabetical-index>
 * <text-bibliography>
 * <text-index-title>
 * <change-marks>
 */
class OD_TextContent_ListenerState : public OD_ListenerState {

public:

    OD_TextContent_ListenerState (
        PD_Document* pDocument,
        OD_Office_Styles* pStyles,
        OD_ElementStack& rElementStack);

    void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                       OD_ListenerStateAction& rAction);
                       
    void endElement (const XML_Char* pName, OD_ListenerStateAction& rAction);
    
    void charData (const XML_Char* pBuffer, int length);
    
private:

    PD_Document* m_pAbiDocument;

    OD_Office_Styles* m_pStyles;

    bool m_bInSection;
    bool m_bAcceptingText;

    UT_GenericVector<XML_Char*> m_vecInlineFmt;
    UT_Stack m_stackFmtStartIndex;

	// Buffer that stores character data defined between start and end element
	// tags. e.g.: <bla>some char data</bla>
    UT_UCS4String m_charData;

    bool m_bInTOC;

    int m_row;
    int m_col;
    int m_cel;
    
    // Valued as "true" if it is parsing XML content inside a
    // <office:document-content> tag.
    bool m_bOnContentStream;
    
    // List info
    OD_Style_List* m_pCurrentListStyle;
    UT_uint8 m_listLevel;
    bool m_alreadyDefinedAbiParagraphForList;

    void _insertBookmark (const XML_Char * name, const XML_Char * type);
    void _flush ();
    void _openTable (const XML_Char** ppProps);
    void _openColumn (const XML_Char** ppProps);
    void _openRow (const XML_Char** ppProps);
    void _openCell (const XML_Char** ppProps);
    void _closeTable ();
    void _closeColumn ();
    void _closeRow ();
    void _closeCell ();
    void _startParagraphElement (const XML_Char* pName,
                                 const XML_Char** ppParagraphAtts,
                                 OD_ListenerStateAction& rAction);
    

    bool _pushInlineFmt(const XML_Char** ppAtts);
    void _popInlineFmt(void);
    void _insureInBlock(const XML_Char ** atts);
    void _insureInSection(const XML_Char* pProps = NULL);
};

#endif //_OD_TEXTCONTENT_LISTENERSTATE_H_
