/* AbiSource Program Utilities
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OD_STYLE_PAGELAYOUT_H_
#define _OD_STYLE_PAGELAYOUT_H_

// Internal includes
#include "OD_ListenerState.h"

// AbiWord includes
#include <ut_string_class.h>

// AbiWord classes
class PD_Document;


/**
 * An OpenDocument page layout style (<style:page-layout>).
 */
class OD_Style_PageLayout : public OD_ListenerState {
public:
    OD_Style_PageLayout(OD_ElementStack& rElementStack) :
    	OD_ListenerState("StylePageLayout", rElementStack) {}
    
    void startElement(const XML_Char* pName, const XML_Char** ppAtts,
                      OD_ListenerStateAction& rAction);
                      
    void endElement(const XML_Char* pName, OD_ListenerStateAction& rAction);

    void charData (const XML_Char* pBuffer, int length) {}
    
    void definePageSizeTag(PD_Document* pDocument) const;
    
    // Returns the value to be used on every <section> tag of the AbiWord
    // document. 
    inline const UT_UTF8String& getSectionProps() const {return m_sectionProps;}
    
    inline const UT_UTF8String& getName() const {return m_name;}
    
private:

    void _parse_pageLayoutProperties(const XML_Char** ppAtts);

    UT_UTF8String m_name;
    
    UT_UTF8String m_pageWidth;
    double m_pageWidthNumeric;
    UT_UTF8String m_pageHeight;
    double m_pageHeightNumeric;
    UT_UTF8String m_printOrientation;

    // The following properties, on AbiWord, belongs to the <section> tag.    
    UT_UTF8String m_marginLeft;
    UT_UTF8String m_marginRight;
    UT_UTF8String m_marginTop;
    UT_UTF8String m_marginBottom;
    
    // Properties that goes to the <section> tag of AbiWord, as the "props"
    // attribute value.
    UT_UTF8String m_sectionProps;
};

#endif //_OD_STYLE_PAGELAYOUT_H_
