/* AbiSource Program Utilities
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


#ifndef _OD_STYLE_MASTERPAGE_H_
#define _OD_STYLE_MASTERPAGE_H_

// Internal includes
#include "OD_ListenerState.h"
#include "OD_Style_PageLayout.h"

// AbiWord includes
#include <ut_string_class.h>

// AbiWord classes
class PD_Document;

/**
 * Class representing a <style:master-page>
 */
class OD_Style_MasterPage : public OD_ListenerState {
    
public:

    OD_Style_MasterPage(PD_Document* pDocument, OD_ElementStack& rElementStack);

    void startElement(const XML_Char* pName, const XML_Char** ppAtts,
                      OD_ListenerStateAction& rAction);
    
    void endElement(const XML_Char* pName, OD_ListenerStateAction& rAction);
    
    void charData (const XML_Char* pBuffer, int length) {}
    
    
    inline const UT_UTF8String& getLayoutName() const {return m_layoutName;}
    
    inline void setLayoutStylePointer(OD_Style_PageLayout* pPageLayoutStyle) {
        m_pPageLayoutStyle = pPageLayoutStyle;
    }
    
    inline void definePageSizeTag(PD_Document* pDocument) const {
        m_pPageLayoutStyle->definePageSizeTag(pDocument);
    }
    
    inline const UT_UTF8String& getSectionProps() const {
        return m_pPageLayoutStyle->getSectionProps();
    }
    
    inline const UT_UTF8String& getName() const {return m_name;}
    
    inline const UT_UTF8String& getPageLayoutName() const {return m_layoutName;}
    
    inline const OD_Style_PageLayout* getPageLayout() const {
        return m_pPageLayoutStyle;
    }
    
    
    const UT_UTF8String& getAWHeaderSectionID() const {return m_AW_headerSectionID;}
    const UT_UTF8String& getAWFooterSectionID() const {return m_AW_footerSectionID;}
    const UT_UTF8String& getAWEvenHeaderSectionID() const {return m_AW_evenHeaderSectionID;}
    const UT_UTF8String& getAWEvenFooterSectionID() const {return m_AW_evenFooterSectionID;}

private:

    PD_Document* m_pAbiDocument;

    OD_Style_PageLayout* m_pPageLayoutStyle;

    UT_UTF8String m_name;
    UT_UTF8String m_layoutName;

    // The AbiWord header section id
    UT_UTF8String m_AW_headerSectionID;
    
    // The AbiWord even header section id
    UT_UTF8String m_AW_evenHeaderSectionID;
    
    // The AbiWord footer section id
    UT_UTF8String m_AW_footerSectionID;
    
    // The AbiWord even footer section id
    UT_UTF8String m_AW_evenFooterSectionID;    
    
    bool m_postponedHeaderParsing;
    bool m_postponedFooterParsing;
    bool m_postponedHeaderLeftParsing;
    bool m_postponedFooterLeftParsing;
};

#endif //_OD_STYLE_MASTERPAGE_H_
