/* AbiSource
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OD_FRAME_LISTENERSTATE_H_
#define _OD_FRAME_LISTENERSTATE_H_

// Internal includes
#include "OD_ListenerState.h"

// Internal classes
class OD_Office_Styles;
class OD_Style_List;
class OD_Abi_Data;

// AbiWord classes
class PD_Document;


/**
 * To parse a <draw:frame> element.
 */
class OD_Frame_ListenerState : public OD_ListenerState {
	
public:
	
	OD_Frame_ListenerState(PD_Document* pDocument,
        OD_Office_Styles* pStyles,
        OD_Abi_Data& rAbiData,
        OD_ElementStack& rElementStack);
	
    void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                       OD_ListenerStateAction& rAction);
                       
    void endElement (const XML_Char* pName, OD_ListenerStateAction& rAction);
    
    void charData (const XML_Char* pBuffer, int length);
    
private:

    /**
     * @param ppAtts The attributes of a <draw:image> element.
     */
    void _drawImage (const XML_Char** ppAtts);

	PD_Document* m_pAbiDocument;
    OD_Abi_Data& m_rAbiData;
    OD_Office_Styles* m_pStyles;
    
    bool m_parsedFrameStartTag;
    bool m_bOnContentStream;
    
    UT_UTF8String m_waitingEndElement;
};

#endif //_OD_FRAME_LISTENERSTATE_H_
