%{
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define YYSTYPE char *
#define YYPARSE_PARAM_TYPE char **
#define YYPARSE_PARAM ret_str

#define yytext itex2MML_yytext

 extern int yylex ();

 extern char * yytext;

 extern int itex2MML_lineno;

 extern int itex2MML_rowposn;
 extern int itex2MML_displaymode;

 static void yyerror(char * s)
   {
     fprintf(stderr, "Line: %d Error: %s at token %s\n", itex2MML_lineno, s, yytext);
   }

 char * itex2MML_empty_string = "";

 /* Create a copy of a string, adding space for extra chars
  */
 char * itex2MML_copy_string_extra (const char * str, unsigned extra)
   {
     char * copy = malloc(extra + (str ? strlen (str) : 0) + 1);
     if (copy)
       {
	 if (str)
	   strcpy(copy, str);
	 else
	   copy[0] = 0;
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string, appending two strings
  */
 char * itex2MML_copy3 (const char * first, const char * second, const char * third)
   {
     int  first_length =  first ? strlen( first) : 0;
     int second_length = second ? strlen(second) : 0;
     int  third_length =  third ? strlen( third) : 0;

     char * copy = malloc(first_length + second_length + third_length + 1);

     if (copy)
       {
	 if (first)
	   strcpy(copy, first);
	 else
	   copy[0] = 0;

	 if (second) strcat(copy, second);
	 if ( third) strcat(copy,  third);
       }
     return copy ? copy : itex2MML_empty_string;
   }

 /* Create a copy of a string
  */
 char * itex2MML_copy_string (const char * str)
   {
     return itex2MML_copy3(str, 0, 0);
   }

 /* Create a copy of a string, appending a second string
  */
 char * itex2MML_copy2 (const char * first, const char * second)
   {
     return itex2MML_copy3(first, second, 0);
   }

 void itex2MML_free_string (char * str)
   {
     if (str && str != itex2MML_empty_string)
       free(str);
   }

%}



%token    CHAR STARTMATH STARTDMATH ENDMATH MI MN MO PLUS SUP SUB MROWOPEN MROWCLOSE LEFT RIGHT  FRAC MATHOP MOP MOL MONS MOS MOB SQRT ROOT BINOM UNDER OVER OVERBRACE UNDERBRACE UNDEROVER TENSOR MULTI ARRAY COLSEP ROWSEP ARRAYOPTS COLLAYOUT COLALIGN ROWALIGN ALIGN EQROWS EQCOLS ROWLINES COLLINES FRAME PADDING ATTRLIST ITALICS BOLD RM BB ST END BBLOWERCHAR BBUPPERCHAR CALCHAR FRAKCHAR CAL FRAK ROWOPTS TEXTSIZE SCSIZE SCSCSIZE DISPLAY TEXTSTY TEXTBOX TEXTSTRING CELLOPTS ROWSPAN COLSPAN THINSPACE MEDSPACE THICKSPACE QUAD QQUAD NEGSPACE PHANTOM HREF UNKNOWNCHAR EMPTYMROW STATLINE TOGGLE FGHIGHLIGHT BGHIGHLIGHT SPACE INTONE INTTWO INTTHREE BAR VEC HAT CHECK TILDE DOT DDOT UNARYMINUS

%left TEXOVER

%%

doc:  xmlmmlTermList {/* all processing done in body*/};

xmlmmlTermList:
{/* nothing - do nothing*/}
| char {/* proc done in body*/}
| expression {/* all proc. in body*/}
| xmlmmlTermList char {/* all proc. in body*/}
| xmlmmlTermList expression {/* all proc. in body*/};

char: CHAR {printf("%s", $1);};

expression: STARTMATH ENDMATH {/* empty math group - ignore*/}
| STARTDMATH ENDMATH {/* ditto */}
| STARTMATH compoundTermList ENDMATH {
  char * s = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='inline'>", $2, "</math>");
  itex2MML_free_string($2);
  (*ret_str) = (s == itex2MML_empty_string) ? 0 : s;
}
| STARTDMATH compoundTermList ENDMATH {
  char * s = itex2MML_copy3("<math xmlns='http://www.w3.org/1998/Math/MathML' display='block'>", $2, "</math>");
  itex2MML_free_string($2);
  (*ret_str) = (s == itex2MML_empty_string) ? 0 : s;
};

compoundTermList: compoundTerm {
  $$ = itex2MML_copy2($1, "\n");
  itex2MML_free_string($1);
}
| compoundTermList compoundTerm {
  $$ = itex2MML_copy2($1, $2);
  itex2MML_free_string($1);
  itex2MML_free_string($2);
}
| texover;

compoundTerm: mob SUB closedTerm SUP closedTerm {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", $1, " ");
    char * s2 = itex2MML_copy3($3, " ", $5);
    $$ = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", $1, " ");
    char * s2 = itex2MML_copy3($3, " ", $5);
    $$ = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string($1);
  itex2MML_free_string($3);
  itex2MML_free_string($5);
}
| mob SUB closedTerm {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munder>", $1, " ");
    $$ = itex2MML_copy3(s1, $3, "</munder>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msub>", $1, " ");
    $$ = itex2MML_copy3(s1, $3, "</msub>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string($1);
  itex2MML_free_string($3);
}
| mob SUP closedTerm SUB closedTerm {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<munderover>", $1, " ");
    char * s2 = itex2MML_copy3($5, " ", $3);
    $$ = itex2MML_copy3(s1, s2, "</munderover>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  else {
    char * s1 = itex2MML_copy3("<msubsup>", $1, " ");
    char * s2 = itex2MML_copy3($5, " ", $3);
    $$ = itex2MML_copy3(s1, s2, "</msubsup>");
    itex2MML_free_string(s1);
    itex2MML_free_string(s2);
  }
  itex2MML_free_string($1);
  itex2MML_free_string($3);
  itex2MML_free_string($5);
}
| mob SUP closedTerm {
  if (itex2MML_displaymode == 1) {
    char * s1 = itex2MML_copy3("<mover>", $1, " ");
    $$ = itex2MML_copy3(s1, $3, "</mover>");
    itex2MML_free_string(s1);
  }
  else {
    char * s1 = itex2MML_copy3("<msup>", $1, " ");
    $$ = itex2MML_copy3(s1, $3, "</msup>");
    itex2MML_free_string(s1);
  }
  itex2MML_free_string($1);
  itex2MML_free_string($3);
}
| closedTerm SUB closedTerm SUP closedTerm {
  char * s1 = itex2MML_copy3("<msubsup>", $1, " ");
  char * s2 = itex2MML_copy3($3, " ", $5);
  $$ = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string($1);
  itex2MML_free_string($3);
  itex2MML_free_string($5);
}
| closedTerm SUP closedTerm SUB closedTerm {
  char * s1 = itex2MML_copy3("<msubsup>", $1, " ");
  char * s2 = itex2MML_copy3($5, " ", $3);
  $$ = itex2MML_copy3(s1, s2, "</msubsup>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string($1);
  itex2MML_free_string($3);
  itex2MML_free_string($5);
}
| closedTerm SUB closedTerm {
  char * s1 = itex2MML_copy3("<msub>", $1, " ");
  $$ = itex2MML_copy3(s1, $3, "</msub>");
  itex2MML_free_string(s1);
  itex2MML_free_string($1);
  itex2MML_free_string($3);
}
| closedTerm SUP closedTerm {
  char * s1 = itex2MML_copy3("<msup>", $1, " ");
  $$ = itex2MML_copy3(s1, $3, "</msup>");
  itex2MML_free_string(s1);
  itex2MML_free_string($1);
  itex2MML_free_string($3);
}
| SUB closedTerm {
  $$ = itex2MML_copy3("<msub><mo></mo>", $2, "</msub>");
  itex2MML_free_string($2);
}
| SUP closedTerm {
  $$ = itex2MML_copy3("<msup><mo></mo>", $2, "</msup>");
  itex2MML_free_string($2);
}
| closedTerm {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
};

closedTerm: array
| unaryminus
| mi {
  $$ = itex2MML_copy3("<mi>", $1, "</mi>");
  itex2MML_free_string($1);
}
| mn {
  $$ = itex2MML_copy3("<mn>", $1, "</mn>");
  itex2MML_free_string($1);
}
| mo 
| tensor
| multi
| mfrac
| binom
| msqrt 
| mroot
| munder
| mover
| bar
| vec
| hat
| dot
| ddot
| check
| tilde
| moverbrace
| munderbrace
| munderover
| emptymrow
| displaystyle
| textstyle
| textsize
| scriptsize
| scriptscriptsize
| italics
| bold
| roman
| bbold
| frak
| cal
| space
| textstring
| thinspace
| medspace
| thickspace
| quad
| qquad
| negspace
| phantom
| href
| statusline
| toggle
| fghighlight
| bghighlight
| MROWOPEN compoundTermList MROWCLOSE {
  $$ = itex2MML_copy3("<mrow>", $2, "</mrow>");
  itex2MML_free_string($2);
}
| LEFT compoundTermList RIGHT mo {
  char * s1 = itex2MML_copy3("<mrow>", $2, " ");
  $$ = itex2MML_copy3(s1, $4, "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($4);
}
| LEFT compoundTermList RIGHT {
  $$ = itex2MML_copy3("<mrow>", $2, "</mrow>");
  itex2MML_free_string($2);
}
| unrecognized;

unrecognized: UNKNOWNCHAR {
  $$ = itex2MML_copy_string("<merror>Unknown character</merror>");
};

unaryminus: UNARYMINUS {
  $$ = itex2MML_copy_string("<mo lspace=\"verythinmathspace\" rspace=\"0em\">-</mo>");
};

mi: MI;

mn: MN;

mob: MOB {
  itex2MML_rowposn = 2;
  $$ = itex2MML_copy3("<mo lspace=\"thinmathspace\" rspace=\"thinmathspace\">", $1, "</mo>");
  itex2MML_free_string($1);
};

mo: mob
| MO {
  $$ = itex2MML_copy3("<mo>", $1, "</mo>");
  itex2MML_free_string($1);
}
| MOL {
  itex2MML_rowposn = 2;
  $$ = itex2MML_copy3("<mo>", $1, "</mo>");
  itex2MML_free_string($1);
}
| MONS {
  itex2MML_rowposn=2;
  $$ = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"0em\">", $1, "</mo>");
  itex2MML_free_string($1);
}
| MOS {
  itex2MML_rowposn=2;
  $$ = itex2MML_copy3("<mo lspace=\"mediummathspace\" rspace=\"mediummathspace\">", $1, "</mo>");
  itex2MML_free_string($1);
}
| MOP {
  itex2MML_rowposn = 2;
  $$ = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"thinmathspace\">", $1, "</mo>");
  itex2MML_free_string($1);
}
| MATHOP TEXTSTRING {
  itex2MML_rowposn = 2;
  $$ = itex2MML_copy3("<mo lspace=\"0em\" rspace=\"thinmathspace\">", $2, "</mo>");
  itex2MML_free_string($2);
};

emptymrow: EMPTYMROW {
  $$ = itex2MML_copy_string("<mrow></mrow>");
};

space: SPACE ST INTONE END ST INTTWO END ST INTTHREE END {
  char * s1 = itex2MML_copy3("<mspace height=\"", $3, "ex\" depth=\"");
  char * s2 = itex2MML_copy3($6, "ex\" width=\"", $9);
  $$ = itex2MML_copy3(s1, s2, "em\"/>");
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string($3);
  itex2MML_free_string($6);
  itex2MML_free_string($9);
};

statusline: STATLINE TEXTSTRING closedTerm {
  char * s1 = itex2MML_copy3("<maction actiontype=\"statusline\">", $3, "<mtext>");
  $$ = itex2MML_copy3(s1, $2, "</mtext></maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

toggle: TOGGLE closedTerm closedTerm closedTerm closedTerm {
  char * s1 = itex2MML_copy3("<maction actiontype=\"toggle\" selection=\"2\">", $2, " ");
  $$ = itex2MML_copy3(s1, $3, "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
  itex2MML_free_string($4);
  itex2MML_free_string($5);
};

fghighlight: FGHIGHLIGHT ATTRLIST closedTerm {
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='color=", $2, "'>");
  $$ = itex2MML_copy3(s1, $3, "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

bghighlight: BGHIGHLIGHT ATTRLIST closedTerm {
  char * s1 = itex2MML_copy3("<maction actiontype=\"highlight\" other='background=", $2, "'>");
  $$ = itex2MML_copy3(s1, $3, "</maction>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

textstring: TEXTBOX TEXTSTRING {
  $$ = itex2MML_copy3("<mtext>", $2, "</mtext>");
  itex2MML_free_string($2);
};

displaystyle: DISPLAY closedTerm {
  $$ = itex2MML_copy3("<mstyle displaystyle=\"true\">", $2, "</mstyle>");
  itex2MML_free_string($2);
};

textstyle: TEXTSTY closedTerm {
  $$ = itex2MML_copy3("<mstyle displaystyle=\"false\">", $2, "</mstyle>");
  itex2MML_free_string($2);
};

textsize: TEXTSIZE closedTerm {
  $$ = itex2MML_copy3("<mstyle scriptlevel=\"0\">", $2, "</mstyle>");
  itex2MML_free_string($2);
};

scriptsize: SCSIZE closedTerm {
  $$ = itex2MML_copy3("<mstyle scriptlevel=\"1\">", $2, "</mstyle>");
  itex2MML_free_string($2);
};

scriptscriptsize: SCSCSIZE closedTerm {
  $$ = itex2MML_copy3("<mstyle scriptlevel=\"2\">", $2, "</mstyle>");
  itex2MML_free_string($2);
};

italics: ITALICS closedTerm {
  $$ = itex2MML_copy3("<mstyle fontstyle=\"italic\">", $2, "</mstyle>");
  itex2MML_free_string($2);
};

bold: BOLD closedTerm {
  $$ = itex2MML_copy3("<mstyle fontweight=\"bold\">", $2, "</mstyle>");
  itex2MML_free_string($2);
};

roman: RM closedTerm {
  $$ = itex2MML_copy3("<mstyle fontstyle=\"normal\" fontweight=\"normal\">", $2, "</mstyle>");
  itex2MML_free_string($2);
};

bbold: BB ST bbletters END {
  $$ = itex2MML_copy3("<mi>", $3, "</mi>");
  itex2MML_free_string($3);
};

bbletters: bbletter {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| bbletters bbletter {
  $$ = itex2MML_copy2($1, $2);
  itex2MML_free_string($1);
  itex2MML_free_string($2);
};

bbletter: BBLOWERCHAR {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| BBUPPERCHAR {
  $$ = itex2MML_copy3("&", $1, "opf;");
  itex2MML_free_string($1);
};

frak: FRAK ST frakletters END {
  $$ = itex2MML_copy3("<mi>", $3, "</mi>");
  itex2MML_free_string($3);
};

frakletters: frakletter {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| frakletters frakletter {
  $$ = itex2MML_copy2($1, $2);
  itex2MML_free_string($1);
  itex2MML_free_string($2);
};

frakletter: FRAKCHAR {
  $$ = itex2MML_copy3("&", $1, "fr;");
  itex2MML_free_string($1);
};

cal: CAL ST calletters END {
  $$ = itex2MML_copy3("<mi>", $3, "</mi>");
  itex2MML_free_string($3);
};

calletters: calletter {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| calletters calletter {
  $$ = itex2MML_copy2($1, $2);
  itex2MML_free_string($1);
  itex2MML_free_string($2);
};

calletter: CALCHAR {
  $$ = itex2MML_copy3("&", $1, "scr;");
  itex2MML_free_string($1);
};

thinspace: THINSPACE {
  $$ = itex2MML_copy_string("<mspace width=\"thinmathspace\"/>");
};

medspace: MEDSPACE {
  $$ = itex2MML_copy_string("<mspace width=\"mediummathspace\"/>");
};

thickspace: THICKSPACE {
  $$ = itex2MML_copy_string("<mspace width=\"thickmathspace\"/>");
};

quad: QUAD {
  $$ = itex2MML_copy_string("<mspace width=\"1em\"/>");
};

qquad: QQUAD {
  $$ = itex2MML_copy_string("<mspace width=\"2em\"/>");
};

negspace: NEGSPACE {
  $$ = itex2MML_copy_string("<mspace width=\"-0.1667 em\"/>");
};

phantom: PHANTOM closedTerm {
  $$ = itex2MML_copy3("<mphantom>", $2, "</mphantom>");
  itex2MML_free_string($2);
};

href: HREF TEXTSTRING closedTerm {
  char * s1 = itex2MML_copy3("<mrow xlink:type=\"simple\" xlink:show=\"replace\" xlink:href=\"", $2, "\">");
  $$ = itex2MML_copy3(s1, $3, "</mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

tensor: TENSOR closedTerm MROWOPEN subsupList MROWCLOSE {
  char * s1 = itex2MML_copy3("<mmultiscripts>", $2, $4);
  $$ = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($4);
}
| TENSOR closedTerm subsupList MROWCLOSE {
  char * s1 = itex2MML_copy3("<mmultiscripts>", $2, $3);
  $$ = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
}
| TENSOR closedTerm subsupList {
  char * s1 = itex2MML_copy3("<mmultiscripts>", $2, $3);
  $$ = itex2MML_copy2(s1, "</mmultiscripts>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

multi: MULTI MROWOPEN subsupList MROWCLOSE closedTerm MROWOPEN subsupList MROWCLOSE {
  char * s1 = itex2MML_copy3("<mmultiscripts>", $5, $7);
  char * s2 = itex2MML_copy3("<mprescripts/>", $3, "</mmultiscripts>");
  $$ = itex2MML_copy2(s1, s2);
  itex2MML_free_string(s1);
  itex2MML_free_string(s2);
  itex2MML_free_string($3);
  itex2MML_free_string($5);
  itex2MML_free_string($7);
};

subsupList: subsupTerm {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| subsupList subsupTerm {
  $$ = itex2MML_copy3($1, " ", $2);
  itex2MML_free_string($1);
  itex2MML_free_string($2);
};

subsupTerm: SUB closedTerm SUP closedTerm {
  $$ = itex2MML_copy3($2, " ", $4);
  itex2MML_free_string($2);
  itex2MML_free_string($4);
}
| SUB closedTerm {
  $$ = itex2MML_copy2($2, " <none/>");
  itex2MML_free_string($2);
}
| SUP closedTerm {
  $$ = itex2MML_copy2("<none/> ", $2);
  itex2MML_free_string($2);
};

mfrac: FRAC closedTerm closedTerm {
  char * s1 = itex2MML_copy3("<mfrac>", $2, $3);
  $$ = itex2MML_copy2(s1, "</mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

texover: compoundTermList TEXOVER compoundTermList {
  char * s1 = itex2MML_copy3("<mfrac><mrow>", $1, "</mrow><mrow>");
  $$ = itex2MML_copy3(s1, $3, "</mrow></mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string($1);
  itex2MML_free_string($3);
};

binom: BINOM closedTerm closedTerm {
  char * s1 = itex2MML_copy3("<mfrac linethickness=\"0\">", $2, $3);
  $$ = itex2MML_copy2(s1, "</mfrac>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

munderbrace: UNDERBRACE closedTerm {
  $$ = itex2MML_copy3("<munder>", $2, "<mo>&UnderBrace;</mo></munder>");
  itex2MML_free_string($2);
};

moverbrace: OVERBRACE closedTerm {
  $$ = itex2MML_copy3("<mover>", $2, "<mo>&OverBrace;</mo></mover>");
  itex2MML_free_string($2);
};

bar: BAR closedTerm {
  $$ = itex2MML_copy3("<mover>", $2, "<mo>&OverBar;</mo></mover>");
  itex2MML_free_string($2);
};

vec: VEC closedTerm {
  $$ = itex2MML_copy3("<mover>", $2, "<mo>&RightVector;</mo></mover>");
  itex2MML_free_string($2);
};

dot: DOT closedTerm {
  $$ = itex2MML_copy3("<mover>", $2, "<mo>&dot;</mo></mover>");
  itex2MML_free_string($2);
};

ddot: DDOT closedTerm {
  $$ = itex2MML_copy3("<mover>", $2, "<mo>&Dot;</mo></mover>");
  itex2MML_free_string($2);
};

tilde: TILDE closedTerm {
  $$ = itex2MML_copy3("<mover>", $2, "<mo>&tilde;</mo></mover>");
  itex2MML_free_string($2);
};

check: CHECK closedTerm {
  $$ = itex2MML_copy3("<mover>", $2, "<mo>&macr;</mo></mover>");
  itex2MML_free_string($2);
};

hat: HAT closedTerm {
  $$ = itex2MML_copy3("<mover>", $2, "<mo>&Hat;</mo></mover>");
  itex2MML_free_string($2);
};

msqrt: SQRT closedTerm {
  $$ = itex2MML_copy3("<msqrt>", $2, "</msqrt>");
  itex2MML_free_string($2);
};

mroot: ROOT closedTerm closedTerm {
  char * s1 = itex2MML_copy3("<mroot>", $3, $2);
  $$ = itex2MML_copy2(s1, "</mroot>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

munder: UNDER closedTerm closedTerm {
  char * s1 = itex2MML_copy3("<munder>", $3, $2);
  $$ = itex2MML_copy2(s1, "</munder>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

mover: OVER closedTerm closedTerm {
  char * s1 = itex2MML_copy3("<mover>", $3, $2);
  $$ = itex2MML_copy2(s1, "</mover>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
};

munderover: UNDEROVER closedTerm closedTerm closedTerm {
  char * s1 = itex2MML_copy3("<munderover>", $4, $2);
  $$ = itex2MML_copy3(s1, $3, "</munderover>");
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
  itex2MML_free_string($3);
  itex2MML_free_string($4);
};

array: ARRAY MROWOPEN tableRowList MROWCLOSE {
  $$ = itex2MML_copy3("<mrow><mtable>", $3, "</mtable></mrow>");
  itex2MML_free_string($3);
}
| ARRAY MROWOPEN ARRAYOPTS MROWOPEN arrayopts MROWCLOSE tableRowList MROWCLOSE {
  char * s1 = itex2MML_copy3("<mrow><mtable ", $5, ">");
  $$ = itex2MML_copy3(s1, $7, "</mtable></mrow>");
  itex2MML_free_string(s1);
  itex2MML_free_string($5);
  itex2MML_free_string($7);
};

arrayopts: anarrayopt {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| arrayopts anarrayopt {
  $$ = itex2MML_copy3($1, " ", $2);
  itex2MML_free_string($1);
  itex2MML_free_string($2);
};

anarrayopt: collayout {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| colalign {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| rowalign {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| align {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| eqrows {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| eqcols {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| rowlines {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| collines {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| frame {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| padding {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
};

collayout: COLLAYOUT ATTRLIST {
  $$ = itex2MML_copy2("columnalign=", $2);
  itex2MML_free_string($2);
};

colalign: COLALIGN ATTRLIST {
  $$ = itex2MML_copy2("columnalign=", $2);
  itex2MML_free_string($2);
};

rowalign: ROWALIGN ATTRLIST {
  $$ = itex2MML_copy2("rowalign=", $2);
  itex2MML_free_string($2);
};

align: ALIGN ATTRLIST {
  $$ = itex2MML_copy2("align=", $2);
  itex2MML_free_string($2);
};

eqrows: EQROWS ATTRLIST {
  $$ = itex2MML_copy2("equalrows=", $2);
  itex2MML_free_string($2);
};

eqcols: EQCOLS ATTRLIST {
  $$ = itex2MML_copy2("equalcolumns=", $2);
  itex2MML_free_string($2);
};

rowlines: ROWLINES ATTRLIST {
  $$ = itex2MML_copy2("rowlines=", $2);
  itex2MML_free_string($2);
};

collines: COLLINES ATTRLIST {
  $$ = itex2MML_copy2("columnlines=", $2);
  itex2MML_free_string($2);
};

frame: FRAME ATTRLIST {
  $$ = itex2MML_copy2("frame=", $2);
  itex2MML_free_string($2);
};

padding: PADDING ATTRLIST {
  char * s1 = itex2MML_copy3("rowspacing=", $2, " columnspacing=");
  $$ = itex2MML_copy2(s1, $2);
  itex2MML_free_string(s1);
  itex2MML_free_string($2);
};

tableRowList: tableRow {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| tableRowList ROWSEP tableRow {
  $$ = itex2MML_copy3($1, " ", $3);
  itex2MML_free_string($1);
  itex2MML_free_string($3);
};

tableRow: simpleTableRow {
  $$ = itex2MML_copy3("<mtr>", $1, "</mtr>");
  itex2MML_free_string($1);
}
| optsTableRow {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
};

simpleTableRow: tableCell {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| simpleTableRow COLSEP tableCell {
  $$ = itex2MML_copy3($1, " ", $3);
  itex2MML_free_string($1);
  itex2MML_free_string($3);
};

optsTableRow: ROWOPTS MROWOPEN rowopts MROWCLOSE simpleTableRow {
  char * s1 = itex2MML_copy3("<mtr ", $3, ">");
  $$ = itex2MML_copy3(s1, $5, "</mtr>");
  itex2MML_free_string(s1);
  itex2MML_free_string($3);
  itex2MML_free_string($5);
};

rowopts: arowopt {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| rowopts arowopt {
  $$ = itex2MML_copy3($1, " ", $2);
  itex2MML_free_string($1);
  itex2MML_free_string($2);
};

arowopt: colalign {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| rowalign {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
};

tableCell:   {
  $$ = itex2MML_copy_string("<mtd></mtd>");
}
| compoundTermList {
  $$ = itex2MML_copy3("<mtd>", $1, "</mtd>");
  itex2MML_free_string($1);
}
| CELLOPTS MROWOPEN cellopts MROWCLOSE compoundTermList {
  char * s1 = itex2MML_copy3("<mtd ", $3, ">");
  $$ = itex2MML_copy3(s1, $5, "</mtd>");
  itex2MML_free_string(s1);
  itex2MML_free_string($3);
  itex2MML_free_string($5);
};

cellopts: acellopt {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| cellopts acellopt {
  $$ = itex2MML_copy3($1, " ", $2);
  itex2MML_free_string($1);
  itex2MML_free_string($2);
};

acellopt: colalign {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| rowalign {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| rowspan {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
}
| colspan {
  $$ = itex2MML_copy_string($1);
  itex2MML_free_string($1);
};

rowspan: ROWSPAN ATTRLIST {
  $$ = itex2MML_copy2("rowspan=", $2);
  itex2MML_free_string($2);
};

colspan: COLSPAN ATTRLIST {
  $$ = itex2MML_copy2("colspan=", $2);
  itex2MML_free_string($2);
};

%%
