%{
%}
%option noyywrap
%x MATH ATTRIBUTELIST BBOLD FRAKTUR CALLIGRAPHIC PLAINTEXT INT1 INT2 INT3 
%{
#include <string.h>

#include "y.tab.h"

#define yylval itex2MML_yylval

extern char * yylval;

extern char * itex2MML_empty_string;

extern char * itex2MML_copy_string (const char * str);
extern char * itex2MML_copy_string_extra (const char * str, unsigned extra);
extern char * itex2MML_copy2 (const char * first, const char * second);
extern char * itex2MML_copy3 (const char * first, const char * second, const char * third);

int itex2MML_lineno = 1;

int itex2MML_rowposn = 0;
int itex2MML_displaymode = 0;
%} 
%%
%{ if (itex2MML_rowposn==1) itex2MML_rowposn=0;
   if (itex2MML_rowposn==2) itex2MML_rowposn=1;
%}

<INITIAL>"$"{1,2}   BEGIN(MATH); itex2MML_rowposn=2; if (yyleng==2) { itex2MML_displaymode=1; return STARTDMATH;}; itex2MML_displaymode=0; return STARTMATH;
<INITIAL>"\\[" BEGIN(MATH); itex2MML_rowposn=2; itex2MML_displaymode=1; return STARTDMATH;
<INITIAL>EOF    return 0;
<INITIAL>"\n" {itex2MML_lineno++; yylval=itex2MML_copy_string(yytext); return CHAR;}
<INITIAL>.     {yylval=itex2MML_copy_string(yytext); return CHAR;}


<MATH>{



"$"{1,2} |
"\\]"           {BEGIN(INITIAL); return ENDMATH;}

"^"            return SUP;
"_"            return SUB; 
"{"[\t\r\n ]*"}"   return EMPTYMROW;
"{"            {itex2MML_rowposn = 2; return MROWOPEN;}
"}"            return MROWCLOSE;

"\\left"       itex2MML_rowposn=2; return LEFT;
"\\right"      return RIGHT;


"\\rlap" |
"\\llap" |
"\\ulap" |
"\\dlap"               {/* Ignore */ ;}


"&amp;" |
"&"         {itex2MML_rowposn=2; return COLSEP;}

"\\&"           {yylval=itex2MML_copy_string("&amp;"); return MI;}

"\\$"           {yylval=itex2MML_copy_string("$"); return MI;}
"\\%"           {yylval=itex2MML_copy_string("%"); return MI;}

"\\\\"          itex2MML_rowposn=2; return ROWSEP;

[a-zA-Z]+       {yylval=itex2MML_copy_string(yytext); return MI;}

[0-9]+          {yylval=itex2MML_copy2(yytext, " "); return MN;}
"\\infty"   |
"\\infinity"     {yylval=itex2MML_copy_string("&infin;"); return MN;}

"-"    {if (itex2MML_rowposn==1) return UNARYMINUS; else {yylval=itex2MML_copy_string(yytext); return MO;}}


"("   |
"["   |
"+"   |
"."   |
","   |
"/"   |
":"   |
"!"   |
"="   |
"~"   |
";"   |
"'"   |
"?"   |
"#"   |
"`"   |
"*"        {yylval=itex2MML_copy_string(yytext); return MOL;}

")"   |
"]"        {yylval=itex2MML_copy_string(yytext); return MO;}

"|"        {yylval=itex2MML_copy_string("&VerticalBar;"); return MONS;}

"\\alpha"   |
"\\beta" |
"\\gamma" |
"\\delta" |
"\\zeta" |
"\\eta"  |
"\\theta" |
"\\iota"  |
"\\kappa" |
"\\lambda" |
"\\mu"     |
"\\nu"    |
"\\xi"   |
"\\pi"     |
"\\rho"   |
"\\sigma"  |
"\\tau"   |
"\\upsilon" |
"\\chi"  |
"\\psi"  |
"\\omega" |
"\\varepsilon" |
"\\varkappa" |
"\\varpi" |
"\\varrho" |
"\\varsigma" |
"\\vartheta"      {yylval=itex2MML_copy2(yytext, ";"); if (yylval != itex2MML_empty_string) yylval[0]='&'; return MI;}

"\\phi"  {yylval=itex2MML_copy_string("&#x03D5;"); return MI;}
"\\varphi"  {yylval=itex2MML_copy_string("&#x03C6;"); return MI;}

"\\arccos"  |
"\\arcsin"  |
"\\arctan"  |
"\\arg"     |
"\\cos"     |
"\\cosh"    |
"\\cot"     |
"\\coth"    |
"\\csc"     |
"\\deg"     |
"\\det"     |
"\\dim"     |
"\\exp"     |
"\\gcd"     |
"\\hom"     |
"\\inf"     |
"\\ker"     |
"\\lg"      |
"\\lim"     |
"\\liminf"  |
"\\limsup"  |
"\\ln"      |
"\\log"     |
"\\max"     |
"\\min"     |
"\\Pr"      |
"\\sec"     |
"\\sin"     |
"\\sinh"    |
"\\sup"     |
"\\tan"     |
"\\tanh"    {yylval=itex2MML_copy_string(yytext+1); return MI;}

"\\omicron"  {yylval=itex2MML_copy_string("&oscr;"); return MI;}

"\\epsilon"  {yylval=itex2MML_copy_string("&epsi;"); return MI;}

"\\cdot"   {yylval=itex2MML_copy_string("&sdot;"); return MO;}

"\\Alpha"   |
"\\Beta" |
"\\Delta"  |
"\\Gamma"  |
"\\digamma"  |
"\\Lambda" |
"\\Pi"     |
"\\Phi"    |
"\\Psi"    |
"\\Sigma"  |
"\\Theta"  |
"\\Xi"     |
"\\Zeta" |
"\\Eta"  |
"\\Iota"  |
"\\Kappa" |
"\\Mu"     |
"\\Nu"    |
"\\Rho"   |
"\\Tau"  | 
"\\mho"  | 
"\\Omega"     {yylval=itex2MML_copy2(yytext, ";"); if (yylval != itex2MML_empty_string) yylval[0]='&'; return MI;}

"\\Upsilon" |
"\\Upsi" {yylval=itex2MML_copy_string("&Upsi;"); return MI;}

"\\iff" |
"\\Longleftrightarrow"  {yylval=itex2MML_copy_string("&iff;"); return MOL;}

"\\Leftrightarrow"  {yylval=itex2MML_copy_string("&Leftrightarrow;"); return MOL;}

"\\impliedby" |
"\\Leftarrow"   {yylval=itex2MML_copy_string("&Leftarrow;"); return MOL;}

"\\implies" |
"\\Rightarrow"   {yylval=itex2MML_copy_string("&Rightarrow;"); return MOL;}

"\\hookleftarrow" {yylval=itex2MML_copy_string("&hookleftarrow;"); return MOL;}

"\\embedsin" |
"\\hookrightarrow"  {yylval=itex2MML_copy_string("&hookrightarrow;"); return MOL;}

"\\longleftarrow"   {yylval=itex2MML_copy_string("&longleftarrow;"); return MOL;}

"\\longrightarrow"  {yylval=itex2MML_copy_string("&longrightarrow;"); return MOL;}

"\\leftarrow"   {yylval=itex2MML_copy_string("&leftarrow;"); return MOL;}

"\\to"    |
"\\rightarrow"  {yylval=itex2MML_copy_string("&rightarrow;"); return MOL;}

"\\leftrightarrow"  {yylval=itex2MML_copy_string("&leftrightarrow;"); return MOL;}

"\\mapsto"  |
"\\map"       {yylval=itex2MML_copy_string("&map;"); return MOL;}

"\\nearrow" |
"\\nearr"    {yylval=itex2MML_copy_string("&nearr;"); return MOL;}

"\\nwarrow" |
"\\nwarr"     {yylval=itex2MML_copy_string("&nwarr;"); return MOL;}

"\\searrow" |
"\\searr"     {yylval=itex2MML_copy_string("&searr;"); return MOL;}

"\\swarrow" |
"\\swarr"     {yylval=itex2MML_copy_string("&swarr;"); return MOL;}

"\\neArrow" |
"\\neArr"    {yylval=itex2MML_copy_string("&neArr;"); return MOL;}

"\\nwArrow" |
"\\nwArr"     {yylval=itex2MML_copy_string("&nwArr;"); return MOL;}

"\\seArrow" |
"\\seArr"     {yylval=itex2MML_copy_string("&seArr;"); return MOL;}

"\\swArrow" |
"\\swArr"     {yylval=itex2MML_copy_string("&swArr;"); return MOL;}

"\\downarrow" |
"\\darr"     {yylval=itex2MML_copy_string("&darr;"); return MOL;}

"\\Downarrow" {yylval=itex2MML_copy_string("&dArr;"); return MOL;}

"\\uparrow" |
"\\uparr"    {yylval=itex2MML_copy_string("&uarr;"); return MOL;}

"\\Uparrow" {yylval=itex2MML_copy_string("&uArr;"); return MOL;}

"\\downuparrow" |
"\\updownarrow" |
"\\duparr" |
"\\updarr"  {yylval=itex2MML_copy_string("&updownarrow;"); return MOL;}

"\\Updownarrow"  {yylval=itex2MML_copy_string("&Updownarrow;"); return MOL;}

"\\dots" |
"\\ldots"  {yylval=itex2MML_copy_string("&hellip;"); return MO;}
"\\cdots"   {yylval=itex2MML_copy_string("&ctdot;"); return MO;}
"\\ddots"   {yylval=itex2MML_copy_string("&dtdot;"); return MO;}
"\\udots"   {yylval=itex2MML_copy_string("&utdot;"); return MO;}
"\\vdots"   {yylval=itex2MML_copy_string("&vellip;"); return MO;}

"\\cup"  |
"\&union;" |
"\\union"          {yylval=itex2MML_copy_string("&cup;"); return MOL;}

"\\bigcup" |
"\\Union"  |
"\&Union;"      {yylval=itex2MML_copy_string("&Union;"); return MOB;}

"\\cap"  |
"\\intersection"          {yylval=itex2MML_copy_string("&cap;"); return MOL;}

"\\bigcap" |
"\\Intersection"       {yylval=itex2MML_copy_string("&Intersection;"); return MOB;}

"\\lbrace" |
"\\{"            {yylval=itex2MML_copy_string("{"); return MOL;}
"\\rbrace" |
"\\}"            {yylval=itex2MML_copy_string("}"); return MO;}




"\\in"           {yylval=itex2MML_copy_string("&Element;"); return MOL;}

"\\|"      {yylval=itex2MML_copy_string("&DoubleVerticalBar;"); return MOL;}

"\\rfloor" |
"\\rceil"  |
"\\rang"   |
"\\rangle"  {yylval=itex2MML_copy2(yytext, ";"); if (yylval != itex2MML_empty_string) yylval[0]='&'; return MO;}


"\\lfloor" |
"\\lceil" |
"\\lang" |
"\\langle" |
"\\gt"   |
"\\lt"   |
"\\approxeq"   |
"\\backepsilon"   |
"\\backsim"   |
"\\backsimeq"   |
"\\subset"  |
"\\subseteq" |
"\\subseteqq" |
"\\subsetneq" |
"\\subsetneqq" |
"\\varsubsetneq" |
"\\varsubsetneqq" |
"\\prec"     |
"\\parallel"  |
"\\nparallel" |
"\\shortparallel" |
"\\nshortparallel" |
"\\perp"  |
"\\eqslantgtr" |
"\\eqslantless" |
"\\gg" |
"\\ggg" |
"\\geq" |
"\\geqq" |
"\\geqslant" |
"\\gneq" |
"\\gneqq" |
"\\gnapprox" |
"\\gnsim" |
"\\gtrapprox" |
"\\ge"  |
"\\le"  |
"\\leq" |
"\\leqq" |
"\\leqslant" |
"\\lessapprox" |
"\\lessdot" |
"\\lesseqgtr" |
"\\lesseqqgtr" |
"\\lessgtr" |
"\\lneq" |
"\\lneqq" |
"\\lnsim" |
"\\lvertneqq" |
"\\gtrsim" |
"\\gtrdot" |
"\\gtreqless" |
"\\gtreqqless" |
"\\gtrless" |
"\\gvertneqq" |
"\\lesssim" |
"\\lnapprox" |
"\\nsubset" |
"\\nsubseteq" |
"\\nsubseteqq" |
"\\notin" |
"\\ni" |
"\\notni" |
"\\nmid" |
"\\nshortmid" |
"\\preceq" |
"\\npreceq" |
"\\ll" |
"\\ngeq" |
"\\ngeqq" |
"\\ngeqslant" |
"\\nleq" |
"\\nleqq" |
"\\nleqslant" |
"\\nless" |
"\\supset" |
"\\supseteq" |
"\\supseteqq" |
"\\supsetneq" |
"\\supsetneqq" |
"\\varsupsetneq" |
"\\varsupsetneqq" |
"\\approx" |
"\\asymp" |
"\\bowtie" |
"\\dashv" |
"\\Vdash" |
"\\vDash" |
"\\vdash" |
"\\Vvdash" |
"\\models" |
"\\sim" |
"\\simeq" |
"\\nsim" |
"\\smile" |
"\\triangle" |
"\\triangledown" |
"\\triangleleft" |
"\\cong" |
"\\succ" |
"\\nsucc" |
"\\ngtr" |
"\\nsupset" |
"\\nsupseteq" |
"\\propto" |
"\\equiv" |
"\\frown" |
"\\triangleright" |
"\\ncong" |
"\\succeq" |
"\\succapprox" |
"\\succnapprox" |
"\\succcurlyeq" |
"\\succsim" |
"\\succnsim" |
"\\nsucceq" |
"\\nvDash" |
"\\nvdash" |
"\\nVDash" |
"\\amalg" |
"\\setminus" |
"\\smallsetminus" |
"\\pm" |
"\\mp" |
"\\bigcirc" |
"\\wr" |
"\\odot" |
"\\uplus" |
"\\clubsuit" |
"\\spadesuit" |
"\\Diamond" |
"\\diamond" |
"\\sqcup" |
"\\sqcap" |
"\\sqsubset" |
"\\sqsubseteq" |
"\\sqsupset" |
"\\sqsupseteq" |
"\\Subset" |
"\\Supset" |
"\\ltimes" |
"\\div" |
"\\rtimes" |
"\\Im" |
"\\bot" |
"\\prime" |
"\\therefore" |
"\\thickapprox" |
"\\thicksim" |
"\\varpropto" |
"\\varnothing" |
"\\flat" |
"\\vee" |
"\\Re" |
"\\hbar" |
"\\because" |
"\\between" |
"\\Bumpeq" |
"\\bumpeq" |
"\\circeq" |
"\\curlyeqprec" |
"\\curlyeqsucc" |
"\\doteq" |
"\\doteqdot" |
"\\eqcirc" |
"\\fallingdotseq" |
"\\multimap" |
"\\pitchfork" |
"\\precapprox" |
"\\precnapprox" |
"\\preccurlyeq" |
"\\precsim" |
"\\precnsim" |
"\\risingdotseq" |
"\\sharp" |
"\\bullet" |
"\\aleph" |
"\\nexists" |
"\\dagger" |
"\\ddagger" |
"\\not" |
"\\top" |
"\\wp" |
"\\natural" |
"\\square" |
"\\angle" |
"\\measuredangle" |
"\\backprime" |
"\\bigstar" |
"\\blacklozenge" |
"\\lozenge" |
"\\blacksquare" |
"\\blacktriangle" |
"\\blacktriangledown" |
"\\forall" |
"\\ell" |
"\\eth" |
"\\bigtriangleup" |
"\\bigtriangledown" |
"\\imath" |
"\\jmath" |
"\\beth" |
"\\nprec"  {yylval=itex2MML_copy2(yytext, ";"); if (yylval != itex2MML_empty_string) yylval[0]='&'; return MOL;}

"\\emptyset" |
"\\empty" {yylval=itex2MML_copy_string("&emptyv;"); return MOL;}
"\\exists" {yylval=itex2MML_copy_string("&Exists;"); return MOL;}
"\\circ" {yylval=itex2MML_copy_string("&SmallCircle;"); return MOL;}
"\\rhd" {yylval=itex2MML_copy_string("&RightTriangle;"); return MOL;}
"\\lhd" {yylval=itex2MML_copy_string("&LeftTriangle;"); return MOL;}
"\\lll" {yylval=itex2MML_copy_string("&Ll;"); return MOL;}
"\\unrhd" {yylval=itex2MML_copy_string("&RightTriangleEqual;"); return MOL;}
"\\unlhd" {yylval=itex2MML_copy_string("&LeftTriangleEqual;"); return MOL;}
"\\Del" |
"\\nabla" {yylval=itex2MML_copy_string("&Del;"); return MOL;}
"\\sphericalangle" {yylval=itex2MML_copy_string("&angsph;"); return MOL;}

"\\heartsuit" {yylval=itex2MML_copy_string("&#x2661;"); return MOL;}
"\\diamondsuit" {yylval=itex2MML_copy_string("&#x2662;"); return MOL;}

"\\partial" {yylval=itex2MML_copy_string("&PartialD;"); return MOL;}

"\\qed" {yylval=itex2MML_copy_string("&squf;"); return MO;}

"\\pmod" {yylval=itex2MML_copy_string("&nbsp; mod "); return MO;}

"\\bottom" {yylval=itex2MML_copy_string("&perp;"); return MOL;}

"\\neg" {yylval=itex2MML_copy_string("&not;"); return MOL;}

"\\neq" |
"\\ne"   {yylval=itex2MML_copy_string("&ne;"); return MOL;}

"\\shortmid" |
"\\mid"  {yylval=itex2MML_copy_string("&VerticalBar;"); return MOS;}

"\\int"    |
"\\integral"     {yylval=itex2MML_copy_string("&Integral;"); return MOL;}

"\\iint"   |
"\\doubleintegral" {yylval=itex2MML_copy_string("&Int;"); return MOL;}

"\\iiint"   |
"\\tripleintegral" {yylval=itex2MML_copy_string("&tint;"); return MOL;}

"\\iiiint"   |
"\\quadrupleintegral" {yylval=itex2MML_copy_string("&qint;"); return MOL;}

"\\oint"    |
"\\conint"  |
"\\contourintegral"   {yylval=itex2MML_copy_string("&conint;"); return MOL;}

"\\times"   {yylval=itex2MML_copy_string("&times;"); return MOL;}
"\\star"   {yylval=itex2MML_copy_string("&sstarf;"); return MOL;}
"\\circleddash" |
"\\odash"   {yylval=itex2MML_copy_string("&odash;"); return MOL;}

"\\boxminus" |
"\\minusb"   {yylval=itex2MML_copy_string("&boxminus;"); return MOL;}
"\\boxplus" |
"\\plusb"   {yylval=itex2MML_copy_string("&boxplus;"); return MOL;}
"\\boxtimes" |
"\\timesb"   {yylval=itex2MML_copy_string("&boxtimes;"); return MOL;}

"\\sum"          {yylval=itex2MML_copy_string("&Sum;"); return MOB;}

"\\prod" |
"\\product"      {yylval=itex2MML_copy_string("&prod;"); return MOB;}

"\\coprod"  |
"\\coproduct"    {yylval=itex2MML_copy_string("&coprod;"); return MOB;}

"\\otimes"       {yylval=itex2MML_copy_string("&otimes;"); return MOL;}
"\\Otimes"       {yylval=itex2MML_copy_string("&Otimes;"); return MOL;}
"\\bigotimes"     {yylval=itex2MML_copy_string("&bigotimes;"); return MOL;}


"\\oplus"       {yylval=itex2MML_copy_string("&oplus;"); return MOL;}
"\\Oplus"   |
"\\bigoplus"    {yylval=itex2MML_copy_string("&bigoplus;"); return MOB;}

"\\bigodot"    {yylval=itex2MML_copy_string("&bigodot;"); return MOB;}
"\\bigsqcup"    {yylval=itex2MML_copy_string("&bigsqcup;"); return MOB;}
"\\bigsuplus"    {yylval=itex2MML_copy_string("&biguplus;"); return MOB;}

"\\wedge"       {yylval=itex2MML_copy_string("&wedge;"); return MOL;}
"\\Wedge"  |
"\\bigwedge"       {yylval=itex2MML_copy_string("&xwedge;"); return MOB;}

"\\Vee"  |
"\\bigvee"       {yylval=itex2MML_copy_string("&bigvee;"); return MOB;}

"\\frac"         {return FRAC;}

"\\binom"        {return BINOM;}

"\\tensor"       {return TENSOR;}

"\\multiscripts" {return MULTI;}

"\\overbrace"     {return OVERBRACE;}

"\\underbrace"   {return UNDERBRACE;}

"\\overline" |
"\\closure" |
"\\bar" |
"\\widebar"      {return BAR;}

"\\vec"  |
"\\widevec"   {return VEC;}

"\\dot"       {return DOT;}

"\\ddot"      {return DDOT;}

"\\tilde"  |
"\\widetilde"   {return TILDE;}


"\\check"  |
"\\widecheck"   {return CHECK;}


"\\hat"  |
"\\widehat"   {return HAT;}

"\\underset"     {return UNDER;}

"\\overset"      {return OVER;}

"\\over"         {return TEXOVER;}

"\\underoverset"  {return UNDEROVER;}

"\\sqrt"         {return SQRT;}

"\\root"         {return ROOT;}

"\\space"        {BEGIN(INT1); return SPACE;}

"\\text"          {BEGIN(PLAINTEXT); return TEXTBOX;}

"\\statusline"    {BEGIN(PLAINTEXT); return STATLINE;}

"\\toggle"        {return TOGGLE;}

"\\fghilight" |
"\\fghighlight"   {BEGIN(ATTRIBUTELIST); return FGHIGHLIGHT;}

"\\bghilight" |
"\\bghighlight"   {BEGIN(ATTRIBUTELIST); return BGHIGHLIGHT;}


"\\displaystyle"  {itex2MML_rowposn=2; return DISPLAY;}

"\\textstyle"     {itex2MML_rowposn=2; return TEXTSTY;}

"\\textsize"     {return TEXTSIZE;}

"\\scriptsize"     {return SCSIZE;}

"\\scriptscriptsize"     {return SCSCSIZE;}

"\\mathit"       {return ITALICS;}

"\\mathbf"       {return BOLD;}

"\\mathrm"       {return RM;}

"\\mathbb"       {BEGIN(BBOLD); return BB;}

"\\mathfrak" |
"\\mathfr"       {BEGIN(FRAKTUR); return FRAK;}

"\\mathcal"       {BEGIN(CALLIGRAPHIC); return CAL;}

"\\array"        {return ARRAY;}

"\\arrayopts"    {return ARRAYOPTS;}

"\\colalign"     {BEGIN(ATTRIBUTELIST); return COLALIGN;}

"\\collayout"   {BEGIN(ATTRIBUTELIST); return COLLAYOUT;}

"\\rowalign"     {BEGIN(ATTRIBUTELIST); return ROWALIGN;}

"\\align"     {BEGIN(ATTRIBUTELIST); return ALIGN;}

"\\equalrows"     {BEGIN(ATTRIBUTELIST); return EQROWS;}

"\\equalcols"     {BEGIN(ATTRIBUTELIST); return EQCOLS;}

"\\rowlines"     {BEGIN(ATTRIBUTELIST); return ROWLINES;}

"\\collines"     {BEGIN(ATTRIBUTELIST); return COLLINES;}

"\\frame"     {BEGIN(ATTRIBUTELIST); return FRAME;}

"\\padding"     {BEGIN(ATTRIBUTELIST); return PADDING;}

"\\rowopts"    {return ROWOPTS;}

"\\cellopts"   {return CELLOPTS;} 

"\\rowspan"     {BEGIN(ATTRIBUTELIST); return ROWSPAN;}

"\\colspan"     {BEGIN(ATTRIBUTELIST); return COLSPAN;}


"\\," |
"\\thinspace"   {return THINSPACE;}

"\\:" |
"\\medspace"    {return MEDSPACE;}

"\\;" |
"\\thickspace"  {return THICKSPACE;}

"\\quad"        {return QUAD;}
"\\qquad"       {return QQUAD;}

"\\!" |
"\\negspace"    {return NEGSPACE;}

"\\phantom"     {return PHANTOM;}

"\\href"        {BEGIN(PLAINTEXT); return HREF;}


"\\mathop"       {BEGIN(PLAINTEXT); return MATHOP;}

"\\"[a-zA-Z]+    {yylval=itex2MML_copy_string(yytext+1); return MOP;}

"\&#"[0-9]+";" |
"\&#x"[a-fA-F0-9]+";"  {yylval=itex2MML_copy_string(yytext); return MI;}

"\n"             itex2MML_lineno++;
[\t ]+           ;


.              {return UNKNOWNCHAR;}
}

<ATTRIBUTELIST>"{"[ \t\n\r #a-zA-Z0-9.\-]*"}"  {BEGIN(MATH); yylval=itex2MML_copy_string(yytext); if (yylval != itex2MML_empty_string) { yylval[0]='"'; yylval[yyleng-1]='"'; } return ATTRLIST;}

<BBOLD>{
"\{"  {return ST;}
"\}"  {BEGIN(MATH); return END;}
[a-z] {yylval=itex2MML_copy_string(yytext); return BBLOWERCHAR;}
[A-Z]   {yylval=itex2MML_copy_string(yytext); return BBUPPERCHAR;}
[\t\n\r ]+       ;
.           {return yytext[0];}
}

<CALLIGRAPHIC>{
"\{"  {return ST;}
"\}"  {BEGIN(MATH); return END;}
[a-zA-Z]   {yylval=itex2MML_copy_string(yytext); return CALCHAR;}
[\t\n\r ]+       ;
.           {return yytext[0];}
}

<FRAKTUR>{
"\{"  {return ST;}
"\}"  {BEGIN(MATH); return END;}
[a-zA-Z]   {yylval=itex2MML_copy_string(yytext); return FRAKCHAR;}
[\t\n\r ]+       ;
.           {return yytext[0];}
}

<PLAINTEXT>{
\{[^\}]*\}  {yylval=itex2MML_copy_string(yytext+1); if ((yyleng > 1) && (yylval != itex2MML_empty_string)) yylval[yyleng-2]='\0'; BEGIN(MATH); return TEXTSTRING;}
}

<INT1>{ 
"\{"      {return ST;}
"\}"      {BEGIN(INT2); return END;}
[0-9]+    {yylval=itex2MML_copy_string_extra(yytext, 1); if (yyleng && (yylval != itex2MML_empty_string)) { yylval[yyleng]=yylval[yyleng-1]; yylval[yyleng-1]='.'; yylval[yyleng+1]='\0'; } return INTONE;}
[\t\n\r ]+   ;
.         {return yytext[0];}
}

<INT2>{
"\{"      {return ST;}
"\}"      {BEGIN(INT3); return END;}
[0-9]+    {yylval=itex2MML_copy_string_extra(yytext, 1); if (yyleng && (yylval != itex2MML_empty_string)) { yylval[yyleng]=yylval[yyleng-1]; yylval[yyleng-1]='.'; yylval[yyleng+1]='\0'; } return INTTWO;}
[\t\n\r ]+   ;
.         {return yytext[0];}
}

<INT3>{
"\{"      {return ST;}
"\}"      {BEGIN(MATH); return END;}
[0-9]+    {yylval=itex2MML_copy_string_extra(yytext, 1); if (yyleng && (yylval != itex2MML_empty_string)) { yylval[yyleng]=yylval[yyleng-1]; yylval[yyleng-1]='.'; yylval[yyleng+1]='\0'; } return INTTHREE;}
[\t\n\r ]+   ;
.         {return yytext[0];}
}



%%
