/* AbiSource
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

// Class definition include
#include "OD_Postpone_ListenerState.h"

// Internal includes
#include "OD_ListenerStateAction.h"

// AbiWord includes
#include <ut_assert.h>


/**
 * Constructor
 */
OD_Postpone_ListenerState::OD_Postpone_ListenerState(OD_ListenerState* pParserState)
                            : OD_ListenerState("Postpone"),
                              m_pParserState(pParserState),
                              m_elementStackCount(0)
{
    UT_ASSERT(m_pParserState);
}


/**
 * Destructor
 */
OD_Postpone_ListenerState::~OD_Postpone_ListenerState()
{
    UT_VECTOR_PURGEALL(XMLCall*, m_XMLCalls);
}


/**
 * 
 */
void OD_Postpone_ListenerState::startElement (const XML_Char* pName,
                                              const XML_Char** ppAtts,
                                              OD_ListenerStateAction& rAction) {

    StartElementCall* pCall;
    UT_uint32 i, count;
    
    pCall = new StartElementCall();
    
    pCall->m_pName = new XML_Char[strlen(pName)+1];
    strcpy(pCall->m_pName, pName);
    
    count=0;
    while (ppAtts[count] != 0) {
        count++;
    }

    pCall->m_ppAtts = new XML_Char*[count+1];
    pCall->m_ppAtts[count] = 0;
   
    for (i=0; i<count; i++) {
        pCall->m_ppAtts[i] = new XML_Char[strlen(ppAtts[i])+1];
        strcpy(pCall->m_ppAtts[i], ppAtts[i]);
    }

    m_XMLCalls.addItem(pCall);
    
    m_elementStackCount++;
}


/**
 * 
 */                        
void OD_Postpone_ListenerState::endElement (const XML_Char* pName,
                                            OD_ListenerStateAction& rAction) {
    
    EndElementCall* pCall;
    
    pCall = new EndElementCall();

    pCall->m_pName = new XML_Char[strlen(pName)+1];
    strcpy(pCall->m_pName, pName);
    
    m_XMLCalls.addItem(pCall);
    
    m_elementStackCount--;
    
    if (m_elementStackCount == 0) {
        rAction.popState();
    }
}


/**
 * 
 */                      
void OD_Postpone_ListenerState::charData (const XML_Char* pBuffer, int length) {
    CharDataCall* pCall;
    
    pCall = new CharDataCall();
    
    pCall->m_pBuffer = new XML_Char[length];
    memcpy(pCall->m_pBuffer, pBuffer, length);
    
    pCall->m_length = length;
    
    m_XMLCalls.addItem(pCall);
}
