/* AbiSource Program Utilities
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


// Class definition include
#include "OD_Style_MasterPage.h"
#include "OD_ListenerStateAction.h"

// AbiWord includes
#include <ut_assert.h>
#include <ut_misc.h>
#include <pd_Document.h>


/**
 * Constructor
 */
OD_Style_MasterPage::OD_Style_MasterPage(PD_Document* pDocument) :
                            OD_ListenerState("StyleMasterPage"),
                            m_pAbiDocument(pDocument),
                            m_pPageLayoutStyle(NULL),
                            m_postponedHeaderParsing(false),
                            m_postponedFooterParsing(false),
                            m_postponedHeaderLeftParsing(false),
                            m_postponedFooterLeftParsing(false)
{
}


/**
 * 
 */
void OD_Style_MasterPage::startElement(const XML_Char* pName,
                                       const XML_Char** ppAtts,
                                       OD_ListenerStateAction& rAction) {

    if (!UT_strcmp("style:master-page", pName)) {
        const XML_Char* pVal;

        pVal = UT_getAttribute ("style:name", ppAtts);
        UT_ASSERT(pVal);
        m_name = pVal;
        
        pVal = UT_getAttribute ("style:page-layout-name", ppAtts);
        UT_ASSERT(pVal);
        m_layoutName = pVal;
        
    } else if (!UT_strcmp("style:header", pName)) {
        
        if (m_postponedHeaderParsing) {
            
            const XML_Char* ppSecAttr[5];
            ppSecAttr[0] = "id";
            ppSecAttr[2] = "type";
            
            if (m_AW_evenHeaderSectionID.empty()) {
                ppSecAttr[1] = m_AW_headerSectionID.utf8_str();
                ppSecAttr[3] = "header";
            } else {
                ppSecAttr[1] = m_AW_evenHeaderSectionID.utf8_str();
                ppSecAttr[3] = "header-even";
            }
            
            ppSecAttr[4] = 0;
            
            m_pAbiDocument->appendStrux(PTX_Section, ppSecAttr);
            
            rAction.pushState("TextContent");
        
        } else {
            
            UT_uint32 id;
            char buffer[500];
            
            id = m_pAbiDocument->getUID(UT_UniqueId::HeaderFtr);
            sprintf(buffer, "%u", id);
            
            if (m_AW_headerSectionID.empty()) {
                m_AW_headerSectionID = buffer;
            } else {
                m_AW_evenHeaderSectionID = buffer;
            }
            
            rAction.postponeElementParsing(this, false);
            
            m_postponedHeaderParsing = true;
        }
    } else if (!UT_strcmp("style:footer", pName)) {
        
        if (m_postponedFooterParsing) {
            
            const XML_Char* ppSecAttr[5];
            ppSecAttr[0] = "id";
            ppSecAttr[2] = "type";
            
            if (m_AW_evenFooterSectionID.empty()) {
                ppSecAttr[1] = m_AW_footerSectionID.utf8_str();
                ppSecAttr[3] = "footer";
            } else {
                ppSecAttr[1] = m_AW_evenFooterSectionID.utf8_str();
                ppSecAttr[3] = "footer-even";
            }
            
            ppSecAttr[4] = 0;
            
            m_pAbiDocument->appendStrux(PTX_Section, ppSecAttr);
            
            rAction.pushState("TextContent");
        
        } else {
            
            UT_uint32 id;
            char buffer[500];
            
            id = m_pAbiDocument->getUID(UT_UniqueId::HeaderFtr);
            sprintf(buffer, "%u", id);
            
            if (m_AW_footerSectionID.empty()) {
                m_AW_footerSectionID = buffer;
            } else {
                m_AW_evenFooterSectionID = buffer;
            }
            
            rAction.postponeElementParsing(this, false);
            
            m_postponedFooterParsing = true;
        }
    } else if (!UT_strcmp("style:header-left", pName)) {
        
        if (m_postponedHeaderLeftParsing) {
            
            const XML_Char* ppSecAttr[5];
            ppSecAttr[0] = "id";
            ppSecAttr[1] = m_AW_headerSectionID.utf8_str();
            ppSecAttr[2] = "type";
            ppSecAttr[3] = "header";
            ppSecAttr[4] = 0;
            
            m_pAbiDocument->appendStrux(PTX_Section, ppSecAttr);
            
            rAction.pushState("TextContent");
        
        } else {
            
            UT_uint32 id;
            char buffer[500];
            
            id = m_pAbiDocument->getUID(UT_UniqueId::HeaderFtr);
            sprintf(buffer, "%u", id);
            
            if (!m_AW_headerSectionID.empty()) {
                m_AW_evenHeaderSectionID = m_AW_headerSectionID;
            }
            
            m_AW_headerSectionID = buffer;
            
            rAction.postponeElementParsing(this, false);
            
            m_postponedHeaderLeftParsing = true;
        }
    } else if (!UT_strcmp("style:footer-left", pName)) {
        
        if (m_postponedFooterLeftParsing) {
            
            const XML_Char* ppSecAttr[5];
            ppSecAttr[0] = "id";
            ppSecAttr[1] = m_AW_footerSectionID.utf8_str();
            ppSecAttr[2] = "type";
            ppSecAttr[3] = "footer";
            ppSecAttr[4] = 0;
            
            m_pAbiDocument->appendStrux(PTX_Section, ppSecAttr);
            
            rAction.pushState("TextContent");
        
        } else {
            
            UT_uint32 id;
            char buffer[500];
            
            id = m_pAbiDocument->getUID(UT_UniqueId::HeaderFtr);
            sprintf(buffer, "%u", id);
            
            if (!m_AW_footerSectionID.empty()) {
                m_AW_evenFooterSectionID = m_AW_footerSectionID;
            }
            
            m_AW_footerSectionID = buffer;
            
            rAction.postponeElementParsing(this, false);
            
            m_postponedFooterLeftParsing = true;
        }
    }
}





/**
 * 
 */ 
void OD_Style_MasterPage::endElement(const XML_Char* pName,
                                     OD_ListenerStateAction& rAction) {
                                        
    if (!UT_strcmp("style:master-page", pName)) {
        rAction.popState();
    }
}
