/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */
 
// Class definition include
#include "OD_ContentStream_ListenerState.h"

// Internal includes
#include "OD_Office_Styles.h"
#include "OD_StartTag.h"
#include "OD_Style_Style.h"
#include "OD_ListenerStateAction.h"



/**
 * Constructor
 */
OD_ContentStream_ListenerState::OD_ContentStream_ListenerState (
                PD_Document* pDocument,
                GsfInfile* pGsfInfile,
                OD_Office_Styles* pStyles)
                : OD_ListenerState("ContentStream"),
                  m_pAbiDocument (pDocument),
                  m_pStyles(pStyles),
                  m_pGsfInfile(pGsfInfile)
{
    UT_ASSERT(m_pAbiDocument);
    UT_ASSERT(m_pStyles);
    UT_ASSERT(m_pGsfInfile);
}


/**
 * Destructor
 */
OD_ContentStream_ListenerState::~OD_ContentStream_ListenerState()
{
}


/**
 * Called when the XML parser finds a start element tag.
 * 
 * @param pName The name of the element.
 * @param ppAtts The attributes of the parsed start tag.
 */
void OD_ContentStream_ListenerState::startElement (const XML_Char* pName,
                                               const XML_Char** ppAtts,
                                               OD_ListenerStateAction& rAction)
{
    if (!UT_strcmp(pName, "office:body")) {

        // Here comes the document itself. So, at this point, all styles have
        // already been defined.
        m_pStyles->addedAllStyles(m_pAbiDocument);

    } else if (!UT_strcmp(pName, "style:style")) {
        OD_ListenerState* pStyle;
        
        if (!UT_strcmp("office:automatic-styles",
                       m_elementStack.getStartTag(0)->getName())) {
                        
            pStyle = m_pStyles->addStyle(ppAtts, true, true);
            rAction.pushState(pStyle, false);
            
        } else {
            UT_ASSERT(UT_SHOULD_NOT_HAPPEN);
        }
        
    } else if (!UT_strcmp(pName, "office:text")) {
        rAction.pushState("TextContent");
    }
    
    m_elementStack.startElement(pName, ppAtts);
}


/**
 *
 */
void OD_ContentStream_ListenerState::endElement (const XML_Char* pName,
                                                OD_ListenerStateAction& rAction)
{
    m_elementStack.endElement(pName);
}


/**
 * 
 */
void OD_ContentStream_ListenerState::charData (
                            const XML_Char* pBuffer, int length)
{
}
